package org.pdb.beans;

/**
 *  Data items in the STRUCT_CONN category record details about
 *  the connections between portions of the structure. These can be
 *  hydrogen bonds, salt bridges, disulfide bridges and so on.
 *  
 *  The STRUCT_CONN_TYPE records define the criteria used to
 *  identify these connections.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_connCategory>
 *  <PDBx:struct_conn id="C1">
 *  <PDBx:conn_type_id>saltbr</PDBx:conn_type_id>
 *  <PDBx:ptnr1_label_comp_id>ARG</PDBx:ptnr1_label_comp_id>
 *  <PDBx:ptnr1_label_asym_id>A</PDBx:ptnr1_label_asym_id>
 *  <PDBx:ptnr1_label_seq_id>87</PDBx:ptnr1_label_seq_id>
 *  <PDBx:ptnr1_label_atom_id>NZ1</PDBx:ptnr1_label_atom_id>
 *  <PDBx:ptnr1_role>positive</PDBx:ptnr1_role>
 *  <PDBx:ptnr1_symmetry>1_555</PDBx:ptnr1_symmetry>
 *  <PDBx:ptnr2_label_comp_id>GLU</PDBx:ptnr2_label_comp_id>
 *  <PDBx:ptnr2_label_asym_id>A</PDBx:ptnr2_label_asym_id>
 *  <PDBx:ptnr2_label_seq_id>92</PDBx:ptnr2_label_seq_id>
 *  <PDBx:ptnr2_label_atom_id>OE1</PDBx:ptnr2_label_atom_id>
 *  <PDBx:ptnr2_role>negative</PDBx:ptnr2_role>
 *  <PDBx:ptnr2_symmetry>1_555</PDBx:ptnr2_symmetry>
 *  </PDBx:struct_conn>
 *  <PDBx:struct_conn id="C2">
 *  <PDBx:conn_type_id>hydrog</PDBx:conn_type_id>
 *  <PDBx:ptnr1_label_comp_id>ARG</PDBx:ptnr1_label_comp_id>
 *  <PDBx:ptnr1_label_asym_id>B</PDBx:ptnr1_label_asym_id>
 *  <PDBx:ptnr1_label_seq_id>287</PDBx:ptnr1_label_seq_id>
 *  <PDBx:ptnr1_label_atom_id>N</PDBx:ptnr1_label_atom_id>
 *  <PDBx:ptnr1_role>donor</PDBx:ptnr1_role>
 *  <PDBx:ptnr1_symmetry>1_555</PDBx:ptnr1_symmetry>
 *  <PDBx:ptnr2_label_comp_id>GLY</PDBx:ptnr2_label_comp_id>
 *  <PDBx:ptnr2_label_asym_id>B</PDBx:ptnr2_label_asym_id>
 *  <PDBx:ptnr2_label_seq_id>292</PDBx:ptnr2_label_seq_id>
 *  <PDBx:ptnr2_label_atom_id>O</PDBx:ptnr2_label_atom_id>
 *  <PDBx:ptnr2_role>acceptor</PDBx:ptnr2_role>
 *  <PDBx:ptnr2_symmetry>1_555</PDBx:ptnr2_symmetry>
 *  </PDBx:struct_conn>
 *  </PDBx:struct_connCategory>
 * </pre>
 */
public class Struct_conn 
{
		protected java.lang.String conn_type_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_conn_type in the
	 *  STRUCT_CONN_TYPE category.
	 */
	public java.lang.String getConn_type_id() 
	{
		return conn_type_id;
	}
 
	public void setConn_type_id(java.lang.String conn_type_id)
	{
		this.conn_type_id = conn_type_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the connection.
	 *  disulfide bridge C-S-S-C is highly distorted
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_conn must uniquely identify a record in
	 *  the STRUCT_CONN list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_PDB_id;


	/**
	 *  A placeholder for the PDB id in the case the category
	 *  is used to hold the information of the MODRES record of
	 *  a PDB file.
	 *  1ABC
	 */
	public java.lang.String getPdbx_PDB_id() 
	{
		return pdbx_PDB_id;
	}
 
	public void setPdbx_PDB_id(java.lang.String pdbx_PDB_id)
	{
		this.pdbx_PDB_id = pdbx_PDB_id;
	}

 	protected java.lang.Float pdbx_dist_value;


	/**
	 *  Distance value for this contact.
	 */
	public java.lang.Float getPdbx_dist_value() 
	{
		return pdbx_dist_value;
	}
 
	public void setPdbx_dist_value(java.lang.Float pdbx_dist_value)
	{
		this.pdbx_dist_value = pdbx_dist_value;
	}

 	protected java.lang.String pdbx_ptnr1_PDB_ins_code;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_ins_code in category atom_site in the
	 *  ATOM_SITE category.
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_ptnr1_PDB_ins_code() 
	{
		return pdbx_ptnr1_PDB_ins_code;
	}
 
	public void setPdbx_ptnr1_PDB_ins_code(java.lang.String pdbx_ptnr1_PDB_ins_code)
	{
		this.pdbx_ptnr1_PDB_ins_code = pdbx_ptnr1_PDB_ins_code;
	}

 	protected java.lang.String pdbx_ptnr1_auth_alt_id;


	/**
	 *  A component of the identifier for partner 1 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute pdbx_auth_alt_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  B
	 */
	public java.lang.String getPdbx_ptnr1_auth_alt_id() 
	{
		return pdbx_ptnr1_auth_alt_id;
	}
 
	public void setPdbx_ptnr1_auth_alt_id(java.lang.String pdbx_ptnr1_auth_alt_id)
	{
		this.pdbx_ptnr1_auth_alt_id = pdbx_ptnr1_auth_alt_id;
	}

 	protected java.lang.String pdbx_ptnr1_label_alt_id;


	/**
	 *  A component of the identifier for partner 1 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute label_alt_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  B
	 */
	public java.lang.String getPdbx_ptnr1_label_alt_id() 
	{
		return pdbx_ptnr1_label_alt_id;
	}
 
	public void setPdbx_ptnr1_label_alt_id(java.lang.String pdbx_ptnr1_label_alt_id)
	{
		this.pdbx_ptnr1_label_alt_id = pdbx_ptnr1_label_alt_id;
	}

 	protected java.lang.String pdbx_ptnr1_standard_comp_id;


	/**
	 *  A placeholder for the standard residue name found in
	 *  the MODRES record of a PDB file.
	 *  A
	 *  T
	 *  C
	 *  G
	 *  GLY
	 *  ALA
	 *  MET
	 */
	public java.lang.String getPdbx_ptnr1_standard_comp_id() 
	{
		return pdbx_ptnr1_standard_comp_id;
	}
 
	public void setPdbx_ptnr1_standard_comp_id(java.lang.String pdbx_ptnr1_standard_comp_id)
	{
		this.pdbx_ptnr1_standard_comp_id = pdbx_ptnr1_standard_comp_id;
	}

 	protected java.lang.String pdbx_ptnr2_PDB_ins_code;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_ins_code in category atom_site in the
	 *  ATOM_SITE category.
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_ptnr2_PDB_ins_code() 
	{
		return pdbx_ptnr2_PDB_ins_code;
	}
 
	public void setPdbx_ptnr2_PDB_ins_code(java.lang.String pdbx_ptnr2_PDB_ins_code)
	{
		this.pdbx_ptnr2_PDB_ins_code = pdbx_ptnr2_PDB_ins_code;
	}

 	protected java.lang.String pdbx_ptnr2_auth_alt_id;


	/**
	 *  A component of the identifier for partner 2 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute pdbx_auth_alt_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  B
	 */
	public java.lang.String getPdbx_ptnr2_auth_alt_id() 
	{
		return pdbx_ptnr2_auth_alt_id;
	}
 
	public void setPdbx_ptnr2_auth_alt_id(java.lang.String pdbx_ptnr2_auth_alt_id)
	{
		this.pdbx_ptnr2_auth_alt_id = pdbx_ptnr2_auth_alt_id;
	}

 	protected java.lang.String pdbx_ptnr2_label_alt_id;


	/**
	 *  A component of the identifier for partner 2 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute label_alt_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  B
	 */
	public java.lang.String getPdbx_ptnr2_label_alt_id() 
	{
		return pdbx_ptnr2_label_alt_id;
	}
 
	public void setPdbx_ptnr2_label_alt_id(java.lang.String pdbx_ptnr2_label_alt_id)
	{
		this.pdbx_ptnr2_label_alt_id = pdbx_ptnr2_label_alt_id;
	}

 	protected java.lang.String pdbx_ptnr3_PDB_ins_code;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute pdbx_PDB_ins_code in category atom_site in the ATOM_SITE category.
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_ptnr3_PDB_ins_code() 
	{
		return pdbx_ptnr3_PDB_ins_code;
	}
 
	public void setPdbx_ptnr3_PDB_ins_code(java.lang.String pdbx_ptnr3_PDB_ins_code)
	{
		this.pdbx_ptnr3_PDB_ins_code = pdbx_ptnr3_PDB_ins_code;
	}

 	protected java.lang.String pdbx_ptnr3_auth_alt_id;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute pdbx_auth_alt_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  B
	 */
	public java.lang.String getPdbx_ptnr3_auth_alt_id() 
	{
		return pdbx_ptnr3_auth_alt_id;
	}
 
	public void setPdbx_ptnr3_auth_alt_id(java.lang.String pdbx_ptnr3_auth_alt_id)
	{
		this.pdbx_ptnr3_auth_alt_id = pdbx_ptnr3_auth_alt_id;
	}

 	protected java.lang.String pdbx_ptnr3_auth_asym_id;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute auth_asym_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  B
	 *  C
	 */
	public java.lang.String getPdbx_ptnr3_auth_asym_id() 
	{
		return pdbx_ptnr3_auth_asym_id;
	}
 
	public void setPdbx_ptnr3_auth_asym_id(java.lang.String pdbx_ptnr3_auth_asym_id)
	{
		this.pdbx_ptnr3_auth_asym_id = pdbx_ptnr3_auth_asym_id;
	}

 	protected java.lang.String pdbx_ptnr3_auth_atom_id;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute auth_atom_id in category atom_site in the ATOM_SITE category.
	 *  O5*
	 */
	public java.lang.String getPdbx_ptnr3_auth_atom_id() 
	{
		return pdbx_ptnr3_auth_atom_id;
	}
 
	public void setPdbx_ptnr3_auth_atom_id(java.lang.String pdbx_ptnr3_auth_atom_id)
	{
		this.pdbx_ptnr3_auth_atom_id = pdbx_ptnr3_auth_atom_id;
	}

 	protected java.lang.String pdbx_ptnr3_auth_comp_id;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute auth_comp_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  T
	 *  C
	 *  G
	 *  GLY
	 *  ALA
	 *  MET
	 */
	public java.lang.String getPdbx_ptnr3_auth_comp_id() 
	{
		return pdbx_ptnr3_auth_comp_id;
	}
 
	public void setPdbx_ptnr3_auth_comp_id(java.lang.String pdbx_ptnr3_auth_comp_id)
	{
		this.pdbx_ptnr3_auth_comp_id = pdbx_ptnr3_auth_comp_id;
	}

 	protected java.lang.String pdbx_ptnr3_auth_seq_id;


	/**
	 *  A component of the identifier for partner 1 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute auth_seq_id in category atom_site in the ATOM_SITE category.
	 *  12
	 */
	public java.lang.String getPdbx_ptnr3_auth_seq_id() 
	{
		return pdbx_ptnr3_auth_seq_id;
	}
 
	public void setPdbx_ptnr3_auth_seq_id(java.lang.String pdbx_ptnr3_auth_seq_id)
	{
		this.pdbx_ptnr3_auth_seq_id = pdbx_ptnr3_auth_seq_id;
	}

 	protected java.lang.String pdbx_ptnr3_label_alt_id;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute label_alt_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  B
	 */
	public java.lang.String getPdbx_ptnr3_label_alt_id() 
	{
		return pdbx_ptnr3_label_alt_id;
	}
 
	public void setPdbx_ptnr3_label_alt_id(java.lang.String pdbx_ptnr3_label_alt_id)
	{
		this.pdbx_ptnr3_label_alt_id = pdbx_ptnr3_label_alt_id;
	}

 	protected java.lang.String pdbx_ptnr3_label_asym_id;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute label_asym_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  B
	 *  C
	 */
	public java.lang.String getPdbx_ptnr3_label_asym_id() 
	{
		return pdbx_ptnr3_label_asym_id;
	}
 
	public void setPdbx_ptnr3_label_asym_id(java.lang.String pdbx_ptnr3_label_asym_id)
	{
		this.pdbx_ptnr3_label_asym_id = pdbx_ptnr3_label_asym_id;
	}

 	protected java.lang.String pdbx_ptnr3_label_atom_id;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute label_atom_id in category atom_site in the ATOM_SITE category.
	 *  O5*
	 */
	public java.lang.String getPdbx_ptnr3_label_atom_id() 
	{
		return pdbx_ptnr3_label_atom_id;
	}
 
	public void setPdbx_ptnr3_label_atom_id(java.lang.String pdbx_ptnr3_label_atom_id)
	{
		this.pdbx_ptnr3_label_atom_id = pdbx_ptnr3_label_atom_id;
	}

 	protected java.lang.String pdbx_ptnr3_label_comp_id;


	/**
	 *  A component of the identifier for partner 3 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute label_comp_id in category atom_site in the ATOM_SITE category.
	 *  A
	 *  T
	 *  C
	 *  G
	 *  GLY
	 *  ALA
	 *  MET
	 */
	public java.lang.String getPdbx_ptnr3_label_comp_id() 
	{
		return pdbx_ptnr3_label_comp_id;
	}
 
	public void setPdbx_ptnr3_label_comp_id(java.lang.String pdbx_ptnr3_label_comp_id)
	{
		this.pdbx_ptnr3_label_comp_id = pdbx_ptnr3_label_comp_id;
	}

 	protected java.lang.Integer pdbx_ptnr3_label_seq_id;


	/**
	 *  A component of the identifier for partner 1 of the
	 *  structure connection. This data item is a pointer to
	 *  attribute label_seq_id in category atom_site in the ATOM_SITE category.
	 *  12
	 */
	public java.lang.Integer getPdbx_ptnr3_label_seq_id() 
	{
		return pdbx_ptnr3_label_seq_id;
	}
 
	public void setPdbx_ptnr3_label_seq_id(java.lang.Integer pdbx_ptnr3_label_seq_id)
	{
		this.pdbx_ptnr3_label_seq_id = pdbx_ptnr3_label_seq_id;
	}

 	protected java.lang.String ptnr1_auth_asym_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr1_auth_asym_id() 
	{
		return ptnr1_auth_asym_id;
	}
 
	public void setPtnr1_auth_asym_id(java.lang.String ptnr1_auth_asym_id)
	{
		this.ptnr1_auth_asym_id = ptnr1_auth_asym_id;
	}

 	protected java.lang.String ptnr1_auth_atom_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr1_auth_atom_id() 
	{
		return ptnr1_auth_atom_id;
	}
 
	public void setPtnr1_auth_atom_id(java.lang.String ptnr1_auth_atom_id)
	{
		this.ptnr1_auth_atom_id = ptnr1_auth_atom_id;
	}

 	protected java.lang.String ptnr1_auth_comp_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr1_auth_comp_id() 
	{
		return ptnr1_auth_comp_id;
	}
 
	public void setPtnr1_auth_comp_id(java.lang.String ptnr1_auth_comp_id)
	{
		this.ptnr1_auth_comp_id = ptnr1_auth_comp_id;
	}

 	protected java.lang.String ptnr1_auth_seq_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr1_auth_seq_id() 
	{
		return ptnr1_auth_seq_id;
	}
 
	public void setPtnr1_auth_seq_id(java.lang.String ptnr1_auth_seq_id)
	{
		this.ptnr1_auth_seq_id = ptnr1_auth_seq_id;
	}

 	protected java.lang.String ptnr1_label_alt_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getPtnr1_label_alt_id() 
	{
		return ptnr1_label_alt_id;
	}
 
	public void setPtnr1_label_alt_id(java.lang.String ptnr1_label_alt_id)
	{
		this.ptnr1_label_alt_id = ptnr1_label_alt_id;
	}

 	protected java.lang.String ptnr1_label_asym_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr1_label_asym_id() 
	{
		return ptnr1_label_asym_id;
	}
 
	public void setPtnr1_label_asym_id(java.lang.String ptnr1_label_asym_id)
	{
		this.ptnr1_label_asym_id = ptnr1_label_asym_id;
	}

 	protected java.lang.String ptnr1_label_atom_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getPtnr1_label_atom_id() 
	{
		return ptnr1_label_atom_id;
	}
 
	public void setPtnr1_label_atom_id(java.lang.String ptnr1_label_atom_id)
	{
		this.ptnr1_label_atom_id = ptnr1_label_atom_id;
	}

 	protected java.lang.String ptnr1_label_comp_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr1_label_comp_id() 
	{
		return ptnr1_label_comp_id;
	}
 
	public void setPtnr1_label_comp_id(java.lang.String ptnr1_label_comp_id)
	{
		this.ptnr1_label_comp_id = ptnr1_label_comp_id;
	}

 	protected java.lang.Integer ptnr1_label_seq_id;


	/**
	 *  A component of the identifier for partner 1 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getPtnr1_label_seq_id() 
	{
		return ptnr1_label_seq_id;
	}
 
	public void setPtnr1_label_seq_id(java.lang.Integer ptnr1_label_seq_id)
	{
		this.ptnr1_label_seq_id = ptnr1_label_seq_id;
	}

 	protected java.lang.String ptnr1_role;


	/**
	 *  The chemical or structural role of the first partner in
	 *  the structure connection.
	 *  donor
	 *  acceptor
	 *  negative
	 *  positive
	 *  metal
	 *  metal coordination
	 */
	public java.lang.String getPtnr1_role() 
	{
		return ptnr1_role;
	}
 
	public void setPtnr1_role(java.lang.String ptnr1_role)
	{
		this.ptnr1_role = ptnr1_role;
	}

 	protected java.lang.String ptnr1_symmetry;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  atom set specified by  attribute ptnr1_label* in category struct_conn to generate the
	 *  first partner in the structure connection.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getPtnr1_symmetry() 
	{
		return ptnr1_symmetry;
	}
 
	public void setPtnr1_symmetry(java.lang.String ptnr1_symmetry)
	{
		this.ptnr1_symmetry = ptnr1_symmetry;
	}

 	protected java.lang.String ptnr2_auth_asym_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr2_auth_asym_id() 
	{
		return ptnr2_auth_asym_id;
	}
 
	public void setPtnr2_auth_asym_id(java.lang.String ptnr2_auth_asym_id)
	{
		this.ptnr2_auth_asym_id = ptnr2_auth_asym_id;
	}

 	protected java.lang.String ptnr2_auth_atom_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr2_auth_atom_id() 
	{
		return ptnr2_auth_atom_id;
	}
 
	public void setPtnr2_auth_atom_id(java.lang.String ptnr2_auth_atom_id)
	{
		this.ptnr2_auth_atom_id = ptnr2_auth_atom_id;
	}

 	protected java.lang.String ptnr2_auth_comp_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr2_auth_comp_id() 
	{
		return ptnr2_auth_comp_id;
	}
 
	public void setPtnr2_auth_comp_id(java.lang.String ptnr2_auth_comp_id)
	{
		this.ptnr2_auth_comp_id = ptnr2_auth_comp_id;
	}

 	protected java.lang.String ptnr2_auth_seq_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr2_auth_seq_id() 
	{
		return ptnr2_auth_seq_id;
	}
 
	public void setPtnr2_auth_seq_id(java.lang.String ptnr2_auth_seq_id)
	{
		this.ptnr2_auth_seq_id = ptnr2_auth_seq_id;
	}

 	protected java.lang.String ptnr2_label_alt_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getPtnr2_label_alt_id() 
	{
		return ptnr2_label_alt_id;
	}
 
	public void setPtnr2_label_alt_id(java.lang.String ptnr2_label_alt_id)
	{
		this.ptnr2_label_alt_id = ptnr2_label_alt_id;
	}

 	protected java.lang.String ptnr2_label_asym_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr2_label_asym_id() 
	{
		return ptnr2_label_asym_id;
	}
 
	public void setPtnr2_label_asym_id(java.lang.String ptnr2_label_asym_id)
	{
		this.ptnr2_label_asym_id = ptnr2_label_asym_id;
	}

 	protected java.lang.String ptnr2_label_atom_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getPtnr2_label_atom_id() 
	{
		return ptnr2_label_atom_id;
	}
 
	public void setPtnr2_label_atom_id(java.lang.String ptnr2_label_atom_id)
	{
		this.ptnr2_label_atom_id = ptnr2_label_atom_id;
	}

 	protected java.lang.String ptnr2_label_comp_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getPtnr2_label_comp_id() 
	{
		return ptnr2_label_comp_id;
	}
 
	public void setPtnr2_label_comp_id(java.lang.String ptnr2_label_comp_id)
	{
		this.ptnr2_label_comp_id = ptnr2_label_comp_id;
	}

 	protected java.lang.Integer ptnr2_label_seq_id;


	/**
	 *  A component of the identifier for partner 2 of the structure
	 *  connection.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getPtnr2_label_seq_id() 
	{
		return ptnr2_label_seq_id;
	}
 
	public void setPtnr2_label_seq_id(java.lang.Integer ptnr2_label_seq_id)
	{
		this.ptnr2_label_seq_id = ptnr2_label_seq_id;
	}

 	protected java.lang.String ptnr2_role;


	/**
	 *  The chemical or structural role of the second partner in
	 *  the structure connection.
	 *  donor
	 *  acceptor
	 *  negative
	 *  positive
	 *  metal
	 *  metal coordination
	 */
	public java.lang.String getPtnr2_role() 
	{
		return ptnr2_role;
	}
 
	public void setPtnr2_role(java.lang.String ptnr2_role)
	{
		this.ptnr2_role = ptnr2_role;
	}

 	protected java.lang.String ptnr2_symmetry;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  atom set specified by  attribute ptnr2_label* in category struct_conn to generate the
	 *  second partner in the structure connection.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getPtnr2_symmetry() 
	{
		return ptnr2_symmetry;
	}
 
	public void setPtnr2_symmetry(java.lang.String ptnr2_symmetry)
	{
		this.ptnr2_symmetry = ptnr2_symmetry;
	}

 }
