package org.pdb.beans;

/**
 *  Data items in the STRUCT_KEYWORDS category specify keywords
 *  that describe the chemical structure in this entry.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_keywordsCategory>
 *  <PDBx:struct_keywords entry_id="5HVP">
 *  <PDBx:text>enzyme-inhibitor complex, aspartyl protease, static disorder</PDBx:text>
 *  </PDBx:struct_keywords>
 *  </PDBx:struct_keywordsCategory>
 * </pre>
 */
public class Struct_keywords 
{
		protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String pdbx_keywords;


	/**
	 *  DNA
	 *  RNA
	 *  T-RNA
	 *  DNA/RNA
	 *  RIBOZYME
	 *  PROTEIN/DNA
	 *  PROTEIN/RNA
	 *  PEPTIDE NUCLEIC ACID
	 *  PEPTIDE NUCLEIC ACID/DNA
	 *  DNA-BINDING PROTEIN
	 *  RNA-BINDING PROTEIN
	 */
	public java.lang.String getPdbx_keywords() 
	{
		return pdbx_keywords;
	}
 
	public void setPdbx_keywords(java.lang.String pdbx_keywords)
	{
		this.pdbx_keywords = pdbx_keywords;
	}

 	protected java.lang.String text;


	/**
	 *  Keywords describing this structure.
	 *  serine protease
	 *  inhibited complex
	 *  high-resolution refinement
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 }
