package org.pdb.beans;

/**
 *  Data items in the STRUCT_MON_PROT category record details about
 *  structural properties of a protein when analyzed at the monomer
 *  level. Analogous data items for nucleic acids are given in the
 *  STRUCT_MON_NUCL category. For items where the value of the
 *  property depends on the method employed to calculate it,
 *  details of the method of calculation are given using data items
 *  in the STRUCT_MON_DETAILS category.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for protein NS1.
 *  This example provides details for residue ARG 35.
 *  <PDBx:struct_mon_protCategory>
 *  <PDBx:struct_mon_prot label_comp_id="ARG" label_seq_id="35" label_asym_id="A" label_alt_id="">
 *  <PDBx:chi1>-67.9</PDBx:chi1>
 *  <PDBx:chi2>-174.7</PDBx:chi2>
 *  <PDBx:chi3>-67.7</PDBx:chi3>
 *  <PDBx:chi4>-86.3</PDBx:chi4>
 *  <PDBx:chi5>4.2</PDBx:chi5>
 *  <PDBx:RSCC_all>0.90</PDBx:RSCC_all>
 *  <PDBx:RSR_all>0.18</PDBx:RSR_all>
 *  <PDBx:mean_B_all>30.0</PDBx:mean_B_all>
 *  <PDBx:mean_B_main>25.0</PDBx:mean_B_main>
 *  <PDBx:mean_B_side>35.1</PDBx:mean_B_side>
 *  <PDBx:omega>180.1</PDBx:omega>
 *  <PDBx:phi>-60.3</PDBx:phi>
 *  <PDBx:psi>-46.0</PDBx:psi>
 *  </PDBx:struct_mon_prot>
 *  </PDBx:struct_mon_protCategory>
 * </pre>
 */
public class Struct_mon_prot 
{
		protected java.lang.Float RSCC_all;


	/**
	 *  The real-space (linear) correlation coefficient RSCC, as
	 *  described by Jones et al. (1991),  evaluated over all atoms
	 *  in the monomer.
	 *  
	 *  sum|p~obs~ - <p~obs~>| * sum|p~calc~ - <p~calc~>|
	 *  RSCC = -------------------------------------------------
	 *  [ sum|p~obs~  - <p~obs~> |^2^
	 *  * sum|p~calc~ - <p~calc~>|^2^ ]^1/2^
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSCC in category struct_mon_details.  < > indicates an average and the
	 *  sums are taken over all map grid  points near the relevant atoms.
	 *  The radius for including grid points in the calculation should
	 *  also be given in  attribute RSCC.
	 *  in category struct_mon_details
	 *  Ref: Jones, T. A., Zou, J.-Y., Cowan, S. W. & Kjeldgaard, M.
	 *  (1991). Acta Cryst. A47, 110-119.
	 */
	public java.lang.Float getRSCC_all() 
	{
		return RSCC_all;
	}
 
	public void setRSCC_all(java.lang.Float RSCC_all)
	{
		this.RSCC_all = RSCC_all;
	}

 	protected java.lang.Float RSCC_main;


	/**
	 *  The real-space (linear) correlation coefficient RSCC, as
	 *  described by Jones et al. (1991), evaluated over all atoms
	 *  in the main chain of the monomer.
	 *  
	 *  sum|p~obs~ - <p~obs~>| * sum|p~calc~ - <p~calc~>|
	 *  RSCC = -------------------------------------------------
	 *  [ sum|p~obs~  - <p~obs~> |^2^
	 *  * sum|p~calc~ - <p~calc~>|^2^ ]^1/2^
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSCC in category struct_mon_details.  < > indicates an average and the
	 *  sums are taken over all map grid  points near the relevant atoms.
	 *  The radius for including grid points in the calculation should
	 *  also be given in  attribute RSCC.
	 *  in category struct_mon_details
	 *  Ref: Jones, T. A., Zou, J.-Y., Cowan, S. W. & Kjeldgaard, M.
	 *  (1991). Acta Cryst. A47, 110-119.
	 */
	public java.lang.Float getRSCC_main() 
	{
		return RSCC_main;
	}
 
	public void setRSCC_main(java.lang.Float RSCC_main)
	{
		this.RSCC_main = RSCC_main;
	}

 	protected java.lang.Float RSCC_side;


	/**
	 *  The real-space (linear) correlation coefficient RSCC, as
	 *  described by Jones et al. (1991), evaluated over all atoms
	 *  in the side chain of the monomer.
	 *  
	 *  sum|p~obs~ - <p~obs~>| * sum|p~calc~ - <p~calc~>|
	 *  RSCC = -------------------------------------------------
	 *  [ sum|p~obs~  - <p~obs~> |^2^
	 *  * sum|p~calc~ - <p~calc~>|^2^ ]^1/2^
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSCC in category struct_mon_details.  < > indicates an average and the
	 *  sums are taken over all map grid  points near the relevant atoms.
	 *  The radius for including grid points in the calculation should
	 *  also be given in  attribute RSCC.
	 *  in category struct_mon_details
	 *  Ref: Jones, T. A., Zou, J.-Y., Cowan, S. W. & Kjeldgaard, M.
	 *  (1991). Acta Cryst. A47, 110-119.
	 */
	public java.lang.Float getRSCC_side() 
	{
		return RSCC_side;
	}
 
	public void setRSCC_side(java.lang.Float RSCC_side)
	{
		this.RSCC_side = RSCC_side;
	}

 	protected java.lang.Float RSR_all;


	/**
	 *  The real-space residual RSR, as described by Branden & Jones
	 *  (1990), evaluated over all atoms in the monomer.
	 *  
	 *  sum|p~obs~ - p~calc~|
	 *  RSR = ---------------------
	 *  sum|p~obs~ + p~calc~|
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSR in category struct_mon_details.  The sums are taken over all map grid
	 *  points near the relevant atoms. The radius for including grid
	 *  points in the calculation should also be given in
	 *  attribute RSR.
	 *  in category struct_mon_details
	 *  Ref: Branden, C.-I. & Jones, T. A. (1990). Nature (London), 343,
	 *  687-689.
	 */
	public java.lang.Float getRSR_all() 
	{
		return RSR_all;
	}
 
	public void setRSR_all(java.lang.Float RSR_all)
	{
		this.RSR_all = RSR_all;
	}

 	protected java.lang.Float RSR_main;


	/**
	 *  The real-space residual RSR, as described by Branden & Jones
	 *  (1990), evaluated over all atoms in the main chain of the
	 *  monomer.
	 *  
	 *  sum|p~obs~ - p~calc~|
	 *  RSR = ---------------------
	 *  sum|p~obs~ + p~calc~|
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSR in category struct_mon_details.  The sums are taken over all map grid
	 *  points near the relevant atoms. The radius for including grid
	 *  points in the calculation should also be given in
	 *  attribute RSR.
	 *  in category struct_mon_details
	 *  Ref: Branden, C.-I. & Jones, T. A. (1990). Nature (London), 343,
	 *  687-689.
	 */
	public java.lang.Float getRSR_main() 
	{
		return RSR_main;
	}
 
	public void setRSR_main(java.lang.Float RSR_main)
	{
		this.RSR_main = RSR_main;
	}

 	protected java.lang.Float RSR_side;


	/**
	 *  The real-space residual RSR, as described by Branden & Jones
	 *  (1990), evaluated over all atoms in the side chain of the
	 *  monomer.
	 *  
	 *  sum|p~obs~ - p~calc~|
	 *  RSR = ---------------------
	 *  sum|p~obs~ + p~calc~|
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSR in category struct_mon_details.  The sums are taken over all map grid
	 *  points near the relevant atoms. The radius for including grid
	 *  points in the calculation should also be given in
	 *  attribute RSR.
	 *  in category struct_mon_details
	 *  Ref: Branden, C.-I. & Jones, T. A. (1990). Nature (London), 343,
	 *  687-689.
	 */
	public java.lang.Float getRSR_side() 
	{
		return RSR_side;
	}
 
	public void setRSR_side(java.lang.Float RSR_side)
	{
		this.RSR_side = RSR_side;
	}

 	protected java.lang.String auth_asym_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_asym_id() 
	{
		return auth_asym_id;
	}
 
	public void setAuth_asym_id(java.lang.String auth_asym_id)
	{
		this.auth_asym_id = auth_asym_id;
	}

 	protected java.lang.String auth_comp_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_comp_id() 
	{
		return auth_comp_id;
	}
 
	public void setAuth_comp_id(java.lang.String auth_comp_id)
	{
		this.auth_comp_id = auth_comp_id;
	}

 	protected java.lang.String auth_seq_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_seq_id() 
	{
		return auth_seq_id;
	}
 
	public void setAuth_seq_id(java.lang.String auth_seq_id)
	{
		this.auth_seq_id = auth_seq_id;
	}

 	protected java.lang.Float chi1;


	/**
	 *  The value in degrees of the side-chain torsion angle chi1, for
	 *  those residues containing such an angle.
	 */
	public java.lang.Float getChi1() 
	{
		return chi1;
	}
 
	public void setChi1(java.lang.Float chi1)
	{
		this.chi1 = chi1;
	}

 	protected java.lang.Float chi2;


	/**
	 *  The value in degrees of the side-chain torsion angle chi2, for
	 *  those residues containing such an angle.
	 */
	public java.lang.Float getChi2() 
	{
		return chi2;
	}
 
	public void setChi2(java.lang.Float chi2)
	{
		this.chi2 = chi2;
	}

 	protected java.lang.Float chi3;


	/**
	 *  The value in degrees of the side-chain torsion angle chi3, for
	 *  those residues containing such an angle.
	 */
	public java.lang.Float getChi3() 
	{
		return chi3;
	}
 
	public void setChi3(java.lang.Float chi3)
	{
		this.chi3 = chi3;
	}

 	protected java.lang.Float chi4;


	/**
	 *  The value in degrees of the side-chain torsion angle chi4, for
	 *  those residues containing such an angle.
	 */
	public java.lang.Float getChi4() 
	{
		return chi4;
	}
 
	public void setChi4(java.lang.Float chi4)
	{
		this.chi4 = chi4;
	}

 	protected java.lang.Float chi5;


	/**
	 *  The value in degrees of the side-chain torsion angle chi5, for
	 *  those residues containing such an angle.
	 */
	public java.lang.Float getChi5() 
	{
		return chi5;
	}
 
	public void setChi5(java.lang.Float chi5)
	{
		this.chi5 = chi5;
	}

 	protected java.lang.Float details;


	/**
	 *  A description of special aspects of the residue, its
	 *  conformation, behaviour in refinement, or any other aspect that
	 *  requires annotation.
	 *  very poor density
	 *  The side chain of this density may occupy
	 *  alternative conformations, but alternative
	 *  conformations were not fit in this model.
	 *  This residue has a close contact with the
	 *  bound inhibitor, which may account for
	 *  the nonstandard conformation of the side
	 *  chain.
	 */
	public java.lang.Float getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.Float details)
	{
		this.details = details;
	}

 	protected java.lang.String label_alt_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getLabel_alt_id() 
	{
		return label_alt_id;
	}
 
	public void setLabel_alt_id(java.lang.String label_alt_id)
	{
		this.label_alt_id = label_alt_id;
	}

 	protected java.lang.String label_asym_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_asym_id() 
	{
		return label_asym_id;
	}
 
	public void setLabel_asym_id(java.lang.String label_asym_id)
	{
		this.label_asym_id = label_asym_id;
	}

 	protected java.lang.String label_comp_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_comp_id() 
	{
		return label_comp_id;
	}
 
	public void setLabel_comp_id(java.lang.String label_comp_id)
	{
		this.label_comp_id = label_comp_id;
	}

 	protected java.lang.Integer label_seq_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getLabel_seq_id() 
	{
		return label_seq_id;
	}
 
	public void setLabel_seq_id(java.lang.Integer label_seq_id)
	{
		this.label_seq_id = label_seq_id;
	}

 	protected java.lang.Float mean_B_all;


	/**
	 *  The mean value of the isotropic displacement parameter for all
	 *  atoms in the monomer.
	 */
	public java.lang.Float getMean_B_all() 
	{
		return mean_B_all;
	}
 
	public void setMean_B_all(java.lang.Float mean_B_all)
	{
		this.mean_B_all = mean_B_all;
	}

 	protected java.lang.Float mean_B_main;


	/**
	 *  The mean value of the isotropic displacement parameter for atoms
	 *  in the main chain of the monomer.
	 */
	public java.lang.Float getMean_B_main() 
	{
		return mean_B_main;
	}
 
	public void setMean_B_main(java.lang.Float mean_B_main)
	{
		this.mean_B_main = mean_B_main;
	}

 	protected java.lang.Float mean_B_side;


	/**
	 *  The mean value of the isotropic displacement parameter for atoms
	 *  in the side chain of the monomer.
	 */
	public java.lang.Float getMean_B_side() 
	{
		return mean_B_side;
	}
 
	public void setMean_B_side(java.lang.Float mean_B_side)
	{
		this.mean_B_side = mean_B_side;
	}

 	protected java.lang.Float omega;


	/**
	 *  The value in degrees of the main-chain torsion angle omega.
	 */
	public java.lang.Float getOmega() 
	{
		return omega;
	}
 
	public void setOmega(java.lang.Float omega)
	{
		this.omega = omega;
	}

 	protected java.lang.Float phi;


	/**
	 *  The value in degrees of the main-chain torsion angle phi.
	 */
	public java.lang.Float getPhi() 
	{
		return phi;
	}
 
	public void setPhi(java.lang.Float phi)
	{
		this.phi = phi;
	}

 	protected java.lang.Float psi;


	/**
	 *  The value in degrees of the main-chain torsion angle psi.
	 */
	public java.lang.Float getPsi() 
	{
		return psi;
	}
 
	public void setPsi(java.lang.Float psi)
	{
		this.psi = psi;
	}

 }
