package org.pdb.beans;

/**
 *  Data items in the STRUCT_MON_PROT_CIS category identify
 *  monomers that have been found to have the peptide bond in the cis
 *  conformation. The criterion used to select residues to be
 *  designated as containing cis peptide bonds is given in
 *  attribute prot_cis in category struct_mon_details.
 *  
 * <pre>
 *  Example 1 - based on PDB structure 1ACY of Ghiara, Stura, Stanfield,
 *  Profy & Wilson [Science (1994),  264,  82-85].
 *  <PDBx:struct_mon_prot_cisCategory>
 *  <PDBx:struct_mon_prot_cis label_comp_id="PRO" label_seq_id="8" label_asym_id="L" label_alt_id="" pdbx_PDB_model_num="1"></PDBx:struct_mon_prot_cis>
 *  <PDBx:struct_mon_prot_cis label_comp_id="PRO" label_seq_id="77" label_asym_id="L" label_alt_id="" pdbx_PDB_model_num="1"></PDBx:struct_mon_prot_cis>
 *  <PDBx:struct_mon_prot_cis label_comp_id="PRO" label_seq_id="95" label_asym_id="L" label_alt_id="" pdbx_PDB_model_num="1"></PDBx:struct_mon_prot_cis>
 *  <PDBx:struct_mon_prot_cis label_comp_id="PRO" label_seq_id="141" label_asym_id="L" label_alt_id="" pdbx_PDB_model_num="1"></PDBx:struct_mon_prot_cis>
 *  </PDBx:struct_mon_prot_cisCategory>
 * </pre>
 */
public class Struct_mon_prot_cis 
{
		protected java.lang.String auth_asym_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_asym_id() 
	{
		return auth_asym_id;
	}
 
	public void setAuth_asym_id(java.lang.String auth_asym_id)
	{
		this.auth_asym_id = auth_asym_id;
	}

 	protected java.lang.String auth_comp_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_comp_id() 
	{
		return auth_comp_id;
	}
 
	public void setAuth_comp_id(java.lang.String auth_comp_id)
	{
		this.auth_comp_id = auth_comp_id;
	}

 	protected java.lang.String auth_seq_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_seq_id() 
	{
		return auth_seq_id;
	}
 
	public void setAuth_seq_id(java.lang.String auth_seq_id)
	{
		this.auth_seq_id = auth_seq_id;
	}

 	protected java.lang.String label_alt_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getLabel_alt_id() 
	{
		return label_alt_id;
	}
 
	public void setLabel_alt_id(java.lang.String label_alt_id)
	{
		this.label_alt_id = label_alt_id;
	}

 	protected java.lang.String label_asym_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_asym_id() 
	{
		return label_asym_id;
	}
 
	public void setLabel_asym_id(java.lang.String label_asym_id)
	{
		this.label_asym_id = label_asym_id;
	}

 	protected java.lang.String label_comp_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_comp_id() 
	{
		return label_comp_id;
	}
 
	public void setLabel_comp_id(java.lang.String label_comp_id)
	{
		this.label_comp_id = label_comp_id;
	}

 	protected java.lang.Integer label_seq_id;


	/**
	 *  A component of the identifier for the monomer.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getLabel_seq_id() 
	{
		return label_seq_id;
	}
 
	public void setLabel_seq_id(java.lang.Integer label_seq_id)
	{
		this.label_seq_id = label_seq_id;
	}

 	protected java.lang.String pdbx_PDB_ins_code;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site
	 */
	public java.lang.String getPdbx_PDB_ins_code() 
	{
		return pdbx_PDB_ins_code;
	}
 
	public void setPdbx_PDB_ins_code(java.lang.String pdbx_PDB_ins_code)
	{
		this.pdbx_PDB_ins_code = pdbx_PDB_ins_code;
	}

 	protected java.lang.String pdbx_PDB_ins_code_2;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site
	 */
	public java.lang.String getPdbx_PDB_ins_code_2() 
	{
		return pdbx_PDB_ins_code_2;
	}
 
	public void setPdbx_PDB_ins_code_2(java.lang.String pdbx_PDB_ins_code_2)
	{
		this.pdbx_PDB_ins_code_2 = pdbx_PDB_ins_code_2;
	}

 	protected java.lang.Integer pdbx_PDB_model_num;


	/**
	 *  Pointer to  attribute pdbx_PDB_model_num in category atom_site
	 */
	public java.lang.Integer getPdbx_PDB_model_num() 
	{
		return pdbx_PDB_model_num;
	}
 
	public void setPdbx_PDB_model_num(java.lang.Integer pdbx_PDB_model_num)
	{
		this.pdbx_PDB_model_num = pdbx_PDB_model_num;
	}

 	protected java.lang.String pdbx_auth_asym_id_2;


	/**
	 *  Pointer to  attribute auth_asym_id in category atom_site.
	 */
	public java.lang.String getPdbx_auth_asym_id_2() 
	{
		return pdbx_auth_asym_id_2;
	}
 
	public void setPdbx_auth_asym_id_2(java.lang.String pdbx_auth_asym_id_2)
	{
		this.pdbx_auth_asym_id_2 = pdbx_auth_asym_id_2;
	}

 	protected java.lang.String pdbx_auth_comp_id_2;


	/**
	 *  Pointer to  attribute auth_comp_id in category atom_site.
	 */
	public java.lang.String getPdbx_auth_comp_id_2() 
	{
		return pdbx_auth_comp_id_2;
	}
 
	public void setPdbx_auth_comp_id_2(java.lang.String pdbx_auth_comp_id_2)
	{
		this.pdbx_auth_comp_id_2 = pdbx_auth_comp_id_2;
	}

 	protected java.lang.String pdbx_auth_seq_id_2;


	/**
	 *  Pointer to  attribute auth_seq_id in category atom_site
	 */
	public java.lang.String getPdbx_auth_seq_id_2() 
	{
		return pdbx_auth_seq_id_2;
	}
 
	public void setPdbx_auth_seq_id_2(java.lang.String pdbx_auth_seq_id_2)
	{
		this.pdbx_auth_seq_id_2 = pdbx_auth_seq_id_2;
	}

 	protected java.lang.String pdbx_id;


	/**
	 *  ordinal index
	 */
	public java.lang.String getPdbx_id() 
	{
		return pdbx_id;
	}
 
	public void setPdbx_id(java.lang.String pdbx_id)
	{
		this.pdbx_id = pdbx_id;
	}

 	protected java.lang.String pdbx_label_asym_id_2;


	/**
	 *  Pointer to  attribute label_asym_id in category atom_site.
	 */
	public java.lang.String getPdbx_label_asym_id_2() 
	{
		return pdbx_label_asym_id_2;
	}
 
	public void setPdbx_label_asym_id_2(java.lang.String pdbx_label_asym_id_2)
	{
		this.pdbx_label_asym_id_2 = pdbx_label_asym_id_2;
	}

 	protected java.lang.String pdbx_label_comp_id_2;


	/**
	 *  Pointer to  attribute label_comp_id in category atom_site.
	 */
	public java.lang.String getPdbx_label_comp_id_2() 
	{
		return pdbx_label_comp_id_2;
	}
 
	public void setPdbx_label_comp_id_2(java.lang.String pdbx_label_comp_id_2)
	{
		this.pdbx_label_comp_id_2 = pdbx_label_comp_id_2;
	}

 	protected java.lang.Integer pdbx_label_seq_id_2;


	/**
	 *  Pointer to  attribute label_seq_id in category atom_site
	 */
	public java.lang.Integer getPdbx_label_seq_id_2() 
	{
		return pdbx_label_seq_id_2;
	}
 
	public void setPdbx_label_seq_id_2(java.lang.Integer pdbx_label_seq_id_2)
	{
		this.pdbx_label_seq_id_2 = pdbx_label_seq_id_2;
	}

 	protected java.lang.String pdbx_omega_angle;


	/**
	 *  omega torsion angle
	 */
	public java.lang.String getPdbx_omega_angle() 
	{
		return pdbx_omega_angle;
	}
 
	public void setPdbx_omega_angle(java.lang.String pdbx_omega_angle)
	{
		this.pdbx_omega_angle = pdbx_omega_angle;
	}

 }
