package org.pdb.beans;

/**
 *  Data items in the STRUCT_NCS_DOM category record information
 *  about the domains in an ensemble of domains related by one or
 *  more noncrystallographic symmetry operators.
 *  
 *  A domain need not correspond to a complete polypeptide chain;
 *  it can be composed of one or more segments in a single chain,
 *  or by segments from more than one chain.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:struct_ncs_domCategory>
 *  <PDBx:struct_ncs_dom id="d1">
 *  <PDBx:details>Chains A, B, and C</PDBx:details>
 *  </PDBx:struct_ncs_dom>
 *  <PDBx:struct_ncs_dom id="d2">
 *  <PDBx:details>Chains D, E, and F</PDBx:details>
 *  </PDBx:struct_ncs_dom>
 *  </PDBx:struct_ncs_domCategory>
 * </pre>
 */
public class Struct_ncs_dom 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the structural elements that
	 *  comprise a domain in an ensemble of domains related by
	 *  noncrystallographic symmetry.
	 *  The loop between residues 18 and 23 in this
	 *  domain interacts with a symmetry-related
	 *  molecule, and thus deviates significantly from
	 *  the noncrystallographic threefold.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_ncs_dom must uniquely identify a
	 *  record in the STRUCT_NCS_DOM list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
