package org.pdb.beans;

/**
 *  Data items in the STRUCT_NCS_ENS_GEN category list domains
 *  related by a noncrystallographic symmetry operation and
 *  identify the operator.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:struct_ncs_ens_genCategory>
 *  <PDBx:struct_ncs_ens_gen dom_id_1="d1" dom_id_2="d2" ens_id="en1" oper_id="ncsop1"></PDBx:struct_ncs_ens_gen>
 *  </PDBx:struct_ncs_ens_genCategory>
 * </pre>
 */
public class Struct_ncs_ens_gen 
{
		protected java.lang.String dom_id_1;


	/**
	 *  The identifier for the domain that will remain unchanged by the
	 *  transformation operator.
	 *  
	 *  This data item is a pointer to  attribute id in category struct_ncs_dom in the
	 *  STRUCT_NCS_DOM category.
	 */
	public java.lang.String getDom_id_1() 
	{
		return dom_id_1;
	}
 
	public void setDom_id_1(java.lang.String dom_id_1)
	{
		this.dom_id_1 = dom_id_1;
	}

 	protected java.lang.String dom_id_2;


	/**
	 *  The identifier for the domain that will be transformed by
	 *  application of the transformation operator.
	 *  
	 *  This data item is a pointer to  attribute id in category struct_ncs_dom in the
	 *  STRUCT_NCS_DOM category.
	 */
	public java.lang.String getDom_id_2() 
	{
		return dom_id_2;
	}
 
	public void setDom_id_2(java.lang.String dom_id_2)
	{
		this.dom_id_2 = dom_id_2;
	}

 	protected java.lang.String ens_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_ncs_ens in the
	 *  STRUCT_NCS_ENS category.
	 */
	public java.lang.String getEns_id() 
	{
		return ens_id;
	}
 
	public void setEns_id(java.lang.String ens_id)
	{
		this.ens_id = ens_id;
	}

 	protected java.lang.String oper_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_ncs_oper in the
	 *  STRUCT_NCS_OPER category.
	 */
	public java.lang.String getOper_id() 
	{
		return oper_id;
	}
 
	public void setOper_id(java.lang.String oper_id)
	{
		this.oper_id = oper_id;
	}

 }
