package org.pdb.beans;

/**
 *  Data items in the STRUCT_REF category allow the author of a
 *  data block to relate the entities or biological units
 *  described in the data block to information archived in external
 *  databases.
 *  
 *  For references to the sequence of a polymer, the value of
 *  the data item  attribute seq_align in category struct_ref is used to indicate
 *  whether the correspondence between the sequence of the entity
 *  or biological unit in the data block and the sequence in the
 *  referenced database entry is 'complete' or 'partial'. If
 *  this value is 'partial', the region (or regions) of the
 *  alignment may be delimited using data items in the
 *  STRUCT_REF_SEQ category.
 *  
 *  Similarly, the value of  attribute seq_dif in category struct_ref is used to indicate
 *  whether the two sequences contain point differences. If the
 *  value is 'yes', the differences may be identified and annotated
 *  using data items in the STRUCT_REF_SEQ_DIF category.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_refCategory>
 *  <PDBx:struct_ref id="1">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:db_name>Genbank</PDBx:db_name>
 *  <PDBx:db_code>12345</PDBx:db_code>
 *  <PDBx:seq_align>entire</PDBx:seq_align>
 *  <PDBx:seq_dif>yes</PDBx:seq_dif>
 *  </PDBx:struct_ref>
 *  <PDBx:struct_ref id="2">
 *  <PDBx:entity_id xsi:nil="true" />
 *  <PDBx:biol_id>2</PDBx:biol_id>
 *  <PDBx:db_name>PDB</PDBx:db_name>
 *  <PDBx:db_code>1ABC</PDBx:db_code>
 *  <PDBx:details> The structure of the closely related compound,
 *  isobutyryl-pepstatin (pepstatin A) in complex with
 *  rhizopuspepsin</PDBx:details>
 *  </PDBx:struct_ref>
 *  </PDBx:struct_refCategory>
 * </pre>
 */
public class Struct_ref 
{
		protected java.lang.String biol_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_biol in the
	 *  STRUCT_BIOL category.
	 */
	public java.lang.String getBiol_id() 
	{
		return biol_id;
	}
 
	public void setBiol_id(java.lang.String biol_id)
	{
		this.biol_id = biol_id;
	}

 	protected java.lang.String db_code;


	/**
	 *  The code for this entity or biological unit or for a closely
	 *  related entity or biological unit in the named database.
	 *  1ABC
	 *  ABCDEF
	 */
	public java.lang.String getDb_code() 
	{
		return db_code;
	}
 
	public void setDb_code(java.lang.String db_code)
	{
		this.db_code = db_code;
	}

 	protected java.lang.String db_name;


	/**
	 *  The name of the database containing reference information about
	 *  this entity or biological unit.
	 *  PDB
	 *  CSD
	 *  Genbank
	 */
	public java.lang.String getDb_name() 
	{
		return db_name;
	}
 
	public void setDb_name(java.lang.String db_name)
	{
		this.db_name = db_name;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the relationship between
	 *  the entity or biological unit described in the data block and
	 *  that in the referenced database entry.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_ref must uniquely identify a record
	 *  in the STRUCT_REF list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_align_begin;


	/**
	 *  Beginning index in the chemical sequence from the
	 *  reference database.
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_align_begin() 
	{
		return pdbx_align_begin;
	}
 
	public void setPdbx_align_begin(java.lang.String pdbx_align_begin)
	{
		this.pdbx_align_begin = pdbx_align_begin;
	}

 	protected java.lang.String pdbx_db_accession;


	/**
	 *  Accession code of the reference database.
	 *  P07617
	 */
	public java.lang.String getPdbx_db_accession() 
	{
		return pdbx_db_accession;
	}
 
	public void setPdbx_db_accession(java.lang.String pdbx_db_accession)
	{
		this.pdbx_db_accession = pdbx_db_accession;
	}

 	protected java.lang.String pdbx_seq_one_letter_code;


	/**
	 *  Database chemical sequence expressed as string of one-letter
	 *  amino acid codes.
	 *  
	 *  A  for alanine or adenine
	 *  B  for ambiguous asparagine/aspartic-acid
	 *  R  for arginine
	 *  N  for asparagine
	 *  D  for aspartic-acid
	 *  C  for cysteine or cystine or cytosine
	 *  Q  for glutamine
	 *  E  for glutamic-acid
	 *  Z  for ambiguous glutamine/glutamic acid
	 *  G  for glycine or guanine
	 *  H  for histidine
	 *  I  for isoleucine
	 *  L  for leucine
	 *  K  for lysine
	 *  M  for methionine
	 *  F  for phenylalanine
	 *  P  for proline
	 *  S  for serine
	 *  T  for threonine or thymine
	 *  W  for tryptophan
	 *  Y  for tyrosine
	 *  V  for valine
	 *  U  for uracil
	 *  O  for water
	 *  X  for other
	 */
	public java.lang.String getPdbx_seq_one_letter_code() 
	{
		return pdbx_seq_one_letter_code;
	}
 
	public void setPdbx_seq_one_letter_code(java.lang.String pdbx_seq_one_letter_code)
	{
		this.pdbx_seq_one_letter_code = org.pdb.ormapping.util.Field.removeCrLf(pdbx_seq_one_letter_code);
	}

 	protected java.lang.String seq_align;


	/**
	 *  A flag to indicate the scope of the alignment between the
	 *  sequence of the entity or biological unit described in the data
	 *  block and that in the referenced database entry. 'entire'
	 *  indicates that alignment spans the entire length of both
	 *  sequences (although point differences may occur and can be
	 *  annotated using the data items in the STRUCT_REF_SEQ_DIF
	 *  category). 'partial' indicates a partial alignment. The region
	 *  (or regions) of the alignment may be delimited using data items
	 *  in the STRUCT_REF_SEQ category. This data item may also take
	 *  the value '.', indicating that the reference is not to a
	 *  sequence.
	 */
	public java.lang.String getSeq_align() 
	{
		return seq_align;
	}
 
	public void setSeq_align(java.lang.String seq_align)
	{
		this.seq_align = seq_align;
	}

 	protected java.lang.String seq_dif;


	/**
	 *  A flag to indicate the presence ('yes') or absence ('no') of
	 *  point differences between the sequence of the entity or
	 *  biological unit described in the data block and that in
	 *  the referenced database entry. This data item may also
	 *  take the value '.', indicating that the reference is not to a
	 *  sequence.
	 */
	public java.lang.String getSeq_dif() 
	{
		return seq_dif;
	}
 
	public void setSeq_dif(java.lang.String seq_dif)
	{
		this.seq_dif = seq_dif;
	}

 }
