package org.pdb.beans;

/**
 *  Data items in the STRUCT_SHEET_HBOND category record details
 *  about the hydrogen bonding between residue ranges in a beta-
 *  sheet. It is necessary to treat hydrogen bonding independently
 *  of the designation of ranges, because the hydrogen bonding may
 *  begin in different places for the interactions of a given strand
 *  with the one preceding it and the one following it in the sheet.
 *  
 * <pre>
 *  Example 1 - simple beta-barrel.
 *  <PDBx:struct_sheet_hbondCategory>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_a" range_id_2="strand_b">
 *  <PDBx:range_1_beg_label_seq_id>11</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>30</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>19</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>40</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_b" range_id_2="strand_c">
 *  <PDBx:range_1_beg_label_seq_id>31</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>50</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>39</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>60</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_c" range_id_2="strand_d">
 *  <PDBx:range_1_beg_label_seq_id>51</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>70</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>59</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>80</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_d" range_id_2="strand_e">
 *  <PDBx:range_1_beg_label_seq_id>71</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>90</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>89</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>100</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_e" range_id_2="strand_f">
 *  <PDBx:range_1_beg_label_seq_id>91</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>110</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>99</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>120</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_f" range_id_2="strand_g">
 *  <PDBx:range_1_beg_label_seq_id>111</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>130</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>119</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>140</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_g" range_id_2="strand_h">
 *  <PDBx:range_1_beg_label_seq_id>131</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>150</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>139</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>160</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_1" range_id_1="strand_h" range_id_2="strand_a">
 *  <PDBx:range_1_beg_label_seq_id>151</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>10</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>159</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>180</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  </PDBx:struct_sheet_hbondCategory>
 *  
 *  
 *  Example 2 - five stranded mixed-sense sheet with one two-piece strand.
 *  <PDBx:struct_sheet_hbondCategory>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_a" range_id_2="strand_b">
 *  <PDBx:range_1_beg_label_seq_id>20</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>119</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>18</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>111</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_b" range_id_2="strand_c">
 *  <PDBx:range_1_beg_label_seq_id>110</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>33</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>118</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>N</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>41</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>O</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_c" range_id_2="strand_d1">
 *  <PDBx:range_1_beg_label_seq_id>38</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>52</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>40</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>50</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_c" range_id_2="strand_d2">
 *  <PDBx:range_1_beg_label_seq_id>30</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>96</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>36</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>90</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_d1" range_id_2="strand_e">
 *  <PDBx:range_1_beg_label_seq_id>51</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>80</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>51</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>80</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  <PDBx:struct_sheet_hbond sheet_id="sheet_2" range_id_1="strand_d2" range_id_2="strand_e">
 *  <PDBx:range_1_beg_label_seq_id>91</PDBx:range_1_beg_label_seq_id>
 *  <PDBx:range_1_beg_label_atom_id>N</PDBx:range_1_beg_label_atom_id>
 *  <PDBx:range_2_beg_label_seq_id>76</PDBx:range_2_beg_label_seq_id>
 *  <PDBx:range_2_beg_label_atom_id>O</PDBx:range_2_beg_label_atom_id>
 *  <PDBx:range_1_end_label_seq_id>97</PDBx:range_1_end_label_seq_id>
 *  <PDBx:range_1_end_label_atom_id>O</PDBx:range_1_end_label_atom_id>
 *  <PDBx:range_2_end_label_seq_id>70</PDBx:range_2_end_label_seq_id>
 *  <PDBx:range_2_end_label_atom_id>N</PDBx:range_2_end_label_atom_id>
 *  </PDBx:struct_sheet_hbond>
 *  </PDBx:struct_sheet_hbondCategory>
 * </pre>
 */
public class Struct_sheet_hbond 
{
		protected java.lang.String pdbx_range_1_beg_PDB_ins_code;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_range_1_beg_PDB_ins_code() 
	{
		return pdbx_range_1_beg_PDB_ins_code;
	}
 
	public void setPdbx_range_1_beg_PDB_ins_code(java.lang.String pdbx_range_1_beg_PDB_ins_code)
	{
		this.pdbx_range_1_beg_PDB_ins_code = pdbx_range_1_beg_PDB_ins_code;
	}

 	protected java.lang.String pdbx_range_1_beg_auth_asym_id;


	/**
	 *  Pointer to  attribute auth_asym_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_1_beg_auth_asym_id() 
	{
		return pdbx_range_1_beg_auth_asym_id;
	}
 
	public void setPdbx_range_1_beg_auth_asym_id(java.lang.String pdbx_range_1_beg_auth_asym_id)
	{
		this.pdbx_range_1_beg_auth_asym_id = pdbx_range_1_beg_auth_asym_id;
	}

 	protected java.lang.String pdbx_range_1_beg_auth_comp_id;


	/**
	 *  Pointer to  attribute auth_comp_id in category atom_site
	 */
	public java.lang.String getPdbx_range_1_beg_auth_comp_id() 
	{
		return pdbx_range_1_beg_auth_comp_id;
	}
 
	public void setPdbx_range_1_beg_auth_comp_id(java.lang.String pdbx_range_1_beg_auth_comp_id)
	{
		this.pdbx_range_1_beg_auth_comp_id = pdbx_range_1_beg_auth_comp_id;
	}

 	protected java.lang.String pdbx_range_1_beg_label_asym_id;


	/**
	 *  Pointer to  attribute label_asym_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_1_beg_label_asym_id() 
	{
		return pdbx_range_1_beg_label_asym_id;
	}
 
	public void setPdbx_range_1_beg_label_asym_id(java.lang.String pdbx_range_1_beg_label_asym_id)
	{
		this.pdbx_range_1_beg_label_asym_id = pdbx_range_1_beg_label_asym_id;
	}

 	protected java.lang.String pdbx_range_1_beg_label_comp_id;


	/**
	 *  Pointer to  attribute label_comp_id in category atom_site
	 */
	public java.lang.String getPdbx_range_1_beg_label_comp_id() 
	{
		return pdbx_range_1_beg_label_comp_id;
	}
 
	public void setPdbx_range_1_beg_label_comp_id(java.lang.String pdbx_range_1_beg_label_comp_id)
	{
		this.pdbx_range_1_beg_label_comp_id = pdbx_range_1_beg_label_comp_id;
	}

 	protected java.lang.String pdbx_range_1_end_PDB_ins_code;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_range_1_end_PDB_ins_code() 
	{
		return pdbx_range_1_end_PDB_ins_code;
	}
 
	public void setPdbx_range_1_end_PDB_ins_code(java.lang.String pdbx_range_1_end_PDB_ins_code)
	{
		this.pdbx_range_1_end_PDB_ins_code = pdbx_range_1_end_PDB_ins_code;
	}

 	protected java.lang.String pdbx_range_1_end_auth_asym_id;


	/**
	 *  Pointer to  attribute auth_comp_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_1_end_auth_asym_id() 
	{
		return pdbx_range_1_end_auth_asym_id;
	}
 
	public void setPdbx_range_1_end_auth_asym_id(java.lang.String pdbx_range_1_end_auth_asym_id)
	{
		this.pdbx_range_1_end_auth_asym_id = pdbx_range_1_end_auth_asym_id;
	}

 	protected java.lang.String pdbx_range_1_end_auth_comp_id;


	/**
	 *  Pointer to  attribute auth_comp_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_1_end_auth_comp_id() 
	{
		return pdbx_range_1_end_auth_comp_id;
	}
 
	public void setPdbx_range_1_end_auth_comp_id(java.lang.String pdbx_range_1_end_auth_comp_id)
	{
		this.pdbx_range_1_end_auth_comp_id = pdbx_range_1_end_auth_comp_id;
	}

 	protected java.lang.String pdbx_range_1_end_label_asym_id;


	/**
	 *  Pointer to  attribute label_asym_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_1_end_label_asym_id() 
	{
		return pdbx_range_1_end_label_asym_id;
	}
 
	public void setPdbx_range_1_end_label_asym_id(java.lang.String pdbx_range_1_end_label_asym_id)
	{
		this.pdbx_range_1_end_label_asym_id = pdbx_range_1_end_label_asym_id;
	}

 	protected java.lang.String pdbx_range_1_end_label_comp_id;


	/**
	 *  Pointer to  attribute label_comp_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_1_end_label_comp_id() 
	{
		return pdbx_range_1_end_label_comp_id;
	}
 
	public void setPdbx_range_1_end_label_comp_id(java.lang.String pdbx_range_1_end_label_comp_id)
	{
		this.pdbx_range_1_end_label_comp_id = pdbx_range_1_end_label_comp_id;
	}

 	protected java.lang.String pdbx_range_2_beg_PDB_ins_code;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_range_2_beg_PDB_ins_code() 
	{
		return pdbx_range_2_beg_PDB_ins_code;
	}
 
	public void setPdbx_range_2_beg_PDB_ins_code(java.lang.String pdbx_range_2_beg_PDB_ins_code)
	{
		this.pdbx_range_2_beg_PDB_ins_code = pdbx_range_2_beg_PDB_ins_code;
	}

 	protected java.lang.String pdbx_range_2_beg_label_asym_id;


	/**
	 *  Pointer to  attribute label_asym_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_2_beg_label_asym_id() 
	{
		return pdbx_range_2_beg_label_asym_id;
	}
 
	public void setPdbx_range_2_beg_label_asym_id(java.lang.String pdbx_range_2_beg_label_asym_id)
	{
		this.pdbx_range_2_beg_label_asym_id = pdbx_range_2_beg_label_asym_id;
	}

 	protected java.lang.String pdbx_range_2_beg_label_comp_id;


	/**
	 *  Pointer to  attribute label_comp_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_2_beg_label_comp_id() 
	{
		return pdbx_range_2_beg_label_comp_id;
	}
 
	public void setPdbx_range_2_beg_label_comp_id(java.lang.String pdbx_range_2_beg_label_comp_id)
	{
		this.pdbx_range_2_beg_label_comp_id = pdbx_range_2_beg_label_comp_id;
	}

 	protected java.lang.String pdbx_range_2_end_label_asym_id;


	/**
	 *  Pointer to  attribute label_asym_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_2_end_label_asym_id() 
	{
		return pdbx_range_2_end_label_asym_id;
	}
 
	public void setPdbx_range_2_end_label_asym_id(java.lang.String pdbx_range_2_end_label_asym_id)
	{
		this.pdbx_range_2_end_label_asym_id = pdbx_range_2_end_label_asym_id;
	}

 	protected java.lang.String pdbx_range_2_end_label_comp_id;


	/**
	 *  Pointer to  attribute label_comp_id in category atom_site.
	 */
	public java.lang.String getPdbx_range_2_end_label_comp_id() 
	{
		return pdbx_range_2_end_label_comp_id;
	}
 
	public void setPdbx_range_2_end_label_comp_id(java.lang.String pdbx_range_2_end_label_comp_id)
	{
		this.pdbx_range_2_end_label_comp_id = pdbx_range_2_end_label_comp_id;
	}

 	protected java.lang.String pdbx_range_2_end_label_ins_code;


	/**
	 *  Place holder for PDB insertion code.
	 */
	public java.lang.String getPdbx_range_2_end_label_ins_code() 
	{
		return pdbx_range_2_end_label_ins_code;
	}
 
	public void setPdbx_range_2_end_label_ins_code(java.lang.String pdbx_range_2_end_label_ins_code)
	{
		this.pdbx_range_2_end_label_ins_code = pdbx_range_2_end_label_ins_code;
	}

 	protected java.lang.String range_1_beg_auth_atom_id;


	/**
	 *  A component of the identifier for the residue for the first
	 *  partner of the first hydrogen bond between two residue ranges
	 *  in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_beg_auth_atom_id() 
	{
		return range_1_beg_auth_atom_id;
	}
 
	public void setRange_1_beg_auth_atom_id(java.lang.String range_1_beg_auth_atom_id)
	{
		this.range_1_beg_auth_atom_id = range_1_beg_auth_atom_id;
	}

 	protected java.lang.String range_1_beg_auth_seq_id;


	/**
	 *  A component of the identifier for the residue for the first
	 *  partner of the first hydrogen bond between two residue ranges
	 *  in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_beg_auth_seq_id() 
	{
		return range_1_beg_auth_seq_id;
	}
 
	public void setRange_1_beg_auth_seq_id(java.lang.String range_1_beg_auth_seq_id)
	{
		this.range_1_beg_auth_seq_id = range_1_beg_auth_seq_id;
	}

 	protected java.lang.String range_1_beg_label_atom_id;


	/**
	 *  A component of the identifier for the residue for the first
	 *  partner of the first hydrogen bond between two residue ranges
	 *  in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_beg_label_atom_id() 
	{
		return range_1_beg_label_atom_id;
	}
 
	public void setRange_1_beg_label_atom_id(java.lang.String range_1_beg_label_atom_id)
	{
		this.range_1_beg_label_atom_id = range_1_beg_label_atom_id;
	}

 	protected java.lang.Integer range_1_beg_label_seq_id;


	/**
	 *  A component of the identifier for the residue for the first
	 *  partner of the first hydrogen bond between two residue ranges
	 *  in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getRange_1_beg_label_seq_id() 
	{
		return range_1_beg_label_seq_id;
	}
 
	public void setRange_1_beg_label_seq_id(java.lang.Integer range_1_beg_label_seq_id)
	{
		this.range_1_beg_label_seq_id = range_1_beg_label_seq_id;
	}

 	protected java.lang.String range_1_end_auth_atom_id;


	/**
	 *  A component of the identifier for the residue for the first
	 *  partner of the last hydrogen bond between two residue ranges in
	 *  a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_end_auth_atom_id() 
	{
		return range_1_end_auth_atom_id;
	}
 
	public void setRange_1_end_auth_atom_id(java.lang.String range_1_end_auth_atom_id)
	{
		this.range_1_end_auth_atom_id = range_1_end_auth_atom_id;
	}

 	protected java.lang.String range_1_end_auth_seq_id;


	/**
	 *  A component of the identifier for the residue for the first
	 *  partner of the last hydrogen bond between two residue ranges in
	 *  a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_end_auth_seq_id() 
	{
		return range_1_end_auth_seq_id;
	}
 
	public void setRange_1_end_auth_seq_id(java.lang.String range_1_end_auth_seq_id)
	{
		this.range_1_end_auth_seq_id = range_1_end_auth_seq_id;
	}

 	protected java.lang.String range_1_end_label_atom_id;


	/**
	 *  A component of the identifier for the residue for the first
	 *  partner of the last hydrogen bond between two residue ranges in
	 *  a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_1_end_label_atom_id() 
	{
		return range_1_end_label_atom_id;
	}
 
	public void setRange_1_end_label_atom_id(java.lang.String range_1_end_label_atom_id)
	{
		this.range_1_end_label_atom_id = range_1_end_label_atom_id;
	}

 	protected java.lang.Integer range_1_end_label_seq_id;


	/**
	 *  A component of the identifier for the residue for the first
	 *  partner of the last hydrogen bond between two residue ranges in
	 *  a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getRange_1_end_label_seq_id() 
	{
		return range_1_end_label_seq_id;
	}
 
	public void setRange_1_end_label_seq_id(java.lang.Integer range_1_end_label_seq_id)
	{
		this.range_1_end_label_seq_id = range_1_end_label_seq_id;
	}

 	protected java.lang.String range_2_beg_auth_atom_id;


	/**
	 *  A component of the identifier for the residue for the second
	 *  partner of the first hydrogen bond between two residue ranges
	 *  in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_beg_auth_atom_id() 
	{
		return range_2_beg_auth_atom_id;
	}
 
	public void setRange_2_beg_auth_atom_id(java.lang.String range_2_beg_auth_atom_id)
	{
		this.range_2_beg_auth_atom_id = range_2_beg_auth_atom_id;
	}

 	protected java.lang.String range_2_beg_auth_seq_id;


	/**
	 *  A component of the identifier for the residue for the second
	 *  partner of the first hydrogen bond between two residue ranges
	 *  in a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_beg_auth_seq_id() 
	{
		return range_2_beg_auth_seq_id;
	}
 
	public void setRange_2_beg_auth_seq_id(java.lang.String range_2_beg_auth_seq_id)
	{
		this.range_2_beg_auth_seq_id = range_2_beg_auth_seq_id;
	}

 	protected java.lang.String range_2_beg_label_atom_id;


	/**
	 *  A component of the identifier for the residue for the second
	 *  partner of the first hydrogen bond between two residue ranges
	 *  in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_beg_label_atom_id() 
	{
		return range_2_beg_label_atom_id;
	}
 
	public void setRange_2_beg_label_atom_id(java.lang.String range_2_beg_label_atom_id)
	{
		this.range_2_beg_label_atom_id = range_2_beg_label_atom_id;
	}

 	protected java.lang.Integer range_2_beg_label_seq_id;


	/**
	 *  A component of the identifier for the residue for the second
	 *  partner of the first hydrogen bond between two residue ranges
	 *  in a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getRange_2_beg_label_seq_id() 
	{
		return range_2_beg_label_seq_id;
	}
 
	public void setRange_2_beg_label_seq_id(java.lang.Integer range_2_beg_label_seq_id)
	{
		this.range_2_beg_label_seq_id = range_2_beg_label_seq_id;
	}

 	protected java.lang.String range_2_end_auth_atom_id;


	/**
	 *  A component of the identifier for the residue for the second
	 *  partner of the last hydrogen bond between two residue ranges in
	 *  a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_end_auth_atom_id() 
	{
		return range_2_end_auth_atom_id;
	}
 
	public void setRange_2_end_auth_atom_id(java.lang.String range_2_end_auth_atom_id)
	{
		this.range_2_end_auth_atom_id = range_2_end_auth_atom_id;
	}

 	protected java.lang.String range_2_end_auth_seq_id;


	/**
	 *  A component of the identifier for the residue for the second
	 *  partner of the last hydrogen bond between two residue ranges in
	 *  a sheet.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_end_auth_seq_id() 
	{
		return range_2_end_auth_seq_id;
	}
 
	public void setRange_2_end_auth_seq_id(java.lang.String range_2_end_auth_seq_id)
	{
		this.range_2_end_auth_seq_id = range_2_end_auth_seq_id;
	}

 	protected java.lang.String range_2_end_label_atom_id;


	/**
	 *  A component of the identifier for the residue for the second
	 *  partner of the last hydrogen bond between two residue ranges in
	 *  a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getRange_2_end_label_atom_id() 
	{
		return range_2_end_label_atom_id;
	}
 
	public void setRange_2_end_label_atom_id(java.lang.String range_2_end_label_atom_id)
	{
		this.range_2_end_label_atom_id = range_2_end_label_atom_id;
	}

 	protected java.lang.Integer range_2_end_label_seq_id;


	/**
	 *  A component of the identifier for the residue for the second
	 *  partner of the last hydrogen bond between two residue ranges in
	 *  a sheet.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getRange_2_end_label_seq_id() 
	{
		return range_2_end_label_seq_id;
	}
 
	public void setRange_2_end_label_seq_id(java.lang.Integer range_2_end_label_seq_id)
	{
		this.range_2_end_label_seq_id = range_2_end_label_seq_id;
	}

 	protected java.lang.String range_id_1;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet_range in
	 *  the STRUCT_SHEET_RANGE category.
	 */
	public java.lang.String getRange_id_1() 
	{
		return range_id_1;
	}
 
	public void setRange_id_1(java.lang.String range_id_1)
	{
		this.range_id_1 = range_id_1;
	}

 	protected java.lang.String range_id_2;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet_range in
	 *  the STRUCT_SHEET_RANGE category.
	 */
	public java.lang.String getRange_id_2() 
	{
		return range_id_2;
	}
 
	public void setRange_id_2(java.lang.String range_id_2)
	{
		this.range_id_2 = range_id_2;
	}

 	protected java.lang.String sheet_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet in the
	 *  STRUCT_SHEET category.
	 */
	public java.lang.String getSheet_id() 
	{
		return sheet_id;
	}
 
	public void setSheet_id(java.lang.String sheet_id)
	{
		this.sheet_id = sheet_id;
	}

 }
