package org.pdb.beans;

/**
 *  Data items in the STRUCT_SHEET_RANGE category record details
 *  about the residue ranges that form a beta-sheet. Residues are
 *  included in a range if they made beta-sheet-type hydrogen-bonding
 *  interactions with at least one adjacent strand and if there are
 *  at least two residues in the range.
 *  
 * <pre>
 *  Example 1 - simple beta-barrel.
 *  <PDBx:struct_sheet_rangeCategory>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_a">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>20</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>30</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_b">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>40</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>50</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_c">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>60</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>70</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_d">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>80</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>90</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_e">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>100</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>110</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_f">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>120</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>130</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_g">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>140</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>150</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_1" id="strand_h">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>160</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>170</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  </PDBx:struct_sheet_rangeCategory>
 *  
 *  
 *  Example 2 - five stranded mixed-sense sheet with one two-piece strand.
 *  <PDBx:struct_sheet_rangeCategory>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_a">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>10</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>18</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_b">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>110</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>119</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_c">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>30</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>41</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_d1">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>50</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>52</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_d2">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>90</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>97</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  <PDBx:struct_sheet_range sheet_id="sheet_2" id="strand_e">
 *  <PDBx:beg_label_comp_id>ala</PDBx:beg_label_comp_id>
 *  <PDBx:beg_label_asym_id>A</PDBx:beg_label_asym_id>
 *  <PDBx:beg_label_seq_id>70</PDBx:beg_label_seq_id>
 *  <PDBx:end_label_comp_id>ala</PDBx:end_label_comp_id>
 *  <PDBx:end_label_asym_id>A</PDBx:end_label_asym_id>
 *  <PDBx:end_label_seq_id>80</PDBx:end_label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_sheet_range>
 *  </PDBx:struct_sheet_rangeCategory>
 * </pre>
 */
public class Struct_sheet_range 
{
		protected java.lang.String beg_auth_asym_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range begins.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_asym_id() 
	{
		return beg_auth_asym_id;
	}
 
	public void setBeg_auth_asym_id(java.lang.String beg_auth_asym_id)
	{
		this.beg_auth_asym_id = beg_auth_asym_id;
	}

 	protected java.lang.String beg_auth_comp_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range begins.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in
	 *  the ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_comp_id() 
	{
		return beg_auth_comp_id;
	}
 
	public void setBeg_auth_comp_id(java.lang.String beg_auth_comp_id)
	{
		this.beg_auth_comp_id = beg_auth_comp_id;
	}

 	protected java.lang.String beg_auth_seq_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range begins.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_seq_id() 
	{
		return beg_auth_seq_id;
	}
 
	public void setBeg_auth_seq_id(java.lang.String beg_auth_seq_id)
	{
		this.beg_auth_seq_id = beg_auth_seq_id;
	}

 	protected java.lang.String beg_label_asym_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range begins.
	 *  
	 *  This data item is a pointer to  attribute id in category struct_asym in the
	 *  STRUCT_ASYM category.
	 */
	public java.lang.String getBeg_label_asym_id() 
	{
		return beg_label_asym_id;
	}
 
	public void setBeg_label_asym_id(java.lang.String beg_label_asym_id)
	{
		this.beg_label_asym_id = beg_label_asym_id;
	}

 	protected java.lang.String beg_label_comp_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range begins.
	 *  
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getBeg_label_comp_id() 
	{
		return beg_label_comp_id;
	}
 
	public void setBeg_label_comp_id(java.lang.String beg_label_comp_id)
	{
		this.beg_label_comp_id = beg_label_comp_id;
	}

 	protected java.lang.Integer beg_label_seq_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range begins.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getBeg_label_seq_id() 
	{
		return beg_label_seq_id;
	}
 
	public void setBeg_label_seq_id(java.lang.Integer beg_label_seq_id)
	{
		this.beg_label_seq_id = beg_label_seq_id;
	}

 	protected java.lang.String end_auth_asym_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range ends.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_asym_id() 
	{
		return end_auth_asym_id;
	}
 
	public void setEnd_auth_asym_id(java.lang.String end_auth_asym_id)
	{
		this.end_auth_asym_id = end_auth_asym_id;
	}

 	protected java.lang.String end_auth_comp_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range ends.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_comp_id() 
	{
		return end_auth_comp_id;
	}
 
	public void setEnd_auth_comp_id(java.lang.String end_auth_comp_id)
	{
		this.end_auth_comp_id = end_auth_comp_id;
	}

 	protected java.lang.String end_auth_seq_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range ends.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_seq_id() 
	{
		return end_auth_seq_id;
	}
 
	public void setEnd_auth_seq_id(java.lang.String end_auth_seq_id)
	{
		this.end_auth_seq_id = end_auth_seq_id;
	}

 	protected java.lang.String end_label_asym_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range ends.
	 *  
	 *  This data item is a pointer to  attribute id in category struct_asym in the
	 *  STRUCT_ASYM category.
	 */
	public java.lang.String getEnd_label_asym_id() 
	{
		return end_label_asym_id;
	}
 
	public void setEnd_label_asym_id(java.lang.String end_label_asym_id)
	{
		this.end_label_asym_id = end_label_asym_id;
	}

 	protected java.lang.String end_label_comp_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range ends.
	 *  
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getEnd_label_comp_id() 
	{
		return end_label_comp_id;
	}
 
	public void setEnd_label_comp_id(java.lang.String end_label_comp_id)
	{
		this.end_label_comp_id = end_label_comp_id;
	}

 	protected java.lang.Integer end_label_seq_id;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta-sheet range ends.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getEnd_label_seq_id() 
	{
		return end_label_seq_id;
	}
 
	public void setEnd_label_seq_id(java.lang.Integer end_label_seq_id)
	{
		this.end_label_seq_id = end_label_seq_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_sheet_range must uniquely identify a
	 *  range in a given sheet in the STRUCT_SHEET_RANGE list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_beg_PDB_ins_code;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta sheet range begins.  Insertion code.
	 */
	public java.lang.String getPdbx_beg_PDB_ins_code() 
	{
		return pdbx_beg_PDB_ins_code;
	}
 
	public void setPdbx_beg_PDB_ins_code(java.lang.String pdbx_beg_PDB_ins_code)
	{
		this.pdbx_beg_PDB_ins_code = pdbx_beg_PDB_ins_code;
	}

 	protected java.lang.String pdbx_end_PDB_ins_code;


	/**
	 *  A component of the identifier for the residue at which the
	 *  beta sheet range ends. Insertion code.
	 */
	public java.lang.String getPdbx_end_PDB_ins_code() 
	{
		return pdbx_end_PDB_ins_code;
	}
 
	public void setPdbx_end_PDB_ins_code(java.lang.String pdbx_end_PDB_ins_code)
	{
		this.pdbx_end_PDB_ins_code = pdbx_end_PDB_ins_code;
	}

 	protected java.lang.String sheet_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet in the
	 *  STRUCT_SHEET category.
	 */
	public java.lang.String getSheet_id() 
	{
		return sheet_id;
	}
 
	public void setSheet_id(java.lang.String sheet_id)
	{
		this.sheet_id = sheet_id;
	}

 	protected java.lang.String symmetry;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  residues delimited by the start and end designators in
	 *  order to generate the appropriate strand in this sheet.
	 */
	public java.lang.String getSymmetry() 
	{
		return symmetry;
	}
 
	public void setSymmetry(java.lang.String symmetry)
	{
		this.symmetry = symmetry;
	}

 }
