package org.pdb.beans;

/**
 *  Data items in the STRUCT_SITE_VIEW category record details
 *  about how to draw and annotate an informative view of the
 *  site.
 *  
 * <pre>
 *  Example 1 - based on NDB structure GDL001 by Coll, Aymami,
 *  Van Der Marel, Van Boom, Rich & Wang
 *  [Biochemistry (1989), 28, 310-320].
 *  <PDBx:struct_site_viewCategory>
 *  <PDBx:struct_site_view id="1">
 *  <PDBx:rot_matrix11>0.132</PDBx:rot_matrix11>
 *  <PDBx:rot_matrix12>0.922</PDBx:rot_matrix12>
 *  <PDBx:rot_matrix13>-0.363</PDBx:rot_matrix13>
 *  <PDBx:rot_matrix21>0.131</PDBx:rot_matrix21>
 *  <PDBx:rot_matrix22>-0.380</PDBx:rot_matrix22>
 *  <PDBx:rot_matrix23>-0.916</PDBx:rot_matrix23>
 *  <PDBx:rot_matrix31>-0.982</PDBx:rot_matrix31>
 *  <PDBx:rot_matrix32>0.073</PDBx:rot_matrix32>
 *  <PDBx:rot_matrix33>-0.172</PDBx:rot_matrix33>
 *  <PDBx:details> This view highlights the site of ATAT-Netropsin
 *  interaction.</PDBx:details>
 *  </PDBx:struct_site_view>
 *  </PDBx:struct_site_viewCategory>
 * </pre>
 */
public class Struct_site_view 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of this view of the
	 *  site. This data item can be used as a figure legend.
	 *  The active site has been oriented with the
	 *  specificity pocket on the right and the active
	 *  site machinery on the left.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_site_view must uniquely identify a
	 *  record in the STRUCT_SITE_VIEW list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  Figure 1
	 *  unliganded enzyme
	 *  view down enzyme active site
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float rot_matrix11;


	/**
	 *  The [1][1] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category to an orientation useful for
	 *  visualizing the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix11() 
	{
		return rot_matrix11;
	}
 
	public void setRot_matrix11(java.lang.Float rot_matrix11)
	{
		this.rot_matrix11 = rot_matrix11;
	}

 	protected java.lang.Float rot_matrix12;


	/**
	 *  The [1][2] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category to an orientation useful for
	 *  visualizing the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix12() 
	{
		return rot_matrix12;
	}
 
	public void setRot_matrix12(java.lang.Float rot_matrix12)
	{
		this.rot_matrix12 = rot_matrix12;
	}

 	protected java.lang.Float rot_matrix13;


	/**
	 *  The [1][3] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category to an orientation useful for
	 *  visualizing the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix13() 
	{
		return rot_matrix13;
	}
 
	public void setRot_matrix13(java.lang.Float rot_matrix13)
	{
		this.rot_matrix13 = rot_matrix13;
	}

 	protected java.lang.Float rot_matrix21;


	/**
	 *  The [2][1] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category to an orientation useful for
	 *  visualizing the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix21() 
	{
		return rot_matrix21;
	}
 
	public void setRot_matrix21(java.lang.Float rot_matrix21)
	{
		this.rot_matrix21 = rot_matrix21;
	}

 	protected java.lang.Float rot_matrix22;


	/**
	 *  The [2][2] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category to an orientation useful for
	 *  visualizing the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix22() 
	{
		return rot_matrix22;
	}
 
	public void setRot_matrix22(java.lang.Float rot_matrix22)
	{
		this.rot_matrix22 = rot_matrix22;
	}

 	protected java.lang.Float rot_matrix23;


	/**
	 *  The [2][3] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category to an orientation useful for
	 *  visualizing the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix23() 
	{
		return rot_matrix23;
	}
 
	public void setRot_matrix23(java.lang.Float rot_matrix23)
	{
		this.rot_matrix23 = rot_matrix23;
	}

 	protected java.lang.Float rot_matrix31;


	/**
	 *  The [3][1] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category to an orientation useful for
	 *  visualizing the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix31() 
	{
		return rot_matrix31;
	}
 
	public void setRot_matrix31(java.lang.Float rot_matrix31)
	{
		this.rot_matrix31 = rot_matrix31;
	}

 	protected java.lang.Float rot_matrix32;


	/**
	 *  The [3][2] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category to an orientation useful for
	 *  visualizing the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix32() 
	{
		return rot_matrix32;
	}
 
	public void setRot_matrix32(java.lang.Float rot_matrix32)
	{
		this.rot_matrix32 = rot_matrix32;
	}

 	protected java.lang.Float rot_matrix33;


	/**
	 *  The [3][3] element of the matrix used to rotate the subset of the
	 *  Cartesian coordinates in the ATOM_SITE category identified in the
	 *  STRUCT_SITE_GEN category an orientation useful for visualizing
	 *  the site. The conventions used in the rotation are
	 *  described in  attribute details.
	 *  in category struct_site_view
	 *  |x'|                         |11 12 13| |x|
	 *  |y'|~reoriented Cartesian~ = |21 22 23| |y|~Cartesian~
	 *  |z'|                         |31 32 33| |z|
	 */
	public java.lang.Float getRot_matrix33() 
	{
		return rot_matrix33;
	}
 
	public void setRot_matrix33(java.lang.Float rot_matrix33)
	{
		this.rot_matrix33 = rot_matrix33;
	}

 	protected java.lang.String site_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_site in the STRUCT_SITE
	 *  category.
	 */
	public java.lang.String getSite_id() 
	{
		return site_id;
	}
 
	public void setSite_id(java.lang.String site_id)
	{
		this.site_id = site_id;
	}

 }
