package org.pdb.beans;

/**
 *  Data items in the SYMMETRY category record details about the
 *  space-group symmetry.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:symmetryCategory>
 *  <PDBx:symmetry entry_id="5HVP">
 *  <PDBx:cell_setting>orthorhombic</PDBx:cell_setting>
 *  <PDBx:Int_Tables_number>18</PDBx:Int_Tables_number>
 *  <PDBx:space_group_name_H-M>P 21 21 2</PDBx:space_group_name_H-M>
 *  </PDBx:symmetry>
 *  </PDBx:symmetryCategory>
 * </pre>
 */
public class Symmetry 
{
		protected java.lang.Integer Int_Tables_number;


	/**
	 *  Space-group number from International Tables for Crystallography
	 *  Vol. A (2002).
	 */
	public java.lang.Integer getInt_Tables_number() 
	{
		return Int_Tables_number;
	}
 
	public void setInt_Tables_number(java.lang.Integer Int_Tables_number)
	{
		this.Int_Tables_number = Int_Tables_number;
	}

 	protected java.lang.String cell_setting;


	/**
	 *  The cell settings for this space-group symmetry.
	 */
	public java.lang.String getCell_setting() 
	{
		return cell_setting;
	}
 
	public void setCell_setting(java.lang.String cell_setting)
	{
		this.cell_setting = cell_setting;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String pdbx_full_space_group_name_H_M;


	/**
	 *  Used for PDB space group:
	 *  
	 * <pre>
	 *  Example: 'C 1 2 1'  (instead of C 2)
	 *  'P 1 2 1'  (instead of P 2)
	 *  'P 1 21 1' (instead of P 21)
	 *  'P 1 1 21' (instead of P 21 -unique C axis)
	 *  'H 3'      (instead of R 3   -hexagonal)
	 *  'H 3 2'    (instead of R 3 2 -hexagonal)
	 *  
	 *  
	 *  
	 *  Example: 'C 1 2 1'  (instead of C 2)
	 *  'P 1 2 1'  (instead of P 2)
	 *  'P 1 21 1' (instead of P 21)
	 *  'P 1 1 21' (instead of P 21 -unique C axis)
	 *  'H 3'      (instead of R 3   -hexagonal)
	 *  'H 3 2'    (instead of R 3 2 -hexagonal)
	 * </pre>
	 */
	public java.lang.String getPdbx_full_space_group_name_H_M() 
	{
		return pdbx_full_space_group_name_H_M;
	}
 
	public void setPdbx_full_space_group_name_H_M(java.lang.String pdbx_full_space_group_name_H_M)
	{
		this.pdbx_full_space_group_name_H_M = pdbx_full_space_group_name_H_M;
	}

 	protected java.lang.String space_group_name_H_M;


	/**
	 *  Hermann-Mauguin space-group symbol. Note that the
	 *  Hermann-Mauguin symbol does not necessarily contain complete
	 *  information about the symmetry and the space-group origin. If
	 *  used, always supply the FULL symbol from International Tables
	 *  for Crystallography Vol. A (2002) and indicate the origin and
	 *  the setting if it is not implicit. If there is any doubt that
	 *  the equivalent positions can be uniquely deduced from this
	 *  symbol, specify the  attribute pos_as_xyz in category symmetry_equiv or
	 *  attribute space_group_name_Hall in category symmetry data items as well. Leave
	 *  spaces between symbols referring to
	 *  different axes.
	 *  P 1 21/m 1
	 *  P 2/n 2/n 2/n (origin at -1)
	 *  R -3 2/m
	 */
	public java.lang.String getSpace_group_name_H_M() 
	{
		return space_group_name_H_M;
	}
 
	public void setSpace_group_name_H_M(java.lang.String space_group_name_H_M)
	{
		this.space_group_name_H_M = space_group_name_H_M;
	}

 	protected java.lang.String space_group_name_Hall;


	/**
	 *  Space-group symbol as described by Hall (1981). This symbol
	 *  gives the space-group setting explicitly. Leave spaces between
	 *  the separate components of the symbol.
	 *  
	 *  Ref: Hall, S. R. (1981). Acta Cryst. A37, 517-525; erratum
	 *  (1981) A37, 921.
	 *  -P 2ac 2n
	 *  -R 3 2"
	 *  P 61 2 2 (0 0 -1)
	 */
	public java.lang.String getSpace_group_name_Hall() 
	{
		return space_group_name_Hall;
	}
 
	public void setSpace_group_name_Hall(java.lang.String space_group_name_Hall)
	{
		this.space_group_name_Hall = space_group_name_Hall;
	}

 }
