package org.pdb.beans;

/**
 *  Data items in the VALENCE_PARAM category define the
 *  parameters used for calculating bond valences from bond
 *  lengths.  In addition to the parameters, a pointer
 *  is given to the reference (in VALENCE_REF) from which
 *  the bond-valence parameters were taken.
 *  
 * <pre>
 *  Example 1 - a bond-valence parameter list with accompanying references.
 *  <PDBx:valence_paramCategory>
 *  <PDBx:valence_param atom_1="Cu" atom_1_valence="2" atom_2="O" atom_2_valence="-2">
 *  <PDBx:Ro>1.679</PDBx:Ro>
 *  <PDBx:B>0.37</PDBx:B>
 *  <PDBx:ref_id>a</PDBx:ref_id>
 *  </PDBx:valence_param>
 *  <PDBx:valence_param atom_1="Cu" atom_1_valence="2" atom_2="O" atom_2_valence="-2">
 *  <PDBx:Ro>1.649</PDBx:Ro>
 *  <PDBx:B>0.37</PDBx:B>
 *  <PDBx:ref_id>j</PDBx:ref_id>
 *  </PDBx:valence_param>
 *  <PDBx:valence_param atom_1="Cu" atom_1_valence="2" atom_2="N" atom_2_valence="-3">
 *  <PDBx:Ro>1.64</PDBx:Ro>
 *  <PDBx:B>0.37</PDBx:B>
 *  <PDBx:ref_id>m</PDBx:ref_id>
 *  <PDBx:details>2-coordinate N</PDBx:details>
 *  </PDBx:valence_param>
 *  <PDBx:valence_param atom_1="Cu" atom_1_valence="2" atom_2="N" atom_2_valence="-3">
 *  <PDBx:Ro>1.76</PDBx:Ro>
 *  <PDBx:B>0.37</PDBx:B>
 *  <PDBx:ref_id>m</PDBx:ref_id>
 *  <PDBx:details>3-coordinate N</PDBx:details>
 *  </PDBx:valence_param>
 *  </PDBx:valence_paramCategory>
 *  <PDBx:valence_refCategory>
 *  <PDBx:valence_ref id="a">
 *  <PDBx:reference>Brown &amp; Altermatt (1985), Acta Cryst. B41, 244-247</PDBx:reference>
 *  </PDBx:valence_ref>
 *  <PDBx:valence_ref id="j">
 *  <PDBx:reference>Liu &amp; Thorp (1993), Inorg. Chem. 32, 4102-4205</PDBx:reference>
 *  </PDBx:valence_ref>
 *  <PDBx:valence_ref id="m">
 *  <PDBx:reference>See, Krause &amp; Strub (1998), Inorg. Chem. 37, 5369-5375</PDBx:reference>
 *  </PDBx:valence_ref>
 *  </PDBx:valence_refCategory>
 * </pre>
 */
public class Valence_param 
{
		protected java.lang.Float B;


	/**
	 *  The bond-valence parameter B used in the expression
	 *  
	 *  s = exp[(Ro - R)/B]
	 *  
	 *  where s is the valence of a bond of length R.
	 */
	public java.lang.Float getB() 
	{
		return B;
	}
 
	public void setB(java.lang.Float B)
	{
		this.B = B;
	}

 	protected java.lang.Float Ro;


	/**
	 *  The bond-valence parameter Ro used in the expression
	 *  
	 *  s = exp[(Ro - R)/B]
	 *  
	 *  where s is the valence of a bond of length R.
	 */
	public java.lang.Float getRo() 
	{
		return Ro;
	}
 
	public void setRo(java.lang.Float Ro)
	{
		this.Ro = Ro;
	}

 	protected java.lang.String atom_1;


	/**
	 *  The element symbol of the first atom forming the bond whose
	 *  bond-valence parameters are given in this category.
	 */
	public java.lang.String getAtom_1() 
	{
		return atom_1;
	}
 
	public void setAtom_1(java.lang.String atom_1)
	{
		this.atom_1 = atom_1;
	}

 	protected java.lang.Integer atom_1_valence;


	/**
	 *  The valence (formal charge) of the first atom whose
	 *  bond-valence parameters are given in this category.
	 */
	public java.lang.Integer getAtom_1_valence() 
	{
		return atom_1_valence;
	}
 
	public void setAtom_1_valence(java.lang.Integer atom_1_valence)
	{
		this.atom_1_valence = atom_1_valence;
	}

 	protected java.lang.String atom_2;


	/**
	 *  The element symbol of the second atom forming the bond whose
	 *  bond-valence parameters are given in this category.
	 */
	public java.lang.String getAtom_2() 
	{
		return atom_2;
	}
 
	public void setAtom_2(java.lang.String atom_2)
	{
		this.atom_2 = atom_2;
	}

 	protected java.lang.Integer atom_2_valence;


	/**
	 *  The valence (formal charge) of the second atom whose
	 *  bond-valence parameters are given in this category.
	 */
	public java.lang.Integer getAtom_2_valence() 
	{
		return atom_2_valence;
	}
 
	public void setAtom_2_valence(java.lang.Integer atom_2_valence)
	{
		this.atom_2_valence = atom_2_valence;
	}

 	protected java.lang.String details;


	/**
	 *  Details of or comments on the bond-valence parameters.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  An identifier for the valence parameters of a bond between
	 *  the given atoms.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String ref_id;


	/**
	 *  An identifier which links to the reference to the source
	 *  from which the bond-valence parameters are taken. A child
	 *  of  attribute id in category valence_ref which it must match.
	 */
	public java.lang.String getRef_id() 
	{
		return ref_id;
	}
 
	public void setRef_id(java.lang.String ref_id)
	{
		this.ref_id = ref_id;
	}

 }
