package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ATOM_SITE_ANISOTROP category record details
 *  about anisotropic displacement parameters.
 *  If the ATOM_SITE_ANISOTROP category is used for storing these
 *  data, the corresponding ATOM_SITE data items are not used.
 *  
 * <pre>
 *  Example 1 - based on NDB structure BDL005 of Holbrook, Dickerson &
 *  Kim [Acta Cryst. (1985), B41, 255-262].
 *  <PDBx:atom_site_anisotropCategory>
 *  <PDBx:atom_site_anisotrop id="1">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:U11>8642.</PDBx:U11>
 *  <PDBx:U12>4866.</PDBx:U12>
 *  <PDBx:U13>7299.</PDBx:U13>
 *  <PDBx:U22>-342.</PDBx:U22>
 *  <PDBx:U23>-258.</PDBx:U23>
 *  <PDBx:U33>-1427.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="2">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>5174.</PDBx:U11>
 *  <PDBx:U12>4871.</PDBx:U12>
 *  <PDBx:U13>6243.</PDBx:U13>
 *  <PDBx:U22>-1885.</PDBx:U22>
 *  <PDBx:U23>-2051.</PDBx:U23>
 *  <PDBx:U33>-1377.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="3">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>6202.</PDBx:U11>
 *  <PDBx:U12>5020.</PDBx:U12>
 *  <PDBx:U13>4395.</PDBx:U13>
 *  <PDBx:U22>-1130.</PDBx:U22>
 *  <PDBx:U23>-556.</PDBx:U23>
 *  <PDBx:U33>-632.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="4">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:U11>4224.</PDBx:U11>
 *  <PDBx:U12>4700.</PDBx:U12>
 *  <PDBx:U13>5046.</PDBx:U13>
 *  <PDBx:U22>1105.</PDBx:U22>
 *  <PDBx:U23>-161.</PDBx:U23>
 *  <PDBx:U33>345.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="5">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>8684.</PDBx:U11>
 *  <PDBx:U12>4688.</PDBx:U12>
 *  <PDBx:U13>4171.</PDBx:U13>
 *  <PDBx:U22>-1850.</PDBx:U22>
 *  <PDBx:U23>-433.</PDBx:U23>
 *  <PDBx:U33>-292.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="6">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:U11>11226.</PDBx:U11>
 *  <PDBx:U12>5255.</PDBx:U12>
 *  <PDBx:U13>3532.</PDBx:U13>
 *  <PDBx:U22>-341.</PDBx:U22>
 *  <PDBx:U23>2685.</PDBx:U23>
 *  <PDBx:U33>1328.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="7">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>10214.</PDBx:U11>
 *  <PDBx:U12>2428.</PDBx:U12>
 *  <PDBx:U13>5614.</PDBx:U13>
 *  <PDBx:U22>-2610.</PDBx:U22>
 *  <PDBx:U23>-1940.</PDBx:U23>
 *  <PDBx:U33>902.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="8">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>4590.</PDBx:U11>
 *  <PDBx:U12>3488.</PDBx:U12>
 *  <PDBx:U13>5827.</PDBx:U13>
 *  <PDBx:U22>751.</PDBx:U22>
 *  <PDBx:U23>-770.</PDBx:U23>
 *  <PDBx:U33>986.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="9">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:U11>5014.</PDBx:U11>
 *  <PDBx:U12>4434.</PDBx:U12>
 *  <PDBx:U13>3447.</PDBx:U13>
 *  <PDBx:U22>-17.</PDBx:U22>
 *  <PDBx:U23>-1593.</PDBx:U23>
 *  <PDBx:U33>539.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  </PDBx:atom_site_anisotropCategory>
 * </pre>
 */
public class Atom_site_anisotrop extends org.pdb.beans.Atom_site_anisotrop implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "atom_site_anisotrop";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Atom_site_anisotrop()
	{
	}

	/** Full constructor */
	public Atom_site_anisotrop(
		Datablock datablock,
		java.lang.Float B11,
		java.lang.Float B11_esd,
		java.lang.Float B12,
		java.lang.Float B12_esd,
		java.lang.Float B13,
		java.lang.Float B13_esd,
		java.lang.Float B22,
		java.lang.Float B22_esd,
		java.lang.Float B23,
		java.lang.Float B23_esd,
		java.lang.Float B33,
		java.lang.Float B33_esd,
		java.lang.Float U11,
		java.lang.Float U11_esd,
		java.lang.Float U12,
		java.lang.Float U12_esd,
		java.lang.Float U13,
		java.lang.Float U13_esd,
		java.lang.Float U22,
		java.lang.Float U22_esd,
		java.lang.Float U23,
		java.lang.Float U23_esd,
		java.lang.Float U33,
		java.lang.Float U33_esd,
		java.lang.String id_,
		java.lang.String pdbx_PDB_ins_code,
		java.lang.String pdbx_auth_alt_id,
		java.lang.String pdbx_auth_asym_id,
		java.lang.String pdbx_auth_atom_id,
		java.lang.String pdbx_auth_comp_id,
		java.lang.String pdbx_auth_seq_id,
		java.lang.String pdbx_label_alt_id,
		java.lang.String pdbx_label_asym_id,
		java.lang.String pdbx_label_atom_id,
		java.lang.String pdbx_label_comp_id,
		java.lang.Integer pdbx_label_seq_id,
		java.lang.Float ratio,
		java.lang.String type_symbol)
	{
		this.datablock = datablock;
		this.B11 = B11;
		this.B11_esd = B11_esd;
		this.B12 = B12;
		this.B12_esd = B12_esd;
		this.B13 = B13;
		this.B13_esd = B13_esd;
		this.B22 = B22;
		this.B22_esd = B22_esd;
		this.B23 = B23;
		this.B23_esd = B23_esd;
		this.B33 = B33;
		this.B33_esd = B33_esd;
		this.U11 = U11;
		this.U11_esd = U11_esd;
		this.U12 = U12;
		this.U12_esd = U12_esd;
		this.U13 = U13;
		this.U13_esd = U13_esd;
		this.U22 = U22;
		this.U22_esd = U22_esd;
		this.U23 = U23;
		this.U23_esd = U23_esd;
		this.U33 = U33;
		this.U33_esd = U33_esd;
		this.id_ = id_;
		this.pdbx_PDB_ins_code = pdbx_PDB_ins_code;
		this.pdbx_auth_alt_id = pdbx_auth_alt_id;
		this.pdbx_auth_asym_id = pdbx_auth_asym_id;
		this.pdbx_auth_atom_id = pdbx_auth_atom_id;
		this.pdbx_auth_comp_id = pdbx_auth_comp_id;
		this.pdbx_auth_seq_id = pdbx_auth_seq_id;
		this.pdbx_label_alt_id = pdbx_label_alt_id;
		this.pdbx_label_asym_id = pdbx_label_asym_id;
		this.pdbx_label_atom_id = pdbx_label_atom_id;
		this.pdbx_label_comp_id = pdbx_label_comp_id;
		this.pdbx_label_seq_id = pdbx_label_seq_id;
		this.ratio = ratio;
		this.type_symbol = type_symbol;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Atom_site_anisotrop");
		sb.append("\n");
		if (B11 != null)
		{
			sb.append("B11 = ");
			sb.append(B11);
			sb.append('\n');
		}
		if (B11_esd != null)
		{
			sb.append("B11_esd = ");
			sb.append(B11_esd);
			sb.append('\n');
		}
		if (B12 != null)
		{
			sb.append("B12 = ");
			sb.append(B12);
			sb.append('\n');
		}
		if (B12_esd != null)
		{
			sb.append("B12_esd = ");
			sb.append(B12_esd);
			sb.append('\n');
		}
		if (B13 != null)
		{
			sb.append("B13 = ");
			sb.append(B13);
			sb.append('\n');
		}
		if (B13_esd != null)
		{
			sb.append("B13_esd = ");
			sb.append(B13_esd);
			sb.append('\n');
		}
		if (B22 != null)
		{
			sb.append("B22 = ");
			sb.append(B22);
			sb.append('\n');
		}
		if (B22_esd != null)
		{
			sb.append("B22_esd = ");
			sb.append(B22_esd);
			sb.append('\n');
		}
		if (B23 != null)
		{
			sb.append("B23 = ");
			sb.append(B23);
			sb.append('\n');
		}
		if (B23_esd != null)
		{
			sb.append("B23_esd = ");
			sb.append(B23_esd);
			sb.append('\n');
		}
		if (B33 != null)
		{
			sb.append("B33 = ");
			sb.append(B33);
			sb.append('\n');
		}
		if (B33_esd != null)
		{
			sb.append("B33_esd = ");
			sb.append(B33_esd);
			sb.append('\n');
		}
		if (U11 != null)
		{
			sb.append("U11 = ");
			sb.append(U11);
			sb.append('\n');
		}
		if (U11_esd != null)
		{
			sb.append("U11_esd = ");
			sb.append(U11_esd);
			sb.append('\n');
		}
		if (U12 != null)
		{
			sb.append("U12 = ");
			sb.append(U12);
			sb.append('\n');
		}
		if (U12_esd != null)
		{
			sb.append("U12_esd = ");
			sb.append(U12_esd);
			sb.append('\n');
		}
		if (U13 != null)
		{
			sb.append("U13 = ");
			sb.append(U13);
			sb.append('\n');
		}
		if (U13_esd != null)
		{
			sb.append("U13_esd = ");
			sb.append(U13_esd);
			sb.append('\n');
		}
		if (U22 != null)
		{
			sb.append("U22 = ");
			sb.append(U22);
			sb.append('\n');
		}
		if (U22_esd != null)
		{
			sb.append("U22_esd = ");
			sb.append(U22_esd);
			sb.append('\n');
		}
		if (U23 != null)
		{
			sb.append("U23 = ");
			sb.append(U23);
			sb.append('\n');
		}
		if (U23_esd != null)
		{
			sb.append("U23_esd = ");
			sb.append(U23_esd);
			sb.append('\n');
		}
		if (U33 != null)
		{
			sb.append("U33 = ");
			sb.append(U33);
			sb.append('\n');
		}
		if (U33_esd != null)
		{
			sb.append("U33_esd = ");
			sb.append(U33_esd);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_PDB_ins_code != null)
		{
			sb.append("pdbx_PDB_ins_code = ");
			sb.append(pdbx_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_auth_alt_id != null)
		{
			sb.append("pdbx_auth_alt_id = ");
			sb.append(pdbx_auth_alt_id);
			sb.append('\n');
		}
		if (pdbx_auth_asym_id != null)
		{
			sb.append("pdbx_auth_asym_id = ");
			sb.append(pdbx_auth_asym_id);
			sb.append('\n');
		}
		if (pdbx_auth_atom_id != null)
		{
			sb.append("pdbx_auth_atom_id = ");
			sb.append(pdbx_auth_atom_id);
			sb.append('\n');
		}
		if (pdbx_auth_comp_id != null)
		{
			sb.append("pdbx_auth_comp_id = ");
			sb.append(pdbx_auth_comp_id);
			sb.append('\n');
		}
		if (pdbx_auth_seq_id != null)
		{
			sb.append("pdbx_auth_seq_id = ");
			sb.append(pdbx_auth_seq_id);
			sb.append('\n');
		}
		if (pdbx_label_alt_id != null)
		{
			sb.append("pdbx_label_alt_id = ");
			sb.append(pdbx_label_alt_id);
			sb.append('\n');
		}
		if (pdbx_label_asym_id != null)
		{
			sb.append("pdbx_label_asym_id = ");
			sb.append(pdbx_label_asym_id);
			sb.append('\n');
		}
		if (pdbx_label_atom_id != null)
		{
			sb.append("pdbx_label_atom_id = ");
			sb.append(pdbx_label_atom_id);
			sb.append('\n');
		}
		if (pdbx_label_comp_id != null)
		{
			sb.append("pdbx_label_comp_id = ");
			sb.append(pdbx_label_comp_id);
			sb.append('\n');
		}
		if (pdbx_label_seq_id != null)
		{
			sb.append("pdbx_label_seq_id = ");
			sb.append(pdbx_label_seq_id);
			sb.append('\n');
		}
		if (ratio != null)
		{
			sb.append("ratio = ");
			sb.append(ratio);
			sb.append('\n');
		}
		if (type_symbol != null)
		{
			sb.append("type_symbol = ");
			sb.append(type_symbol);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		B11 = null;
		B11_esd = null;
		B12 = null;
		B12_esd = null;
		B13 = null;
		B13_esd = null;
		B22 = null;
		B22_esd = null;
		B23 = null;
		B23_esd = null;
		B33 = null;
		B33_esd = null;
		U11 = null;
		U11_esd = null;
		U12 = null;
		U12_esd = null;
		U13 = null;
		U13_esd = null;
		U22 = null;
		U22_esd = null;
		U23 = null;
		U23_esd = null;
		U33 = null;
		U33_esd = null;
		id_ = null;
		pdbx_PDB_ins_code = null;
		pdbx_auth_alt_id = null;
		pdbx_auth_asym_id = null;
		pdbx_auth_atom_id = null;
		pdbx_auth_comp_id = null;
		pdbx_auth_seq_id = null;
		pdbx_label_alt_id = null;
		pdbx_label_asym_id = null;
		pdbx_label_atom_id = null;
		pdbx_label_comp_id = null;
		pdbx_label_seq_id = null;
		ratio = null;
		type_symbol = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Atom_site_anisotrop)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:atom_site_anisotrop>\n");
			if (B11 != null) ow.write(indent + " <PDBx:B11>" + B11 + "</PDBx:B11>\n");
			if (B11_esd != null) ow.write(indent + " <PDBx:B11_esd>" + B11_esd + "</PDBx:B11_esd>\n");
			if (B12 != null) ow.write(indent + " <PDBx:B12>" + B12 + "</PDBx:B12>\n");
			if (B12_esd != null) ow.write(indent + " <PDBx:B12_esd>" + B12_esd + "</PDBx:B12_esd>\n");
			if (B13 != null) ow.write(indent + " <PDBx:B13>" + B13 + "</PDBx:B13>\n");
			if (B13_esd != null) ow.write(indent + " <PDBx:B13_esd>" + B13_esd + "</PDBx:B13_esd>\n");
			if (B22 != null) ow.write(indent + " <PDBx:B22>" + B22 + "</PDBx:B22>\n");
			if (B22_esd != null) ow.write(indent + " <PDBx:B22_esd>" + B22_esd + "</PDBx:B22_esd>\n");
			if (B23 != null) ow.write(indent + " <PDBx:B23>" + B23 + "</PDBx:B23>\n");
			if (B23_esd != null) ow.write(indent + " <PDBx:B23_esd>" + B23_esd + "</PDBx:B23_esd>\n");
			if (B33 != null) ow.write(indent + " <PDBx:B33>" + B33 + "</PDBx:B33>\n");
			if (B33_esd != null) ow.write(indent + " <PDBx:B33_esd>" + B33_esd + "</PDBx:B33_esd>\n");
			if (U11 != null) ow.write(indent + " <PDBx:U11>" + U11 + "</PDBx:U11>\n");
			if (U11_esd != null) ow.write(indent + " <PDBx:U11_esd>" + U11_esd + "</PDBx:U11_esd>\n");
			if (U12 != null) ow.write(indent + " <PDBx:U12>" + U12 + "</PDBx:U12>\n");
			if (U12_esd != null) ow.write(indent + " <PDBx:U12_esd>" + U12_esd + "</PDBx:U12_esd>\n");
			if (U13 != null) ow.write(indent + " <PDBx:U13>" + U13 + "</PDBx:U13>\n");
			if (U13_esd != null) ow.write(indent + " <PDBx:U13_esd>" + U13_esd + "</PDBx:U13_esd>\n");
			if (U22 != null) ow.write(indent + " <PDBx:U22>" + U22 + "</PDBx:U22>\n");
			if (U22_esd != null) ow.write(indent + " <PDBx:U22_esd>" + U22_esd + "</PDBx:U22_esd>\n");
			if (U23 != null) ow.write(indent + " <PDBx:U23>" + U23 + "</PDBx:U23>\n");
			if (U23_esd != null) ow.write(indent + " <PDBx:U23_esd>" + U23_esd + "</PDBx:U23_esd>\n");
			if (U33 != null) ow.write(indent + " <PDBx:U33>" + U33 + "</PDBx:U33>\n");
			if (U33_esd != null) ow.write(indent + " <PDBx:U33_esd>" + U33_esd + "</PDBx:U33_esd>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_PDB_ins_code>" + pdbx_PDB_ins_code + "</PDBx:pdbx_PDB_ins_code>\n");
			if (pdbx_auth_alt_id != null) ow.write(indent + " <PDBx:pdbx_auth_alt_id>" + pdbx_auth_alt_id + "</PDBx:pdbx_auth_alt_id>\n");
			if (pdbx_auth_asym_id != null) ow.write(indent + " <PDBx:pdbx_auth_asym_id>" + pdbx_auth_asym_id + "</PDBx:pdbx_auth_asym_id>\n");
			if (pdbx_auth_atom_id != null) ow.write(indent + " <PDBx:pdbx_auth_atom_id>" + pdbx_auth_atom_id + "</PDBx:pdbx_auth_atom_id>\n");
			if (pdbx_auth_comp_id != null) ow.write(indent + " <PDBx:pdbx_auth_comp_id>" + pdbx_auth_comp_id + "</PDBx:pdbx_auth_comp_id>\n");
			if (pdbx_auth_seq_id != null) ow.write(indent + " <PDBx:pdbx_auth_seq_id>" + pdbx_auth_seq_id + "</PDBx:pdbx_auth_seq_id>\n");
			if (pdbx_label_alt_id != null) ow.write(indent + " <PDBx:pdbx_label_alt_id>" + pdbx_label_alt_id + "</PDBx:pdbx_label_alt_id>\n");
			if (pdbx_label_asym_id != null) ow.write(indent + " <PDBx:pdbx_label_asym_id>" + pdbx_label_asym_id + "</PDBx:pdbx_label_asym_id>\n");
			if (pdbx_label_atom_id != null) ow.write(indent + " <PDBx:pdbx_label_atom_id>" + pdbx_label_atom_id + "</PDBx:pdbx_label_atom_id>\n");
			if (pdbx_label_comp_id != null) ow.write(indent + " <PDBx:pdbx_label_comp_id>" + pdbx_label_comp_id + "</PDBx:pdbx_label_comp_id>\n");
			if (pdbx_label_seq_id != null) ow.write(indent + " <PDBx:pdbx_label_seq_id>" + pdbx_label_seq_id + "</PDBx:pdbx_label_seq_id>\n");
			if (ratio != null) ow.write(indent + " <PDBx:ratio>" + ratio + "</PDBx:ratio>\n");
			if (type_symbol != null) ow.write(indent + " <PDBx:type_symbol>" + type_symbol + "</PDBx:type_symbol>\n");
			ow.write(indent + "</PDBx:atom_site_anisotrop>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
