package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ATOM_SITES_ALT_ENS category record details
 *  about the ensemble structure generated from atoms with various
 *  alternative conformation IDs.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sites_alt_ensCategory>
 *  <PDBx:atom_sites_alt_ens id="Ensemble 1-A">
 *  <PDBx:details> The inhibitor binds to the enzyme in two, roughly twofold
 *  symmetric alternative conformations.
 *  This conformational ensemble includes the more populated
 *  conformation of the inhibitor (ID=1) and the amino-acid
 *  side chains and solvent structure that correlate with this
 *  inhibitor conformation.
 *  Also included are one set (ID=3) of side chains with
 *  alternative conformations when the conformations are not
 *  correlated with the inhibitor conformation.</PDBx:details>
 *  </PDBx:atom_sites_alt_ens>
 *  <PDBx:atom_sites_alt_ens id="Ensemble 1-B">
 *  <PDBx:details> The inhibitor binds to the enzyme in two, roughly twofold
 *  symmetric alternative conformations.
 *  This conformational ensemble includes the more populated
 *  conformation of the inhibitor (ID=1) and the amino-acid
 *  side chains and solvent structure that correlate with
 *  this inhibitor conformation.
 *  Also included are one set (ID=4) of side chains with
 *  alternative conformations when the conformations are not
 *  correlated with the inhibitor conformation.</PDBx:details>
 *  </PDBx:atom_sites_alt_ens>
 *  <PDBx:atom_sites_alt_ens id="Ensemble 2-A">
 *  <PDBx:details> The inhibitor binds to the enzyme in two, roughly twofold
 *  symmetric alternative conformations.
 *  This conformational ensemble includes the less populated
 *  conformation of the inhibitor (ID=2) and the amino-acid
 *  side chains and solvent structure that correlate with this
 *  inhibitor conformation.
 *  Also included are one set (ID=3) of side chains with
 *  alternative conformations when the conformations are not
 *  correlated with the inhibitor conformation.</PDBx:details>
 *  </PDBx:atom_sites_alt_ens>
 *  <PDBx:atom_sites_alt_ens id="Ensemble 2-B">
 *  <PDBx:details> The inhibitor binds to the enzyme in two, roughly twofold
 *  symmetric alternative conformations.
 *  This conformational ensemble includes the less populated
 *  conformation of the inhibitor (ID=2) and the amino-acid
 *  side chains and solvent structure that correlate with this
 *  inhibitor conformation.
 *  Also included are one set (ID=4) of side chains with
 *  alternative conformations when the conformations are not
 *  correlated with the inhibitor conformation.</PDBx:details>
 *  </PDBx:atom_sites_alt_ens>
 *  </PDBx:atom_sites_alt_ensCategory>
 * </pre>
 */
public class Atom_sites_alt_ens extends org.pdb.beans.Atom_sites_alt_ens implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "atom_sites_alt_ens";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Atom_sites_alt_ens()
	{
	}

	/** Full constructor */
	public Atom_sites_alt_ens(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Atom_sites_alt_ens");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Atom_sites_alt_ens)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:atom_sites_alt_ens>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:atom_sites_alt_ens>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
