package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ATOM_SITES_ALT_GEN category record details
 *  about the interpretation of multiple conformations in the
 *  structure.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sites_alt_genCategory>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-A" alt_id=""></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-A" alt_id="1"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-A" alt_id="3"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-B" alt_id=""></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-B" alt_id="1"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-B" alt_id="4"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-A" alt_id=""></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-A" alt_id="2"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-A" alt_id="3"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-B" alt_id=""></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-B" alt_id="2"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-B" alt_id="4"></PDBx:atom_sites_alt_gen>
 *  </PDBx:atom_sites_alt_genCategory>
 * </pre>
 */
public class Atom_sites_alt_gen extends org.pdb.beans.Atom_sites_alt_gen implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "atom_sites_alt_gen";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Atom_sites_alt_gen()
	{
	}

	/** Full constructor */
	public Atom_sites_alt_gen(
		Datablock datablock,
		java.lang.String alt_id,
		java.lang.String ens_id)
	{
		this.datablock = datablock;
		this.alt_id = alt_id;
		this.ens_id = ens_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Atom_sites_alt_gen");
		sb.append("\n");
		if (alt_id != null)
		{
			sb.append("alt_id = ");
			sb.append(alt_id);
			sb.append('\n');
		}
		if (ens_id != null)
		{
			sb.append("ens_id = ");
			sb.append(ens_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		alt_id = null;
		ens_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Atom_sites_alt_gen)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:atom_sites_alt_gen>\n");
			if (alt_id != null) ow.write(indent + " <PDBx:alt_id>" + alt_id + "</PDBx:alt_id>\n");
			if (ens_id != null) ow.write(indent + " <PDBx:ens_id>" + ens_id + "</PDBx:ens_id>\n");
			ow.write(indent + "</PDBx:atom_sites_alt_gen>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
