package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ATOM_SITES_FOOTNOTE category record detailed
 *  comments about an atom site or a group of atom sites.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sites_footnoteCategory>
 *  <PDBx:atom_sites_footnote id="1">
 *  <PDBx:text> The inhibitor binds to the enzyme in two alternative
 *  orientations. The two orientations have been assigned
 *  alternative IDs *1* and *2*.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  <PDBx:atom_sites_footnote id="2">
 *  <PDBx:text> Side chains of these residues adopt alternative
 *  orientations that correlate with the alternative
 *  orientations of the inhibitor.
 *  Side chains with alternative ID *1* and occupancy 0.58
 *  correlate with inhibitor orientation *1*.
 *  Side chains with alternative ID *2* and occupancy 0.42
 *  correlate with inhibitor orientation *2*.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  <PDBx:atom_sites_footnote id="3">
 *  <PDBx:text> The positions of these water molecules correlate with
 *  the alternative orientations of the inhibitor.
 *  Water molecules with alternative ID *1* and occupancy 0.58
 *  correlate with inhibitor orientation *1*.
 *  Water molecules with alternative ID *2* and occupancy 0.42
 *  correlate with inhibitor orientation *2*.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  <PDBx:atom_sites_footnote id="4">
 *  <PDBx:text> Side chains of these residues adopt alternative
 *  orientations that do not correlate with the alternative
 *  orientation of the inhibitor.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  <PDBx:atom_sites_footnote id="5">
 *  <PDBx:text> The positions of these water molecules correlate with
 *  alternative orientations of amino-acid side chains that
 *  do not correlate with alternative orientations of the
 *  inhibitor.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  </PDBx:atom_sites_footnoteCategory>
 * </pre>
 */
public class Atom_sites_footnote extends org.pdb.beans.Atom_sites_footnote implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "atom_sites_footnote";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Atom_sites_footnote()
	{
	}

	/** Full constructor */
	public Atom_sites_footnote(
		Datablock datablock,
		java.lang.String id_,
		java.lang.String text)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.text = text;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Atom_sites_footnote");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (text != null)
		{
			sb.append("text = ");
			sb.append(text);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		text = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Atom_sites_footnote)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:atom_sites_footnote>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (text != null) ow.write(indent + " <PDBx:text>" + text + "</PDBx:text>\n");
			ow.write(indent + "</PDBx:atom_sites_footnote>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
