package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the AUDIT_CONFORM category describe the
 *  dictionary versions against which the data names appearing in
 *  the current data block are conformant.
 *  
 * <pre>
 *  Example 1 - any file conforming to the current CIF core dictionary.
 *  <PDBx:audit_conformCategory>
 *  <PDBx:audit_conform dict_name="cif_core.dic" dict_version="2.3.1">
 *  <PDBx:dict_location>ftp://ftp.iucr.org/pub/cif_core.2.3.1.dic</PDBx:dict_location>
 *  </PDBx:audit_conform>
 *  </PDBx:audit_conformCategory>
 * </pre>
 */
public class Audit_conform extends org.pdb.beans.Audit_conform implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "audit_conform";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Audit_conform()
	{
	}

	/** Full constructor */
	public Audit_conform(
		Datablock datablock,
		java.lang.String dict_location,
		java.lang.String dict_name,
		java.lang.String dict_version)
	{
		this.datablock = datablock;
		this.dict_location = dict_location;
		this.dict_name = dict_name;
		this.dict_version = dict_version;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Audit_conform");
		sb.append("\n");
		if (dict_location != null)
		{
			sb.append("dict_location = ");
			sb.append(dict_location);
			sb.append('\n');
		}
		if (dict_name != null)
		{
			sb.append("dict_name = ");
			sb.append(dict_name);
			sb.append('\n');
		}
		if (dict_version != null)
		{
			sb.append("dict_version = ");
			sb.append(dict_version);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		dict_location = null;
		dict_name = null;
		dict_version = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Audit_conform)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:audit_conform>\n");
			if (dict_location != null) ow.write(indent + " <PDBx:dict_location>" + dict_location + "</PDBx:dict_location>\n");
			if (dict_name != null) ow.write(indent + " <PDBx:dict_name>" + dict_name + "</PDBx:dict_name>\n");
			if (dict_version != null) ow.write(indent + " <PDBx:dict_version>" + dict_version + "</PDBx:dict_version>\n");
			ow.write(indent + "</PDBx:audit_conform>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
