package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the AUDIT_CONTACT_AUTHOR category record details
 *  about the name and address of the author to be contacted
 *  concerning the content of this data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:audit_contact_authorCategory>
 *  <PDBx:audit_contact_author name="Fitzgerald, Paula M.D.">
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  PO Box 2000, Ry80M203
 *  Rahway, New Jersey 07065
 *  USA</PDBx:address>
 *  <PDBx:phone>1(908)5945510</PDBx:phone>
 *  <PDBx:fax>1(908)5946645</PDBx:fax>
 *  <PDBx:email>paula_fitzgerald@merck.com</PDBx:email>
 *  </PDBx:audit_contact_author>
 *  </PDBx:audit_contact_authorCategory>
 * </pre>
 */
public class Audit_contact_author extends org.pdb.beans.Audit_contact_author implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "audit_contact_author";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Audit_contact_author()
	{
	}

	/** Full constructor */
	public Audit_contact_author(
		Datablock datablock,
		java.lang.String address,
		java.lang.String email,
		java.lang.String fax,
		java.lang.String name,
		java.lang.String phone)
	{
		this.datablock = datablock;
		this.address = address;
		this.email = email;
		this.fax = fax;
		this.name = name;
		this.phone = phone;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Audit_contact_author");
		sb.append("\n");
		if (address != null)
		{
			sb.append("address = ");
			sb.append(address);
			sb.append('\n');
		}
		if (email != null)
		{
			sb.append("email = ");
			sb.append(email);
			sb.append('\n');
		}
		if (fax != null)
		{
			sb.append("fax = ");
			sb.append(fax);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (phone != null)
		{
			sb.append("phone = ");
			sb.append(phone);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		address = null;
		email = null;
		fax = null;
		name = null;
		phone = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Audit_contact_author)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:audit_contact_author>\n");
			if (address != null) ow.write(indent + " <PDBx:address>" + address + "</PDBx:address>\n");
			if (email != null) ow.write(indent + " <PDBx:email>" + email + "</PDBx:email>\n");
			if (fax != null) ow.write(indent + " <PDBx:fax>" + fax + "</PDBx:fax>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (phone != null) ow.write(indent + " <PDBx:phone>" + phone + "</PDBx:phone>\n");
			ow.write(indent + "</PDBx:audit_contact_author>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
