package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CELL_MEASUREMENT category record details
 *  about the measurement of the crystallographic cell parameters.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:cell_measurementCategory>
 *  <PDBx:cell_measurement entry_id="5HVP">
 *  <PDBx:temp>293.</PDBx:temp>
 *  <PDBx:temp_esd>3.</PDBx:temp_esd>
 *  <PDBx:theta_min>11.</PDBx:theta_min>
 *  <PDBx:theta_max>31.</PDBx:theta_max>
 *  <PDBx:wavelength>1.54</PDBx:wavelength>
 *  </PDBx:cell_measurement>
 *  </PDBx:cell_measurementCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:cell_measurementCategory>
 *  <PDBx:cell_measurement>
 *  <PDBx:temp>293.</PDBx:temp>
 *  <PDBx:reflns_used>25</PDBx:reflns_used>
 *  <PDBx:theta_min>25.</PDBx:theta_min>
 *  <PDBx:theta_max>31.</PDBx:theta_max>
 *  </PDBx:cell_measurement>
 *  </PDBx:cell_measurementCategory>
 * </pre>
 */
public class Cell_measurement extends org.pdb.beans.Cell_measurement implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "cell_measurement";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Cell_measurement()
	{
	}

	/** Full constructor */
	public Cell_measurement(
		Datablock datablock,
		java.lang.String entry_id,
		java.lang.Float pressure,
		java.lang.Float pressure_esd,
		java.lang.String radiation,
		java.lang.Integer reflns_used,
		java.lang.Float temp,
		java.lang.Float temp_esd,
		java.lang.Float theta_max,
		java.lang.Float theta_min,
		java.lang.Float wavelength)
	{
		this.datablock = datablock;
		this.entry_id = entry_id;
		this.pressure = pressure;
		this.pressure_esd = pressure_esd;
		this.radiation = radiation;
		this.reflns_used = reflns_used;
		this.temp = temp;
		this.temp_esd = temp_esd;
		this.theta_max = theta_max;
		this.theta_min = theta_min;
		this.wavelength = wavelength;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Cell_measurement");
		sb.append("\n");
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (pressure != null)
		{
			sb.append("pressure = ");
			sb.append(pressure);
			sb.append('\n');
		}
		if (pressure_esd != null)
		{
			sb.append("pressure_esd = ");
			sb.append(pressure_esd);
			sb.append('\n');
		}
		if (radiation != null)
		{
			sb.append("radiation = ");
			sb.append(radiation);
			sb.append('\n');
		}
		if (reflns_used != null)
		{
			sb.append("reflns_used = ");
			sb.append(reflns_used);
			sb.append('\n');
		}
		if (temp != null)
		{
			sb.append("temp = ");
			sb.append(temp);
			sb.append('\n');
		}
		if (temp_esd != null)
		{
			sb.append("temp_esd = ");
			sb.append(temp_esd);
			sb.append('\n');
		}
		if (theta_max != null)
		{
			sb.append("theta_max = ");
			sb.append(theta_max);
			sb.append('\n');
		}
		if (theta_min != null)
		{
			sb.append("theta_min = ");
			sb.append(theta_min);
			sb.append('\n');
		}
		if (wavelength != null)
		{
			sb.append("wavelength = ");
			sb.append(wavelength);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entry_id = null;
		pressure = null;
		pressure_esd = null;
		radiation = null;
		reflns_used = null;
		temp = null;
		temp_esd = null;
		theta_max = null;
		theta_min = null;
		wavelength = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Cell_measurement)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:cell_measurement>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (pressure != null) ow.write(indent + " <PDBx:pressure>" + pressure + "</PDBx:pressure>\n");
			if (pressure_esd != null) ow.write(indent + " <PDBx:pressure_esd>" + pressure_esd + "</PDBx:pressure_esd>\n");
			if (radiation != null) ow.write(indent + " <PDBx:radiation>" + radiation + "</PDBx:radiation>\n");
			if (reflns_used != null) ow.write(indent + " <PDBx:reflns_used>" + reflns_used + "</PDBx:reflns_used>\n");
			if (temp != null) ow.write(indent + " <PDBx:temp>" + temp + "</PDBx:temp>\n");
			if (temp_esd != null) ow.write(indent + " <PDBx:temp_esd>" + temp_esd + "</PDBx:temp_esd>\n");
			if (theta_max != null) ow.write(indent + " <PDBx:theta_max>" + theta_max + "</PDBx:theta_max>\n");
			if (theta_min != null) ow.write(indent + " <PDBx:theta_min>" + theta_min + "</PDBx:theta_min>\n");
			if (wavelength != null) ow.write(indent + " <PDBx:wavelength>" + wavelength + "</PDBx:wavelength>\n");
			ow.write(indent + "</PDBx:cell_measurement>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
