package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CELL_MEASUREMENT_REFLN category record
 *  details about the reflections used to determine the
 *  crystallographic cell parameters.
 *  
 *  The CELL_MEASUREMENT_REFLN data items would in general be used
 *  only for diffractometer data.
 *  
 * <pre>
 *  Example 1 - extracted from the CAD-4 listing of Rb~2~S~2~O~6~ at room
 *  temperature (unpublished).
 *  <PDBx:cell_measurement_reflnCategory>
 *  <PDBx:cell_measurement_refln index_h="-2" index_k="4" index_l="1">
 *  <PDBx:theta>8.67</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="0" index_k="3" index_l="2">
 *  <PDBx:theta>9.45</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="3" index_k="0" index_l="2">
 *  <PDBx:theta>9.46</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="-3" index_k="4" index_l="1">
 *  <PDBx:theta>8.93</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="-2" index_k="1" index_l="-2">
 *  <PDBx:theta>7.53</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="10" index_k="0" index_l="0">
 *  <PDBx:theta>23.77</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="0" index_k="10" index_l="0">
 *  <PDBx:theta>23.78</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="-5" index_k="4" index_l="1">
 *  <PDBx:theta>11.14</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  </PDBx:cell_measurement_reflnCategory>
 * </pre>
 */
public class Cell_measurement_refln extends org.pdb.beans.Cell_measurement_refln implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "cell_measurement_refln";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Cell_measurement_refln()
	{
	}

	/** Full constructor */
	public Cell_measurement_refln(
		Datablock datablock,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l,
		java.lang.Float theta)
	{
		this.datablock = datablock;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
		this.theta = theta;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Cell_measurement_refln");
		sb.append("\n");
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		if (theta != null)
		{
			sb.append("theta = ");
			sb.append(theta);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		index_h = null;
		index_k = null;
		index_l = null;
		theta = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Cell_measurement_refln)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:cell_measurement_refln>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			if (theta != null) ow.write(indent + " <PDBx:theta>" + theta + "</PDBx:theta>\n");
			ow.write(indent + "</PDBx:cell_measurement_refln>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
