package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP category give details about each
 *  of the chemical components from which the relevant chemical
 *  structures can be constructed, such as name, mass or charge.
 *  
 *  The related categories CHEM_COMP_ATOM, CHEM_COMP_BOND,
 *  CHEM_COMP_ANGLE etc. describe the detailed geometry of these
 *  chemical components.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_compCategory>
 *  <PDBx:chem_comp id="phe">
 *  <PDBx:model_source>1987 Protin/Prolsq Ideals file</PDBx:model_source>
 *  <PDBx:name>phenylalanine</PDBx:name>
 *  </PDBx:chem_comp>
 *  <PDBx:chem_comp id="val">
 *  <PDBx:model_source>1987 Protin/Prolsq Ideals file</PDBx:model_source>
 *  <PDBx:name>alanine</PDBx:name>
 *  </PDBx:chem_comp>
 *  </PDBx:chem_compCategory>
 * </pre>
 */
public class Chem_comp extends org.pdb.beans.Chem_comp implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp()
	{
	}

	/** Full constructor */
	public Chem_comp(
		Datablock datablock,
		java.lang.String formula,
		java.lang.Float formula_weight,
		java.lang.String id_,
		java.lang.String model_details,
		java.lang.String model_erf,
		java.lang.String model_source,
		java.lang.String mon_nstd_class,
		java.lang.String mon_nstd_details,
		java.lang.String mon_nstd_flag,
		java.lang.String mon_nstd_parent,
		java.lang.String mon_nstd_parent_comp_id,
		java.lang.String name,
		java.lang.Integer number_atoms_all,
		java.lang.Integer number_atoms_nh,
		java.lang.String one_letter_code,
		java.lang.String pdbx_ambiguous_flag,
		java.lang.Integer pdbx_component_no,
		java.lang.Integer pdbx_formal_charge,
		java.lang.String pdbx_ideal_coordinates_details,
		java.lang.String pdbx_ideal_coordinates_missing_flag,
		java.util.Date pdbx_initial_date,
		java.lang.String pdbx_model_coordinates_db_code,
		java.lang.String pdbx_model_coordinates_details,
		java.lang.String pdbx_model_coordinates_missing_flag,
		java.lang.String pdbx_modification_details,
		java.util.Date pdbx_modified_date,
		java.lang.String pdbx_release_status,
		java.lang.String pdbx_replaced_by,
		java.lang.String pdbx_replaces,
		java.lang.String pdbx_synonyms,
		java.lang.String pdbx_type,
		java.lang.String three_letter_code,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.formula = formula;
		this.formula_weight = formula_weight;
		this.id_ = id_;
		this.model_details = model_details;
		this.model_erf = model_erf;
		this.model_source = model_source;
		this.mon_nstd_class = mon_nstd_class;
		this.mon_nstd_details = mon_nstd_details;
		this.mon_nstd_flag = mon_nstd_flag;
		this.mon_nstd_parent = mon_nstd_parent;
		this.mon_nstd_parent_comp_id = mon_nstd_parent_comp_id;
		this.name = name;
		this.number_atoms_all = number_atoms_all;
		this.number_atoms_nh = number_atoms_nh;
		this.one_letter_code = one_letter_code;
		this.pdbx_ambiguous_flag = pdbx_ambiguous_flag;
		this.pdbx_component_no = pdbx_component_no;
		this.pdbx_formal_charge = pdbx_formal_charge;
		this.pdbx_ideal_coordinates_details = pdbx_ideal_coordinates_details;
		this.pdbx_ideal_coordinates_missing_flag = pdbx_ideal_coordinates_missing_flag;
		this.pdbx_initial_date = pdbx_initial_date;
		this.pdbx_model_coordinates_db_code = pdbx_model_coordinates_db_code;
		this.pdbx_model_coordinates_details = pdbx_model_coordinates_details;
		this.pdbx_model_coordinates_missing_flag = pdbx_model_coordinates_missing_flag;
		this.pdbx_modification_details = pdbx_modification_details;
		this.pdbx_modified_date = pdbx_modified_date;
		this.pdbx_release_status = pdbx_release_status;
		this.pdbx_replaced_by = pdbx_replaced_by;
		this.pdbx_replaces = pdbx_replaces;
		this.pdbx_synonyms = pdbx_synonyms;
		this.pdbx_type = pdbx_type;
		this.three_letter_code = three_letter_code;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp");
		sb.append("\n");
		if (formula != null)
		{
			sb.append("formula = ");
			sb.append(formula);
			sb.append('\n');
		}
		if (formula_weight != null)
		{
			sb.append("formula_weight = ");
			sb.append(formula_weight);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (model_details != null)
		{
			sb.append("model_details = ");
			sb.append(model_details);
			sb.append('\n');
		}
		if (model_erf != null)
		{
			sb.append("model_erf = ");
			sb.append(model_erf);
			sb.append('\n');
		}
		if (model_source != null)
		{
			sb.append("model_source = ");
			sb.append(model_source);
			sb.append('\n');
		}
		if (mon_nstd_class != null)
		{
			sb.append("mon_nstd_class = ");
			sb.append(mon_nstd_class);
			sb.append('\n');
		}
		if (mon_nstd_details != null)
		{
			sb.append("mon_nstd_details = ");
			sb.append(mon_nstd_details);
			sb.append('\n');
		}
		if (mon_nstd_flag != null)
		{
			sb.append("mon_nstd_flag = ");
			sb.append(mon_nstd_flag);
			sb.append('\n');
		}
		if (mon_nstd_parent != null)
		{
			sb.append("mon_nstd_parent = ");
			sb.append(mon_nstd_parent);
			sb.append('\n');
		}
		if (mon_nstd_parent_comp_id != null)
		{
			sb.append("mon_nstd_parent_comp_id = ");
			sb.append(mon_nstd_parent_comp_id);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (number_atoms_all != null)
		{
			sb.append("number_atoms_all = ");
			sb.append(number_atoms_all);
			sb.append('\n');
		}
		if (number_atoms_nh != null)
		{
			sb.append("number_atoms_nh = ");
			sb.append(number_atoms_nh);
			sb.append('\n');
		}
		if (one_letter_code != null)
		{
			sb.append("one_letter_code = ");
			sb.append(one_letter_code);
			sb.append('\n');
		}
		if (pdbx_ambiguous_flag != null)
		{
			sb.append("pdbx_ambiguous_flag = ");
			sb.append(pdbx_ambiguous_flag);
			sb.append('\n');
		}
		if (pdbx_component_no != null)
		{
			sb.append("pdbx_component_no = ");
			sb.append(pdbx_component_no);
			sb.append('\n');
		}
		if (pdbx_formal_charge != null)
		{
			sb.append("pdbx_formal_charge = ");
			sb.append(pdbx_formal_charge);
			sb.append('\n');
		}
		if (pdbx_ideal_coordinates_details != null)
		{
			sb.append("pdbx_ideal_coordinates_details = ");
			sb.append(pdbx_ideal_coordinates_details);
			sb.append('\n');
		}
		if (pdbx_ideal_coordinates_missing_flag != null)
		{
			sb.append("pdbx_ideal_coordinates_missing_flag = ");
			sb.append(pdbx_ideal_coordinates_missing_flag);
			sb.append('\n');
		}
		if (pdbx_initial_date != null)
		{
			sb.append("pdbx_initial_date = ");
			sb.append(pdbx_initial_date);
			sb.append('\n');
		}
		if (pdbx_model_coordinates_db_code != null)
		{
			sb.append("pdbx_model_coordinates_db_code = ");
			sb.append(pdbx_model_coordinates_db_code);
			sb.append('\n');
		}
		if (pdbx_model_coordinates_details != null)
		{
			sb.append("pdbx_model_coordinates_details = ");
			sb.append(pdbx_model_coordinates_details);
			sb.append('\n');
		}
		if (pdbx_model_coordinates_missing_flag != null)
		{
			sb.append("pdbx_model_coordinates_missing_flag = ");
			sb.append(pdbx_model_coordinates_missing_flag);
			sb.append('\n');
		}
		if (pdbx_modification_details != null)
		{
			sb.append("pdbx_modification_details = ");
			sb.append(pdbx_modification_details);
			sb.append('\n');
		}
		if (pdbx_modified_date != null)
		{
			sb.append("pdbx_modified_date = ");
			sb.append(pdbx_modified_date);
			sb.append('\n');
		}
		if (pdbx_release_status != null)
		{
			sb.append("pdbx_release_status = ");
			sb.append(pdbx_release_status);
			sb.append('\n');
		}
		if (pdbx_replaced_by != null)
		{
			sb.append("pdbx_replaced_by = ");
			sb.append(pdbx_replaced_by);
			sb.append('\n');
		}
		if (pdbx_replaces != null)
		{
			sb.append("pdbx_replaces = ");
			sb.append(pdbx_replaces);
			sb.append('\n');
		}
		if (pdbx_synonyms != null)
		{
			sb.append("pdbx_synonyms = ");
			sb.append(pdbx_synonyms);
			sb.append('\n');
		}
		if (pdbx_type != null)
		{
			sb.append("pdbx_type = ");
			sb.append(pdbx_type);
			sb.append('\n');
		}
		if (three_letter_code != null)
		{
			sb.append("three_letter_code = ");
			sb.append(three_letter_code);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		formula = null;
		formula_weight = null;
		id_ = null;
		model_details = null;
		model_erf = null;
		model_source = null;
		mon_nstd_class = null;
		mon_nstd_details = null;
		mon_nstd_flag = null;
		mon_nstd_parent = null;
		mon_nstd_parent_comp_id = null;
		name = null;
		number_atoms_all = null;
		number_atoms_nh = null;
		one_letter_code = null;
		pdbx_ambiguous_flag = null;
		pdbx_component_no = null;
		pdbx_formal_charge = null;
		pdbx_ideal_coordinates_details = null;
		pdbx_ideal_coordinates_missing_flag = null;
		pdbx_initial_date = null;
		pdbx_model_coordinates_db_code = null;
		pdbx_model_coordinates_details = null;
		pdbx_model_coordinates_missing_flag = null;
		pdbx_modification_details = null;
		pdbx_modified_date = null;
		pdbx_release_status = null;
		pdbx_replaced_by = null;
		pdbx_replaces = null;
		pdbx_synonyms = null;
		pdbx_type = null;
		three_letter_code = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp>\n");
			if (formula != null) ow.write(indent + " <PDBx:formula>" + formula + "</PDBx:formula>\n");
			if (formula_weight != null) ow.write(indent + " <PDBx:formula_weight>" + formula_weight + "</PDBx:formula_weight>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (model_details != null) ow.write(indent + " <PDBx:model_details>" + model_details + "</PDBx:model_details>\n");
			if (model_erf != null) ow.write(indent + " <PDBx:model_erf>" + model_erf + "</PDBx:model_erf>\n");
			if (model_source != null) ow.write(indent + " <PDBx:model_source>" + model_source + "</PDBx:model_source>\n");
			if (mon_nstd_class != null) ow.write(indent + " <PDBx:mon_nstd_class>" + mon_nstd_class + "</PDBx:mon_nstd_class>\n");
			if (mon_nstd_details != null) ow.write(indent + " <PDBx:mon_nstd_details>" + mon_nstd_details + "</PDBx:mon_nstd_details>\n");
			if (mon_nstd_flag != null) ow.write(indent + " <PDBx:mon_nstd_flag>" + mon_nstd_flag + "</PDBx:mon_nstd_flag>\n");
			if (mon_nstd_parent != null) ow.write(indent + " <PDBx:mon_nstd_parent>" + mon_nstd_parent + "</PDBx:mon_nstd_parent>\n");
			if (mon_nstd_parent_comp_id != null) ow.write(indent + " <PDBx:mon_nstd_parent_comp_id>" + mon_nstd_parent_comp_id + "</PDBx:mon_nstd_parent_comp_id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (number_atoms_all != null) ow.write(indent + " <PDBx:number_atoms_all>" + number_atoms_all + "</PDBx:number_atoms_all>\n");
			if (number_atoms_nh != null) ow.write(indent + " <PDBx:number_atoms_nh>" + number_atoms_nh + "</PDBx:number_atoms_nh>\n");
			if (one_letter_code != null) ow.write(indent + " <PDBx:one_letter_code>" + one_letter_code + "</PDBx:one_letter_code>\n");
			if (pdbx_ambiguous_flag != null) ow.write(indent + " <PDBx:pdbx_ambiguous_flag>" + pdbx_ambiguous_flag + "</PDBx:pdbx_ambiguous_flag>\n");
			if (pdbx_component_no != null) ow.write(indent + " <PDBx:pdbx_component_no>" + pdbx_component_no + "</PDBx:pdbx_component_no>\n");
			if (pdbx_formal_charge != null) ow.write(indent + " <PDBx:pdbx_formal_charge>" + pdbx_formal_charge + "</PDBx:pdbx_formal_charge>\n");
			if (pdbx_ideal_coordinates_details != null) ow.write(indent + " <PDBx:pdbx_ideal_coordinates_details>" + pdbx_ideal_coordinates_details + "</PDBx:pdbx_ideal_coordinates_details>\n");
			if (pdbx_ideal_coordinates_missing_flag != null) ow.write(indent + " <PDBx:pdbx_ideal_coordinates_missing_flag>" + pdbx_ideal_coordinates_missing_flag + "</PDBx:pdbx_ideal_coordinates_missing_flag>\n");
			if (pdbx_initial_date != null) ow.write(indent + " <PDBx:pdbx_initial_date>" + pdbx_initial_date + "</PDBx:pdbx_initial_date>\n");
			if (pdbx_model_coordinates_db_code != null) ow.write(indent + " <PDBx:pdbx_model_coordinates_db_code>" + pdbx_model_coordinates_db_code + "</PDBx:pdbx_model_coordinates_db_code>\n");
			if (pdbx_model_coordinates_details != null) ow.write(indent + " <PDBx:pdbx_model_coordinates_details>" + pdbx_model_coordinates_details + "</PDBx:pdbx_model_coordinates_details>\n");
			if (pdbx_model_coordinates_missing_flag != null) ow.write(indent + " <PDBx:pdbx_model_coordinates_missing_flag>" + pdbx_model_coordinates_missing_flag + "</PDBx:pdbx_model_coordinates_missing_flag>\n");
			if (pdbx_modification_details != null) ow.write(indent + " <PDBx:pdbx_modification_details>" + pdbx_modification_details + "</PDBx:pdbx_modification_details>\n");
			if (pdbx_modified_date != null) ow.write(indent + " <PDBx:pdbx_modified_date>" + pdbx_modified_date + "</PDBx:pdbx_modified_date>\n");
			if (pdbx_release_status != null) ow.write(indent + " <PDBx:pdbx_release_status>" + pdbx_release_status + "</PDBx:pdbx_release_status>\n");
			if (pdbx_replaced_by != null) ow.write(indent + " <PDBx:pdbx_replaced_by>" + pdbx_replaced_by + "</PDBx:pdbx_replaced_by>\n");
			if (pdbx_replaces != null) ow.write(indent + " <PDBx:pdbx_replaces>" + pdbx_replaces + "</PDBx:pdbx_replaces>\n");
			if (pdbx_synonyms != null) ow.write(indent + " <PDBx:pdbx_synonyms>" + pdbx_synonyms + "</PDBx:pdbx_synonyms>\n");
			if (pdbx_type != null) ow.write(indent + " <PDBx:pdbx_type>" + pdbx_type + "</PDBx:pdbx_type>\n");
			if (three_letter_code != null) ow.write(indent + " <PDBx:three_letter_code>" + three_letter_code + "</PDBx:three_letter_code>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:chem_comp>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
