package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_LINK_CHIR_ATOM category enumerate the
 *  atoms bonded to a chiral atom in a link between two
 *  chemical components.
 */
public class Chem_link_chir_atom extends org.pdb.beans.Chem_link_chir_atom implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_link_chir_atom";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_link_chir_atom()
	{
	}

	/** Full constructor */
	public Chem_link_chir_atom(
		Datablock datablock,
		java.lang.String atom_comp_id,
		java.lang.String atom_id,
		java.lang.String chir_id,
		java.lang.Float dev)
	{
		this.datablock = datablock;
		this.atom_comp_id = atom_comp_id;
		this.atom_id = atom_id;
		this.chir_id = chir_id;
		this.dev = dev;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_link_chir_atom");
		sb.append("\n");
		if (atom_comp_id != null)
		{
			sb.append("atom_comp_id = ");
			sb.append(atom_comp_id);
			sb.append('\n');
		}
		if (atom_id != null)
		{
			sb.append("atom_id = ");
			sb.append(atom_id);
			sb.append('\n');
		}
		if (chir_id != null)
		{
			sb.append("chir_id = ");
			sb.append(chir_id);
			sb.append('\n');
		}
		if (dev != null)
		{
			sb.append("dev = ");
			sb.append(dev);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_comp_id = null;
		atom_id = null;
		chir_id = null;
		dev = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_link_chir_atom)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_link_chir_atom>\n");
			if (atom_comp_id != null) ow.write(indent + " <PDBx:atom_comp_id>" + atom_comp_id + "</PDBx:atom_comp_id>\n");
			if (atom_id != null) ow.write(indent + " <PDBx:atom_id>" + atom_id + "</PDBx:atom_id>\n");
			if (chir_id != null) ow.write(indent + " <PDBx:chir_id>" + chir_id + "</PDBx:chir_id>\n");
			if (dev != null) ow.write(indent + " <PDBx:dev>" + dev + "</PDBx:dev>\n");
			ow.write(indent + "</PDBx:chem_link_chir_atom>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
