package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_LINK_TOR_VALUE category record details
 *  about the target values for the torsion angles enumerated in the
 *  CHEM_LINK_TOR list. Target values may be specified as angles
 *  in degrees, as a distance between the first and fourth atoms, or
 *  both.
 */
public class Chem_link_tor_value extends org.pdb.beans.Chem_link_tor_value implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_link_tor_value";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_link_tor_value()
	{
	}

	/** Full constructor */
	public Chem_link_tor_value(
		Datablock datablock,
		java.lang.Float angle,
		java.lang.Float angle_esd,
		java.lang.Float dist,
		java.lang.Float dist_esd,
		java.lang.String tor_id)
	{
		this.datablock = datablock;
		this.angle = angle;
		this.angle_esd = angle_esd;
		this.dist = dist;
		this.dist_esd = dist_esd;
		this.tor_id = tor_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_link_tor_value");
		sb.append("\n");
		if (angle != null)
		{
			sb.append("angle = ");
			sb.append(angle);
			sb.append('\n');
		}
		if (angle_esd != null)
		{
			sb.append("angle_esd = ");
			sb.append(angle_esd);
			sb.append('\n');
		}
		if (dist != null)
		{
			sb.append("dist = ");
			sb.append(dist);
			sb.append('\n');
		}
		if (dist_esd != null)
		{
			sb.append("dist_esd = ");
			sb.append(dist_esd);
			sb.append('\n');
		}
		if (tor_id != null)
		{
			sb.append("tor_id = ");
			sb.append(tor_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		angle = null;
		angle_esd = null;
		dist = null;
		dist_esd = null;
		tor_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_link_tor_value)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_link_tor_value>\n");
			if (angle != null) ow.write(indent + " <PDBx:angle>" + angle + "</PDBx:angle>\n");
			if (angle_esd != null) ow.write(indent + " <PDBx:angle_esd>" + angle_esd + "</PDBx:angle_esd>\n");
			if (dist != null) ow.write(indent + " <PDBx:dist>" + dist + "</PDBx:dist>\n");
			if (dist_esd != null) ow.write(indent + " <PDBx:dist_esd>" + dist_esd + "</PDBx:dist_esd>\n");
			if (tor_id != null) ow.write(indent + " <PDBx:tor_id>" + tor_id + "</PDBx:tor_id>\n");
			ow.write(indent + "</PDBx:chem_link_tor_value>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
