package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEMICAL_FORMULA category would not, in
 *  general, be used in a macromolecular CIF. See instead the
 *  ENTITY data items.
 *  
 *  Data items in the CHEMICAL_FORMULA category specify the
 *  composition and chemical properties of the compound. The formula
 *  data items must agree with those that specify the density,
 *  unit-cell and Z values.
 *  
 *  The following rules apply to the construction of the data items
 *  _chemical_formula.analytical, _chemical_formula.structural and
 *  attribute sum in category chemical_formula.  For the data item
 *  attribute moiety in category chemical_formula the formula construction is broken up
 *  into residues or moieties, i.e. groups of atoms that form a
 *  molecular unit or molecular ion. The rules given below apply
 *  within each moiety but different requirements apply to the way
 *  that moieties are connected (see  attribute moiety).
 *  in category chemical_formula
 *  (1) Only recognized element symbols may be used.
 *  
 *  (2) Each element symbol is followed by a 'count' number. A count
 *  of '1' may be omitted.
 *  
 *  (3) A space or parenthesis must separate each cluster of (element
 *  symbol + count).
 *  
 *  (4) Where a group of elements is enclosed in parentheses, the
 *  multiplier for the group must follow the closing parenthesis.
 *  That is, all element and group multipliers are assumed to be
 *  printed as subscripted numbers. (An exception to this rule
 *  exists for  attribute moiety in category chemical_formula formulae where pre- and
 *  post-multipliers are permitted for molecular units.)
 *  
 *  (5) Unless the elements are ordered in a manner that corresponds
 *  to their chemical structure, as in
 *  attribute structural in category chemical_formula the order of the elements within
 *  any group or moiety should be:  C, then H, then the other
 *  elements in alphabetical order of their symbol. This is the
 *  'Hill' system used by Chemical Abstracts. This ordering is
 *  used in _chemical_formula.moiety and _chemical_formula.sum.
 *  
 * <pre>
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer [(1991).
 *  Acta Cryst. C47, 2276-2277].
 *  <PDBx:chemical_formulaCategory>
 *  <PDBx:chemical_formula entry_id="TOZ">
 *  <PDBx:moiety>C18 H25 N O3</PDBx:moiety>
 *  <PDBx:sum>C18 H25 N O3</PDBx:sum>
 *  <PDBx:weight>303.40</PDBx:weight>
 *  </PDBx:chemical_formula>
 *  </PDBx:chemical_formulaCategory>
 * </pre>
 */
public class Chemical_formula extends org.pdb.beans.Chemical_formula implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chemical_formula";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chemical_formula()
	{
	}

	/** Full constructor */
	public Chemical_formula(
		Datablock datablock,
		java.lang.String analytical,
		java.lang.String entry_id,
		java.lang.String iupac,
		java.lang.String moiety,
		java.lang.String structural,
		java.lang.String sum,
		java.lang.Float weight,
		java.lang.Float weight_meas)
	{
		this.datablock = datablock;
		this.analytical = analytical;
		this.entry_id = entry_id;
		this.iupac = iupac;
		this.moiety = moiety;
		this.structural = structural;
		this.sum = sum;
		this.weight = weight;
		this.weight_meas = weight_meas;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chemical_formula");
		sb.append("\n");
		if (analytical != null)
		{
			sb.append("analytical = ");
			sb.append(analytical);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (iupac != null)
		{
			sb.append("iupac = ");
			sb.append(iupac);
			sb.append('\n');
		}
		if (moiety != null)
		{
			sb.append("moiety = ");
			sb.append(moiety);
			sb.append('\n');
		}
		if (structural != null)
		{
			sb.append("structural = ");
			sb.append(structural);
			sb.append('\n');
		}
		if (sum != null)
		{
			sb.append("sum = ");
			sb.append(sum);
			sb.append('\n');
		}
		if (weight != null)
		{
			sb.append("weight = ");
			sb.append(weight);
			sb.append('\n');
		}
		if (weight_meas != null)
		{
			sb.append("weight_meas = ");
			sb.append(weight_meas);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		analytical = null;
		entry_id = null;
		iupac = null;
		moiety = null;
		structural = null;
		sum = null;
		weight = null;
		weight_meas = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chemical_formula)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chemical_formula>\n");
			if (analytical != null) ow.write(indent + " <PDBx:analytical>" + analytical + "</PDBx:analytical>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (iupac != null) ow.write(indent + " <PDBx:iupac>" + iupac + "</PDBx:iupac>\n");
			if (moiety != null) ow.write(indent + " <PDBx:moiety>" + moiety + "</PDBx:moiety>\n");
			if (structural != null) ow.write(indent + " <PDBx:structural>" + structural + "</PDBx:structural>\n");
			if (sum != null) ow.write(indent + " <PDBx:sum>" + sum + "</PDBx:sum>\n");
			if (weight != null) ow.write(indent + " <PDBx:weight>" + weight + "</PDBx:weight>\n");
			if (weight_meas != null) ow.write(indent + " <PDBx:weight_meas>" + weight_meas + "</PDBx:weight_meas>\n");
			ow.write(indent + "</PDBx:chemical_formula>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
