package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CITATION category record details about the
 *  literature cited as being relevant to the contents of the data
 *  block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:citationCategory>
 *  <PDBx:citation id="primary">
 *  <PDBx:coordinate_linkage>yes</PDBx:coordinate_linkage>
 *  <PDBx:title> Crystallographic analysis of a complex between human
 *  immunodeficiency virus type 1 protease and acetyl-pepstatin
 *  at 2.0-Angstroms resolution.</PDBx:title>
 *  <PDBx:country>US</PDBx:country>
 *  <PDBx:journal_abbrev>J. Biol. Chem.</PDBx:journal_abbrev>
 *  <PDBx:journal_volume>265</PDBx:journal_volume>
 *  <PDBx:page_first>14209</PDBx:page_first>
 *  <PDBx:page_last>14219</PDBx:page_last>
 *  <PDBx:year>1990</PDBx:year>
 *  <PDBx:journal_id_ASTM>HBCHA3</PDBx:journal_id_ASTM>
 *  <PDBx:journal_id_ISSN>0021-9258</PDBx:journal_id_ISSN>
 *  <PDBx:journal_id_CSD>071</PDBx:journal_id_CSD>
 *  <PDBx:details> The publication that directly relates to this coordinate
 *  set.</PDBx:details>
 *  </PDBx:citation>
 *  <PDBx:citation id="2">
 *  <PDBx:coordinate_linkage>no</PDBx:coordinate_linkage>
 *  <PDBx:title> Three-dimensional structure of aspartyl-protease from human
 *  immunodeficiency virus HIV-1.</PDBx:title>
 *  <PDBx:country>UK</PDBx:country>
 *  <PDBx:journal_abbrev>Nature</PDBx:journal_abbrev>
 *  <PDBx:journal_volume>337</PDBx:journal_volume>
 *  <PDBx:page_first>615</PDBx:page_first>
 *  <PDBx:page_last>619</PDBx:page_last>
 *  <PDBx:year>1989</PDBx:year>
 *  <PDBx:journal_id_ASTM>NATUAS</PDBx:journal_id_ASTM>
 *  <PDBx:journal_id_ISSN>0028-0836</PDBx:journal_id_ISSN>
 *  <PDBx:journal_id_CSD>006</PDBx:journal_id_CSD>
 *  <PDBx:details> Determination of the structure of the unliganded enzyme.</PDBx:details>
 *  </PDBx:citation>
 *  <PDBx:citation id="3">
 *  <PDBx:coordinate_linkage>no</PDBx:coordinate_linkage>
 *  <PDBx:title> Crystallization of the aspartylprotease from human
 *  immunodeficiency virus, HIV-1.</PDBx:title>
 *  <PDBx:country>US</PDBx:country>
 *  <PDBx:journal_abbrev>J. Biol. Chem.</PDBx:journal_abbrev>
 *  <PDBx:journal_volume>264</PDBx:journal_volume>
 *  <PDBx:page_first>1919</PDBx:page_first>
 *  <PDBx:page_last>1921</PDBx:page_last>
 *  <PDBx:year>1989</PDBx:year>
 *  <PDBx:journal_id_ASTM>HBCHA3</PDBx:journal_id_ASTM>
 *  <PDBx:journal_id_ISSN>0021-9258</PDBx:journal_id_ISSN>
 *  <PDBx:journal_id_CSD>071</PDBx:journal_id_CSD>
 *  <PDBx:details> Crystallization of the unliganded enzyme.</PDBx:details>
 *  </PDBx:citation>
 *  <PDBx:citation id="4">
 *  <PDBx:coordinate_linkage>no</PDBx:coordinate_linkage>
 *  <PDBx:title> Human immunodeficiency virus protease. Bacterial expression
 *  and characterization of the purified aspartic protease.</PDBx:title>
 *  <PDBx:country>US</PDBx:country>
 *  <PDBx:journal_abbrev>J. Biol. Chem.</PDBx:journal_abbrev>
 *  <PDBx:journal_volume>264</PDBx:journal_volume>
 *  <PDBx:page_first>2307</PDBx:page_first>
 *  <PDBx:page_last>2312</PDBx:page_last>
 *  <PDBx:year>1989</PDBx:year>
 *  <PDBx:journal_id_ASTM>HBCHA3</PDBx:journal_id_ASTM>
 *  <PDBx:journal_id_ISSN>0021-9258</PDBx:journal_id_ISSN>
 *  <PDBx:journal_id_CSD>071</PDBx:journal_id_CSD>
 *  <PDBx:details> Expression and purification of the enzyme.</PDBx:details>
 *  </PDBx:citation>
 *  </PDBx:citationCategory>
 * </pre>
 */
public class Citation extends org.pdb.beans.Citation implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "citation";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Citation()
	{
	}

	/** Full constructor */
	public Citation(
		Datablock datablock,
		java.lang.String abstract_,
		java.lang.String abstract_id_CAS,
		java.lang.String book_id_ISBN,
		java.lang.String book_publisher,
		java.lang.String book_publisher_city,
		java.lang.String book_title,
		java.lang.String coordinate_linkage,
		java.lang.String country,
		java.lang.String database_id_CSD,
		java.lang.Integer database_id_Medline,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String journal_abbrev,
		java.lang.String journal_full,
		java.lang.String journal_id_ASTM,
		java.lang.String journal_id_CSD,
		java.lang.String journal_id_ISSN,
		java.lang.String journal_issue,
		java.lang.String journal_volume,
		java.lang.String language,
		java.lang.String page_first,
		java.lang.String page_last,
		java.lang.String pdbx_database_id_DOI,
		java.lang.Integer pdbx_database_id_PubMed,
		java.lang.String title,
		java.lang.String unpublished_flag,
		java.lang.Integer year)
	{
		this.datablock = datablock;
		this.abstract_ = abstract_;
		this.abstract_id_CAS = abstract_id_CAS;
		this.book_id_ISBN = book_id_ISBN;
		this.book_publisher = book_publisher;
		this.book_publisher_city = book_publisher_city;
		this.book_title = book_title;
		this.coordinate_linkage = coordinate_linkage;
		this.country = country;
		this.database_id_CSD = database_id_CSD;
		this.database_id_Medline = database_id_Medline;
		this.details = details;
		this.id_ = id_;
		this.journal_abbrev = journal_abbrev;
		this.journal_full = journal_full;
		this.journal_id_ASTM = journal_id_ASTM;
		this.journal_id_CSD = journal_id_CSD;
		this.journal_id_ISSN = journal_id_ISSN;
		this.journal_issue = journal_issue;
		this.journal_volume = journal_volume;
		this.language = language;
		this.page_first = page_first;
		this.page_last = page_last;
		this.pdbx_database_id_DOI = pdbx_database_id_DOI;
		this.pdbx_database_id_PubMed = pdbx_database_id_PubMed;
		this.title = title;
		this.unpublished_flag = unpublished_flag;
		this.year = year;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Citation");
		sb.append("\n");
		if (abstract_ != null)
		{
			sb.append("abstract = ");
			sb.append(abstract_);
			sb.append('\n');
		}
		if (abstract_id_CAS != null)
		{
			sb.append("abstract_id_CAS = ");
			sb.append(abstract_id_CAS);
			sb.append('\n');
		}
		if (book_id_ISBN != null)
		{
			sb.append("book_id_ISBN = ");
			sb.append(book_id_ISBN);
			sb.append('\n');
		}
		if (book_publisher != null)
		{
			sb.append("book_publisher = ");
			sb.append(book_publisher);
			sb.append('\n');
		}
		if (book_publisher_city != null)
		{
			sb.append("book_publisher_city = ");
			sb.append(book_publisher_city);
			sb.append('\n');
		}
		if (book_title != null)
		{
			sb.append("book_title = ");
			sb.append(book_title);
			sb.append('\n');
		}
		if (coordinate_linkage != null)
		{
			sb.append("coordinate_linkage = ");
			sb.append(coordinate_linkage);
			sb.append('\n');
		}
		if (country != null)
		{
			sb.append("country = ");
			sb.append(country);
			sb.append('\n');
		}
		if (database_id_CSD != null)
		{
			sb.append("database_id_CSD = ");
			sb.append(database_id_CSD);
			sb.append('\n');
		}
		if (database_id_Medline != null)
		{
			sb.append("database_id_Medline = ");
			sb.append(database_id_Medline);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (journal_abbrev != null)
		{
			sb.append("journal_abbrev = ");
			sb.append(journal_abbrev);
			sb.append('\n');
		}
		if (journal_full != null)
		{
			sb.append("journal_full = ");
			sb.append(journal_full);
			sb.append('\n');
		}
		if (journal_id_ASTM != null)
		{
			sb.append("journal_id_ASTM = ");
			sb.append(journal_id_ASTM);
			sb.append('\n');
		}
		if (journal_id_CSD != null)
		{
			sb.append("journal_id_CSD = ");
			sb.append(journal_id_CSD);
			sb.append('\n');
		}
		if (journal_id_ISSN != null)
		{
			sb.append("journal_id_ISSN = ");
			sb.append(journal_id_ISSN);
			sb.append('\n');
		}
		if (journal_issue != null)
		{
			sb.append("journal_issue = ");
			sb.append(journal_issue);
			sb.append('\n');
		}
		if (journal_volume != null)
		{
			sb.append("journal_volume = ");
			sb.append(journal_volume);
			sb.append('\n');
		}
		if (language != null)
		{
			sb.append("language = ");
			sb.append(language);
			sb.append('\n');
		}
		if (page_first != null)
		{
			sb.append("page_first = ");
			sb.append(page_first);
			sb.append('\n');
		}
		if (page_last != null)
		{
			sb.append("page_last = ");
			sb.append(page_last);
			sb.append('\n');
		}
		if (pdbx_database_id_DOI != null)
		{
			sb.append("pdbx_database_id_DOI = ");
			sb.append(pdbx_database_id_DOI);
			sb.append('\n');
		}
		if (pdbx_database_id_PubMed != null)
		{
			sb.append("pdbx_database_id_PubMed = ");
			sb.append(pdbx_database_id_PubMed);
			sb.append('\n');
		}
		if (title != null)
		{
			sb.append("title = ");
			sb.append(title);
			sb.append('\n');
		}
		if (unpublished_flag != null)
		{
			sb.append("unpublished_flag = ");
			sb.append(unpublished_flag);
			sb.append('\n');
		}
		if (year != null)
		{
			sb.append("year = ");
			sb.append(year);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		abstract_ = null;
		abstract_id_CAS = null;
		book_id_ISBN = null;
		book_publisher = null;
		book_publisher_city = null;
		book_title = null;
		coordinate_linkage = null;
		country = null;
		database_id_CSD = null;
		database_id_Medline = null;
		details = null;
		id_ = null;
		journal_abbrev = null;
		journal_full = null;
		journal_id_ASTM = null;
		journal_id_CSD = null;
		journal_id_ISSN = null;
		journal_issue = null;
		journal_volume = null;
		language = null;
		page_first = null;
		page_last = null;
		pdbx_database_id_DOI = null;
		pdbx_database_id_PubMed = null;
		title = null;
		unpublished_flag = null;
		year = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Citation)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:citation>\n");
			if (abstract_ != null) ow.write(indent + " <PDBx:abstract>" + abstract_ + "</PDBx:abstract>\n");
			if (abstract_id_CAS != null) ow.write(indent + " <PDBx:abstract_id_CAS>" + abstract_id_CAS + "</PDBx:abstract_id_CAS>\n");
			if (book_id_ISBN != null) ow.write(indent + " <PDBx:book_id_ISBN>" + book_id_ISBN + "</PDBx:book_id_ISBN>\n");
			if (book_publisher != null) ow.write(indent + " <PDBx:book_publisher>" + book_publisher + "</PDBx:book_publisher>\n");
			if (book_publisher_city != null) ow.write(indent + " <PDBx:book_publisher_city>" + book_publisher_city + "</PDBx:book_publisher_city>\n");
			if (book_title != null) ow.write(indent + " <PDBx:book_title>" + book_title + "</PDBx:book_title>\n");
			if (coordinate_linkage != null) ow.write(indent + " <PDBx:coordinate_linkage>" + coordinate_linkage + "</PDBx:coordinate_linkage>\n");
			if (country != null) ow.write(indent + " <PDBx:country>" + country + "</PDBx:country>\n");
			if (database_id_CSD != null) ow.write(indent + " <PDBx:database_id_CSD>" + database_id_CSD + "</PDBx:database_id_CSD>\n");
			if (database_id_Medline != null) ow.write(indent + " <PDBx:database_id_Medline>" + database_id_Medline + "</PDBx:database_id_Medline>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (journal_abbrev != null) ow.write(indent + " <PDBx:journal_abbrev>" + journal_abbrev + "</PDBx:journal_abbrev>\n");
			if (journal_full != null) ow.write(indent + " <PDBx:journal_full>" + journal_full + "</PDBx:journal_full>\n");
			if (journal_id_ASTM != null) ow.write(indent + " <PDBx:journal_id_ASTM>" + journal_id_ASTM + "</PDBx:journal_id_ASTM>\n");
			if (journal_id_CSD != null) ow.write(indent + " <PDBx:journal_id_CSD>" + journal_id_CSD + "</PDBx:journal_id_CSD>\n");
			if (journal_id_ISSN != null) ow.write(indent + " <PDBx:journal_id_ISSN>" + journal_id_ISSN + "</PDBx:journal_id_ISSN>\n");
			if (journal_issue != null) ow.write(indent + " <PDBx:journal_issue>" + journal_issue + "</PDBx:journal_issue>\n");
			if (journal_volume != null) ow.write(indent + " <PDBx:journal_volume>" + journal_volume + "</PDBx:journal_volume>\n");
			if (language != null) ow.write(indent + " <PDBx:language>" + language + "</PDBx:language>\n");
			if (page_first != null) ow.write(indent + " <PDBx:page_first>" + page_first + "</PDBx:page_first>\n");
			if (page_last != null) ow.write(indent + " <PDBx:page_last>" + page_last + "</PDBx:page_last>\n");
			if (pdbx_database_id_DOI != null) ow.write(indent + " <PDBx:pdbx_database_id_DOI>" + pdbx_database_id_DOI + "</PDBx:pdbx_database_id_DOI>\n");
			if (pdbx_database_id_PubMed != null) ow.write(indent + " <PDBx:pdbx_database_id_PubMed>" + pdbx_database_id_PubMed + "</PDBx:pdbx_database_id_PubMed>\n");
			if (title != null) ow.write(indent + " <PDBx:title>" + title + "</PDBx:title>\n");
			if (unpublished_flag != null) ow.write(indent + " <PDBx:unpublished_flag>" + unpublished_flag + "</PDBx:unpublished_flag>\n");
			if (year != null) ow.write(indent + " <PDBx:year>" + year + "</PDBx:year>\n");
			ow.write(indent + "</PDBx:citation>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
