package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DATABASE category have been superseded by
 *  data items in the DATABASE_2 category. They are included
 *  here only for compliance with older CIFs.
 */
public class Database extends org.pdb.beans.Database implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "database";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Database()
	{
	}

	/** Full constructor */
	public Database(
		Datablock datablock,
		java.lang.String CSD_history,
		java.lang.String code_CAS,
		java.lang.String code_CSD,
		java.lang.String code_ICSD,
		java.lang.String code_MDF,
		java.lang.String code_NBS,
		java.lang.String code_PDB,
		java.lang.String code_PDF,
		java.lang.String code_depnum_ccdc_archive,
		java.lang.String code_depnum_ccdc_fiz,
		java.lang.String code_depnum_ccdc_journal,
		java.lang.String entry_id,
		java.lang.String journal_ASTM,
		java.lang.String journal_CSD)
	{
		this.datablock = datablock;
		this.CSD_history = CSD_history;
		this.code_CAS = code_CAS;
		this.code_CSD = code_CSD;
		this.code_ICSD = code_ICSD;
		this.code_MDF = code_MDF;
		this.code_NBS = code_NBS;
		this.code_PDB = code_PDB;
		this.code_PDF = code_PDF;
		this.code_depnum_ccdc_archive = code_depnum_ccdc_archive;
		this.code_depnum_ccdc_fiz = code_depnum_ccdc_fiz;
		this.code_depnum_ccdc_journal = code_depnum_ccdc_journal;
		this.entry_id = entry_id;
		this.journal_ASTM = journal_ASTM;
		this.journal_CSD = journal_CSD;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Database");
		sb.append("\n");
		if (CSD_history != null)
		{
			sb.append("CSD_history = ");
			sb.append(CSD_history);
			sb.append('\n');
		}
		if (code_CAS != null)
		{
			sb.append("code_CAS = ");
			sb.append(code_CAS);
			sb.append('\n');
		}
		if (code_CSD != null)
		{
			sb.append("code_CSD = ");
			sb.append(code_CSD);
			sb.append('\n');
		}
		if (code_ICSD != null)
		{
			sb.append("code_ICSD = ");
			sb.append(code_ICSD);
			sb.append('\n');
		}
		if (code_MDF != null)
		{
			sb.append("code_MDF = ");
			sb.append(code_MDF);
			sb.append('\n');
		}
		if (code_NBS != null)
		{
			sb.append("code_NBS = ");
			sb.append(code_NBS);
			sb.append('\n');
		}
		if (code_PDB != null)
		{
			sb.append("code_PDB = ");
			sb.append(code_PDB);
			sb.append('\n');
		}
		if (code_PDF != null)
		{
			sb.append("code_PDF = ");
			sb.append(code_PDF);
			sb.append('\n');
		}
		if (code_depnum_ccdc_archive != null)
		{
			sb.append("code_depnum_ccdc_archive = ");
			sb.append(code_depnum_ccdc_archive);
			sb.append('\n');
		}
		if (code_depnum_ccdc_fiz != null)
		{
			sb.append("code_depnum_ccdc_fiz = ");
			sb.append(code_depnum_ccdc_fiz);
			sb.append('\n');
		}
		if (code_depnum_ccdc_journal != null)
		{
			sb.append("code_depnum_ccdc_journal = ");
			sb.append(code_depnum_ccdc_journal);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (journal_ASTM != null)
		{
			sb.append("journal_ASTM = ");
			sb.append(journal_ASTM);
			sb.append('\n');
		}
		if (journal_CSD != null)
		{
			sb.append("journal_CSD = ");
			sb.append(journal_CSD);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		CSD_history = null;
		code_CAS = null;
		code_CSD = null;
		code_ICSD = null;
		code_MDF = null;
		code_NBS = null;
		code_PDB = null;
		code_PDF = null;
		code_depnum_ccdc_archive = null;
		code_depnum_ccdc_fiz = null;
		code_depnum_ccdc_journal = null;
		entry_id = null;
		journal_ASTM = null;
		journal_CSD = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Database)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:database>\n");
			if (CSD_history != null) ow.write(indent + " <PDBx:CSD_history>" + CSD_history + "</PDBx:CSD_history>\n");
			if (code_CAS != null) ow.write(indent + " <PDBx:code_CAS>" + code_CAS + "</PDBx:code_CAS>\n");
			if (code_CSD != null) ow.write(indent + " <PDBx:code_CSD>" + code_CSD + "</PDBx:code_CSD>\n");
			if (code_ICSD != null) ow.write(indent + " <PDBx:code_ICSD>" + code_ICSD + "</PDBx:code_ICSD>\n");
			if (code_MDF != null) ow.write(indent + " <PDBx:code_MDF>" + code_MDF + "</PDBx:code_MDF>\n");
			if (code_NBS != null) ow.write(indent + " <PDBx:code_NBS>" + code_NBS + "</PDBx:code_NBS>\n");
			if (code_PDB != null) ow.write(indent + " <PDBx:code_PDB>" + code_PDB + "</PDBx:code_PDB>\n");
			if (code_PDF != null) ow.write(indent + " <PDBx:code_PDF>" + code_PDF + "</PDBx:code_PDF>\n");
			if (code_depnum_ccdc_archive != null) ow.write(indent + " <PDBx:code_depnum_ccdc_archive>" + code_depnum_ccdc_archive + "</PDBx:code_depnum_ccdc_archive>\n");
			if (code_depnum_ccdc_fiz != null) ow.write(indent + " <PDBx:code_depnum_ccdc_fiz>" + code_depnum_ccdc_fiz + "</PDBx:code_depnum_ccdc_fiz>\n");
			if (code_depnum_ccdc_journal != null) ow.write(indent + " <PDBx:code_depnum_ccdc_journal>" + code_depnum_ccdc_journal + "</PDBx:code_depnum_ccdc_journal>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (journal_ASTM != null) ow.write(indent + " <PDBx:journal_ASTM>" + journal_ASTM + "</PDBx:journal_ASTM>\n");
			if (journal_CSD != null) ow.write(indent + " <PDBx:journal_CSD>" + journal_CSD + "</PDBx:journal_CSD>\n");
			ow.write(indent + "</PDBx:database>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
