package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DATABASE_2 category record details about the
 *  database identifiers of the data block.
 *  
 *  These data items are assigned by database managers and should
 *  only appear in a data block if they originate from that source.
 *  
 *  The name of this category, DATABASE_2, arose because the
 *  category name DATABASE was already in use in the core CIF
 *  dictionary, but was used differently from the way it needed
 *  to be used in the mmCIF dictionary. Since CIF data names
 *  cannot be changed once they have been adopted, a new category
 *  had to be created.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:database_2Category>
 *  <PDBx:database_2 database_id="PDB" database_code="5HVP"></PDBx:database_2>
 *  </PDBx:database_2Category>
 * </pre>
 */
public class Database_2 extends org.pdb.beans.Database_2 implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "database_2";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Database_2()
	{
	}

	/** Full constructor */
	public Database_2(
		Datablock datablock,
		java.lang.String database_code,
		java.lang.String database_id)
	{
		this.datablock = datablock;
		this.database_code = database_code;
		this.database_id = database_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Database_2");
		sb.append("\n");
		if (database_code != null)
		{
			sb.append("database_code = ");
			sb.append(database_code);
			sb.append('\n');
		}
		if (database_id != null)
		{
			sb.append("database_id = ");
			sb.append(database_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		database_code = null;
		database_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Database_2)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:database_2>\n");
			if (database_code != null) ow.write(indent + " <PDBx:database_code>" + database_code + "</PDBx:database_code>\n");
			if (database_id != null) ow.write(indent + " <PDBx:database_id>" + database_id + "</PDBx:database_id>\n");
			ow.write(indent + "</PDBx:database_2>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
