package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DATABASE_PDB_CAVEAT category record details
 *  about features of the data block flagged as 'caveats' by the
 *  Protein Data Bank (PDB).
 *  
 *  These data items are included only for consistency with PDB
 *  format files. They should appear in a data block only if that
 *  data block was created by reformatting a PDB format file.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:database_PDB_caveatCategory>
 *  <PDBx:database_PDB_caveat id="1">
 *  <PDBx:text> THE CRYSTAL TRANSFORMATION IS IN ERROR BUT IS</PDBx:text>
 *  </PDBx:database_PDB_caveat>
 *  <PDBx:database_PDB_caveat id="2">
 *  <PDBx:text> UNCORRECTABLE AT THIS TIME</PDBx:text>
 *  </PDBx:database_PDB_caveat>
 *  </PDBx:database_PDB_caveatCategory>
 * </pre>
 */
public class Database_PDB_caveat extends org.pdb.beans.Database_PDB_caveat implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "database_PDB_caveat";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Database_PDB_caveat()
	{
	}

	/** Full constructor */
	public Database_PDB_caveat(
		Datablock datablock,
		java.lang.Integer id_,
		java.lang.String text)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.text = text;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Database_PDB_caveat");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (text != null)
		{
			sb.append("text = ");
			sb.append(text);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		text = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Database_PDB_caveat)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:database_PDB_caveat>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (text != null) ow.write(indent + " <PDBx:text>" + text + "</PDBx:text>\n");
			ow.write(indent + "</PDBx:database_PDB_caveat>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
