package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The DATABASE_PDB_MATRIX category provides placeholders for
 *  transformation matrices and vectors used by the Protein Data
 *  Bank (PDB).
 *  
 *  These data items are included only for consistency with older
 *  PDB format files. They should appear in a data block only if
 *  that data block was created by reformatting a PDB format file.
 */
public class Database_PDB_matrix extends org.pdb.beans.Database_PDB_matrix implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "database_PDB_matrix";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Database_PDB_matrix()
	{
	}

	/** Full constructor */
	public Database_PDB_matrix(
		Datablock datablock,
		java.lang.String entry_id,
		java.lang.Float origx11,
		java.lang.Float origx12,
		java.lang.Float origx13,
		java.lang.Float origx21,
		java.lang.Float origx22,
		java.lang.Float origx23,
		java.lang.Float origx31,
		java.lang.Float origx32,
		java.lang.Float origx33,
		java.lang.Float origx_vector1,
		java.lang.Float origx_vector2,
		java.lang.Float origx_vector3,
		java.lang.Float scale11,
		java.lang.Float scale12,
		java.lang.Float scale13,
		java.lang.Float scale21,
		java.lang.Float scale22,
		java.lang.Float scale23,
		java.lang.Float scale31,
		java.lang.Float scale32,
		java.lang.Float scale33,
		java.lang.Float scale_vector1,
		java.lang.Float scale_vector2,
		java.lang.Float scale_vector3)
	{
		this.datablock = datablock;
		this.entry_id = entry_id;
		this.origx11 = origx11;
		this.origx12 = origx12;
		this.origx13 = origx13;
		this.origx21 = origx21;
		this.origx22 = origx22;
		this.origx23 = origx23;
		this.origx31 = origx31;
		this.origx32 = origx32;
		this.origx33 = origx33;
		this.origx_vector1 = origx_vector1;
		this.origx_vector2 = origx_vector2;
		this.origx_vector3 = origx_vector3;
		this.scale11 = scale11;
		this.scale12 = scale12;
		this.scale13 = scale13;
		this.scale21 = scale21;
		this.scale22 = scale22;
		this.scale23 = scale23;
		this.scale31 = scale31;
		this.scale32 = scale32;
		this.scale33 = scale33;
		this.scale_vector1 = scale_vector1;
		this.scale_vector2 = scale_vector2;
		this.scale_vector3 = scale_vector3;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Database_PDB_matrix");
		sb.append("\n");
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (origx11 != null)
		{
			sb.append("origx11 = ");
			sb.append(origx11);
			sb.append('\n');
		}
		if (origx12 != null)
		{
			sb.append("origx12 = ");
			sb.append(origx12);
			sb.append('\n');
		}
		if (origx13 != null)
		{
			sb.append("origx13 = ");
			sb.append(origx13);
			sb.append('\n');
		}
		if (origx21 != null)
		{
			sb.append("origx21 = ");
			sb.append(origx21);
			sb.append('\n');
		}
		if (origx22 != null)
		{
			sb.append("origx22 = ");
			sb.append(origx22);
			sb.append('\n');
		}
		if (origx23 != null)
		{
			sb.append("origx23 = ");
			sb.append(origx23);
			sb.append('\n');
		}
		if (origx31 != null)
		{
			sb.append("origx31 = ");
			sb.append(origx31);
			sb.append('\n');
		}
		if (origx32 != null)
		{
			sb.append("origx32 = ");
			sb.append(origx32);
			sb.append('\n');
		}
		if (origx33 != null)
		{
			sb.append("origx33 = ");
			sb.append(origx33);
			sb.append('\n');
		}
		if (origx_vector1 != null)
		{
			sb.append("origx_vector1 = ");
			sb.append(origx_vector1);
			sb.append('\n');
		}
		if (origx_vector2 != null)
		{
			sb.append("origx_vector2 = ");
			sb.append(origx_vector2);
			sb.append('\n');
		}
		if (origx_vector3 != null)
		{
			sb.append("origx_vector3 = ");
			sb.append(origx_vector3);
			sb.append('\n');
		}
		if (scale11 != null)
		{
			sb.append("scale11 = ");
			sb.append(scale11);
			sb.append('\n');
		}
		if (scale12 != null)
		{
			sb.append("scale12 = ");
			sb.append(scale12);
			sb.append('\n');
		}
		if (scale13 != null)
		{
			sb.append("scale13 = ");
			sb.append(scale13);
			sb.append('\n');
		}
		if (scale21 != null)
		{
			sb.append("scale21 = ");
			sb.append(scale21);
			sb.append('\n');
		}
		if (scale22 != null)
		{
			sb.append("scale22 = ");
			sb.append(scale22);
			sb.append('\n');
		}
		if (scale23 != null)
		{
			sb.append("scale23 = ");
			sb.append(scale23);
			sb.append('\n');
		}
		if (scale31 != null)
		{
			sb.append("scale31 = ");
			sb.append(scale31);
			sb.append('\n');
		}
		if (scale32 != null)
		{
			sb.append("scale32 = ");
			sb.append(scale32);
			sb.append('\n');
		}
		if (scale33 != null)
		{
			sb.append("scale33 = ");
			sb.append(scale33);
			sb.append('\n');
		}
		if (scale_vector1 != null)
		{
			sb.append("scale_vector1 = ");
			sb.append(scale_vector1);
			sb.append('\n');
		}
		if (scale_vector2 != null)
		{
			sb.append("scale_vector2 = ");
			sb.append(scale_vector2);
			sb.append('\n');
		}
		if (scale_vector3 != null)
		{
			sb.append("scale_vector3 = ");
			sb.append(scale_vector3);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entry_id = null;
		origx11 = null;
		origx12 = null;
		origx13 = null;
		origx21 = null;
		origx22 = null;
		origx23 = null;
		origx31 = null;
		origx32 = null;
		origx33 = null;
		origx_vector1 = null;
		origx_vector2 = null;
		origx_vector3 = null;
		scale11 = null;
		scale12 = null;
		scale13 = null;
		scale21 = null;
		scale22 = null;
		scale23 = null;
		scale31 = null;
		scale32 = null;
		scale33 = null;
		scale_vector1 = null;
		scale_vector2 = null;
		scale_vector3 = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Database_PDB_matrix)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:database_PDB_matrix>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (origx11 != null) ow.write(indent + " <PDBx:origx11>" + origx11 + "</PDBx:origx11>\n");
			if (origx12 != null) ow.write(indent + " <PDBx:origx12>" + origx12 + "</PDBx:origx12>\n");
			if (origx13 != null) ow.write(indent + " <PDBx:origx13>" + origx13 + "</PDBx:origx13>\n");
			if (origx21 != null) ow.write(indent + " <PDBx:origx21>" + origx21 + "</PDBx:origx21>\n");
			if (origx22 != null) ow.write(indent + " <PDBx:origx22>" + origx22 + "</PDBx:origx22>\n");
			if (origx23 != null) ow.write(indent + " <PDBx:origx23>" + origx23 + "</PDBx:origx23>\n");
			if (origx31 != null) ow.write(indent + " <PDBx:origx31>" + origx31 + "</PDBx:origx31>\n");
			if (origx32 != null) ow.write(indent + " <PDBx:origx32>" + origx32 + "</PDBx:origx32>\n");
			if (origx33 != null) ow.write(indent + " <PDBx:origx33>" + origx33 + "</PDBx:origx33>\n");
			if (origx_vector1 != null) ow.write(indent + " <PDBx:origx_vector1>" + origx_vector1 + "</PDBx:origx_vector1>\n");
			if (origx_vector2 != null) ow.write(indent + " <PDBx:origx_vector2>" + origx_vector2 + "</PDBx:origx_vector2>\n");
			if (origx_vector3 != null) ow.write(indent + " <PDBx:origx_vector3>" + origx_vector3 + "</PDBx:origx_vector3>\n");
			if (scale11 != null) ow.write(indent + " <PDBx:scale11>" + scale11 + "</PDBx:scale11>\n");
			if (scale12 != null) ow.write(indent + " <PDBx:scale12>" + scale12 + "</PDBx:scale12>\n");
			if (scale13 != null) ow.write(indent + " <PDBx:scale13>" + scale13 + "</PDBx:scale13>\n");
			if (scale21 != null) ow.write(indent + " <PDBx:scale21>" + scale21 + "</PDBx:scale21>\n");
			if (scale22 != null) ow.write(indent + " <PDBx:scale22>" + scale22 + "</PDBx:scale22>\n");
			if (scale23 != null) ow.write(indent + " <PDBx:scale23>" + scale23 + "</PDBx:scale23>\n");
			if (scale31 != null) ow.write(indent + " <PDBx:scale31>" + scale31 + "</PDBx:scale31>\n");
			if (scale32 != null) ow.write(indent + " <PDBx:scale32>" + scale32 + "</PDBx:scale32>\n");
			if (scale33 != null) ow.write(indent + " <PDBx:scale33>" + scale33 + "</PDBx:scale33>\n");
			if (scale_vector1 != null) ow.write(indent + " <PDBx:scale_vector1>" + scale_vector1 + "</PDBx:scale_vector1>\n");
			if (scale_vector2 != null) ow.write(indent + " <PDBx:scale_vector2>" + scale_vector2 + "</PDBx:scale_vector2>\n");
			if (scale_vector3 != null) ow.write(indent + " <PDBx:scale_vector3>" + scale_vector3 + "</PDBx:scale_vector3>\n");
			ow.write(indent + "</PDBx:database_PDB_matrix>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
