package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DATABASE_PDB_REV_RECORD category record
 *  details about specific record types that were changed in a
 *  given revision of a PDB entry.
 *  
 *  These data items are assigned by the PDB database managers and
 *  should only appear in a data block if they originate from that
 *  source.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:database_PDB_rev_recordCategory>
 *  <PDBx:database_PDB_rev_record rev_num="1" type="CONECT">
 *  <PDBx:details> Error fix - incorrect connection between
 *  atoms 2312 and 2317</PDBx:details>
 *  </PDBx:database_PDB_rev_record>
 *  <PDBx:database_PDB_rev_record rev_num="2" type="MATRIX">
 *  <PDBx:details>For consistency with 1995-08-04 style-guide</PDBx:details>
 *  </PDBx:database_PDB_rev_record>
 *  <PDBx:database_PDB_rev_record rev_num="3" type="ORIGX">
 *  <PDBx:details>Based on new data from author</PDBx:details>
 *  </PDBx:database_PDB_rev_record>
 *  </PDBx:database_PDB_rev_recordCategory>
 * </pre>
 */
public class Database_PDB_rev_record extends org.pdb.beans.Database_PDB_rev_record implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "database_PDB_rev_record";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Database_PDB_rev_record()
	{
	}

	/** Full constructor */
	public Database_PDB_rev_record(
		Datablock datablock,
		java.lang.String details,
		java.lang.Integer rev_num,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.details = details;
		this.rev_num = rev_num;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Database_PDB_rev_record");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (rev_num != null)
		{
			sb.append("rev_num = ");
			sb.append(rev_num);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		rev_num = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Database_PDB_rev_record)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:database_PDB_rev_record>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (rev_num != null) ow.write(indent + " <PDBx:rev_num>" + rev_num + "</PDBx:rev_num>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:database_PDB_rev_record>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
