package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The DATABASE_PDB_TVECT category provides placeholders for
 *  the TVECT matrices and vectors used by the Protein Data
 *  Bank (PDB).
 *  
 *  These data items are included only for consistency with older
 *  PDB format files. They should appear in a data block only if
 *  the data block was created by reformatting a PDB format file.
 */
public class Database_PDB_tvect extends org.pdb.beans.Database_PDB_tvect implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "database_PDB_tvect";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Database_PDB_tvect()
	{
	}

	/** Full constructor */
	public Database_PDB_tvect(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_,
		java.lang.Float vector1,
		java.lang.Float vector2,
		java.lang.Float vector3)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
		this.vector1 = vector1;
		this.vector2 = vector2;
		this.vector3 = vector3;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Database_PDB_tvect");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (vector1 != null)
		{
			sb.append("vector1 = ");
			sb.append(vector1);
			sb.append('\n');
		}
		if (vector2 != null)
		{
			sb.append("vector2 = ");
			sb.append(vector2);
			sb.append('\n');
		}
		if (vector3 != null)
		{
			sb.append("vector3 = ");
			sb.append(vector3);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		vector1 = null;
		vector2 = null;
		vector3 = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Database_PDB_tvect)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:database_PDB_tvect>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (vector1 != null) ow.write(indent + " <PDBx:vector1>" + vector1 + "</PDBx:vector1>\n");
			if (vector2 != null) ow.write(indent + " <PDBx:vector2>" + vector2 + "</PDBx:vector2>\n");
			if (vector3 != null) ow.write(indent + " <PDBx:vector3>" + vector3 + "</PDBx:vector3>\n");
			ow.write(indent + "</PDBx:database_PDB_tvect>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
