package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_ATTENUATOR category record details
 *  about the diffraction attenuator scales employed.
 *  
 * <pre>
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_attenuatorCategory>
 *  <PDBx:diffrn_attenuator code="1">
 *  <PDBx:scale>16.976</PDBx:scale>
 *  </PDBx:diffrn_attenuator>
 *  </PDBx:diffrn_attenuatorCategory>
 * </pre>
 */
public class Diffrn_attenuator extends org.pdb.beans.Diffrn_attenuator implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_attenuator";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_attenuator()
	{
	}

	/** Full constructor */
	public Diffrn_attenuator(
		Datablock datablock,
		java.lang.String code,
		java.lang.String material,
		java.lang.Float scale)
	{
		this.datablock = datablock;
		this.code = code;
		this.material = material;
		this.scale = scale;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_attenuator");
		sb.append("\n");
		if (code != null)
		{
			sb.append("code = ");
			sb.append(code);
			sb.append('\n');
		}
		if (material != null)
		{
			sb.append("material = ");
			sb.append(material);
			sb.append('\n');
		}
		if (scale != null)
		{
			sb.append("scale = ");
			sb.append(scale);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		code = null;
		material = null;
		scale = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_attenuator)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_attenuator>\n");
			if (code != null) ow.write(indent + " <PDBx:code>" + code + "</PDBx:code>\n");
			if (material != null) ow.write(indent + " <PDBx:material>" + material + "</PDBx:material>\n");
			if (scale != null) ow.write(indent + " <PDBx:scale>" + scale + "</PDBx:scale>\n");
			ow.write(indent + "</PDBx:diffrn_attenuator>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
