package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_MEASUREMENT category record details
 *  about the device used to orient and/or position the crystal
 *  during data measurement and the manner in which the diffraction
 *  data were measured.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_measurementCategory>
 *  <PDBx:diffrn_measurement diffrn_id="d1">
 *  <PDBx:device>3-circle camera</PDBx:device>
 *  <PDBx:device_type>Supper model x</PDBx:device_type>
 *  <PDBx:device_details>none</PDBx:device_details>
 *  <PDBx:method>omega scan</PDBx:method>
 *  <PDBx:details> 440 frames, 0.20 degrees, 150 sec, detector distance 12 cm,
 *  detector angle 22.5 degrees</PDBx:details>
 *  </PDBx:diffrn_measurement>
 *  </PDBx:diffrn_measurementCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_measurementCategory>
 *  <PDBx:diffrn_measurement diffrn_id="s1">
 *  <PDBx:device_type>Philips PW1100/20 diffractometer</PDBx:device_type>
 *  <PDBx:method>\q/2\q</PDBx:method>
 *  </PDBx:diffrn_measurement>
 *  </PDBx:diffrn_measurementCategory>
 * </pre>
 */
public class Diffrn_measurement extends org.pdb.beans.Diffrn_measurement implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_measurement";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_measurement()
	{
	}

	/** Full constructor */
	public Diffrn_measurement(
		Datablock datablock,
		java.lang.String details,
		java.lang.String device,
		java.lang.String device_details,
		java.lang.String device_type,
		java.lang.String diffrn_id,
		java.lang.String method,
		java.lang.String specimen_support)
	{
		this.datablock = datablock;
		this.details = details;
		this.device = device;
		this.device_details = device_details;
		this.device_type = device_type;
		this.diffrn_id = diffrn_id;
		this.method = method;
		this.specimen_support = specimen_support;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_measurement");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (device != null)
		{
			sb.append("device = ");
			sb.append(device);
			sb.append('\n');
		}
		if (device_details != null)
		{
			sb.append("device_details = ");
			sb.append(device_details);
			sb.append('\n');
		}
		if (device_type != null)
		{
			sb.append("device_type = ");
			sb.append(device_type);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (specimen_support != null)
		{
			sb.append("specimen_support = ");
			sb.append(specimen_support);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		device = null;
		device_details = null;
		device_type = null;
		diffrn_id = null;
		method = null;
		specimen_support = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_measurement)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_measurement>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (device != null) ow.write(indent + " <PDBx:device>" + device + "</PDBx:device>\n");
			if (device_details != null) ow.write(indent + " <PDBx:device_details>" + device_details + "</PDBx:device_details>\n");
			if (device_type != null) ow.write(indent + " <PDBx:device_type>" + device_type + "</PDBx:device_type>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (specimen_support != null) ow.write(indent + " <PDBx:specimen_support>" + specimen_support + "</PDBx:specimen_support>\n");
			ow.write(indent + "</PDBx:diffrn_measurement>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
