package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_REFLN category record details about
 *  the intensities in the diffraction data set
 *  identified by  attribute diffrn_id.
 *  in category diffrn_refln
 *  The DIFFRN_REFLN data items refer to individual intensity
 *  measurements and must be included in looped lists.
 *  
 *  The DIFFRN_REFLNS data items specify the parameters that apply
 *  to all intensity  measurements in the particular diffraction
 *  data set identified by  attribute diffrn_id in category diffrn_reflns.
 *  
 * <pre>
 *  Example 1 - based on CAD-4 diffractometer data obtained for
 *  Yb(S-C5H4N)2(THF)4  for data set 'set1' reflection 1102.
 *  <PDBx:diffrn_reflnCategory>
 *  <PDBx:diffrn_refln diffrn_id="set1" id="1102">
 *  <PDBx:wavelength_id>Cu1fixed</PDBx:wavelength_id>
 *  <PDBx:angle_chi>32.21</PDBx:angle_chi>
 *  <PDBx:angle_kappa>20.12</PDBx:angle_kappa>
 *  <PDBx:angle_omega>11.54</PDBx:angle_omega>
 *  <PDBx:angle_phi>176.02</PDBx:angle_phi>
 *  <PDBx:angle_psi>0.00</PDBx:angle_psi>
 *  <PDBx:angle_theta>23.08</PDBx:angle_theta>
 *  <PDBx:attenuator_code>Ni.005</PDBx:attenuator_code>
 *  <PDBx:counts_bg_1>22</PDBx:counts_bg_1>
 *  <PDBx:counts_bg_2>25</PDBx:counts_bg_2>
 *  <PDBx:counts_net>3450</PDBx:counts_net>
 *  <PDBx:counts_peak>321</PDBx:counts_peak>
 *  <PDBx:counts_total>3499</PDBx:counts_total>
 *  <PDBx:detect_slit_horiz>0.04</PDBx:detect_slit_horiz>
 *  <PDBx:detect_slit_vert>0.02</PDBx:detect_slit_vert>
 *  <PDBx:elapsed_time>1.00</PDBx:elapsed_time>
 *  <PDBx:index_h>4</PDBx:index_h>
 *  <PDBx:index_k>0</PDBx:index_k>
 *  <PDBx:index_l>2</PDBx:index_l>
 *  <PDBx:intensity_net>202.56</PDBx:intensity_net>
 *  <PDBx:intensity_sigma>2.18</PDBx:intensity_sigma>
 *  <PDBx:scale_group_code>A24</PDBx:scale_group_code>
 *  <PDBx:scan_mode>om</PDBx:scan_mode>
 *  <PDBx:scan_mode_backgd>mo</PDBx:scan_mode_backgd>
 *  <PDBx:scan_rate>1.2</PDBx:scan_rate>
 *  <PDBx:scan_time_backgd>900.00</PDBx:scan_time_backgd>
 *  <PDBx:scan_width>1.0</PDBx:scan_width>
 *  <PDBx:sint_over_lambda>0.25426</PDBx:sint_over_lambda>
 *  <PDBx:standard_code>1</PDBx:standard_code>
 *  <PDBx:wavelength>1.54184</PDBx:wavelength>
 *  </PDBx:diffrn_refln>
 *  </PDBx:diffrn_reflnCategory>
 * </pre>
 */
public class Diffrn_refln extends org.pdb.beans.Diffrn_refln implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_refln";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_refln()
	{
	}

	/** Full constructor */
	public Diffrn_refln(
		Datablock datablock,
		java.lang.Float angle_chi,
		java.lang.Float angle_kappa,
		java.lang.Float angle_omega,
		java.lang.Float angle_phi,
		java.lang.Float angle_psi,
		java.lang.Float angle_theta,
		java.lang.String attenuator_code,
		java.lang.String class_code,
		java.lang.Integer counts_bg_1,
		java.lang.Integer counts_bg_2,
		java.lang.Integer counts_net,
		java.lang.Integer counts_peak,
		java.lang.Integer counts_total,
		java.lang.Float detect_slit_horiz,
		java.lang.Float detect_slit_vert,
		java.lang.String diffrn_id,
		java.lang.Float elapsed_time,
		java.lang.String id_,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l,
		java.lang.Float intensity_net,
		java.lang.Float intensity_sigma,
		java.lang.Float intensity_u,
		java.lang.String scale_group_code,
		java.lang.String scan_mode,
		java.lang.String scan_mode_backgd,
		java.lang.Float scan_rate,
		java.lang.Float scan_time_backgd,
		java.lang.Float scan_width,
		java.lang.Float sint_over_lambda,
		java.lang.String standard_code,
		java.lang.Float wavelength,
		java.lang.String wavelength_id)
	{
		this.datablock = datablock;
		this.angle_chi = angle_chi;
		this.angle_kappa = angle_kappa;
		this.angle_omega = angle_omega;
		this.angle_phi = angle_phi;
		this.angle_psi = angle_psi;
		this.angle_theta = angle_theta;
		this.attenuator_code = attenuator_code;
		this.class_code = class_code;
		this.counts_bg_1 = counts_bg_1;
		this.counts_bg_2 = counts_bg_2;
		this.counts_net = counts_net;
		this.counts_peak = counts_peak;
		this.counts_total = counts_total;
		this.detect_slit_horiz = detect_slit_horiz;
		this.detect_slit_vert = detect_slit_vert;
		this.diffrn_id = diffrn_id;
		this.elapsed_time = elapsed_time;
		this.id_ = id_;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
		this.intensity_net = intensity_net;
		this.intensity_sigma = intensity_sigma;
		this.intensity_u = intensity_u;
		this.scale_group_code = scale_group_code;
		this.scan_mode = scan_mode;
		this.scan_mode_backgd = scan_mode_backgd;
		this.scan_rate = scan_rate;
		this.scan_time_backgd = scan_time_backgd;
		this.scan_width = scan_width;
		this.sint_over_lambda = sint_over_lambda;
		this.standard_code = standard_code;
		this.wavelength = wavelength;
		this.wavelength_id = wavelength_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_refln");
		sb.append("\n");
		if (angle_chi != null)
		{
			sb.append("angle_chi = ");
			sb.append(angle_chi);
			sb.append('\n');
		}
		if (angle_kappa != null)
		{
			sb.append("angle_kappa = ");
			sb.append(angle_kappa);
			sb.append('\n');
		}
		if (angle_omega != null)
		{
			sb.append("angle_omega = ");
			sb.append(angle_omega);
			sb.append('\n');
		}
		if (angle_phi != null)
		{
			sb.append("angle_phi = ");
			sb.append(angle_phi);
			sb.append('\n');
		}
		if (angle_psi != null)
		{
			sb.append("angle_psi = ");
			sb.append(angle_psi);
			sb.append('\n');
		}
		if (angle_theta != null)
		{
			sb.append("angle_theta = ");
			sb.append(angle_theta);
			sb.append('\n');
		}
		if (attenuator_code != null)
		{
			sb.append("attenuator_code = ");
			sb.append(attenuator_code);
			sb.append('\n');
		}
		if (class_code != null)
		{
			sb.append("class_code = ");
			sb.append(class_code);
			sb.append('\n');
		}
		if (counts_bg_1 != null)
		{
			sb.append("counts_bg_1 = ");
			sb.append(counts_bg_1);
			sb.append('\n');
		}
		if (counts_bg_2 != null)
		{
			sb.append("counts_bg_2 = ");
			sb.append(counts_bg_2);
			sb.append('\n');
		}
		if (counts_net != null)
		{
			sb.append("counts_net = ");
			sb.append(counts_net);
			sb.append('\n');
		}
		if (counts_peak != null)
		{
			sb.append("counts_peak = ");
			sb.append(counts_peak);
			sb.append('\n');
		}
		if (counts_total != null)
		{
			sb.append("counts_total = ");
			sb.append(counts_total);
			sb.append('\n');
		}
		if (detect_slit_horiz != null)
		{
			sb.append("detect_slit_horiz = ");
			sb.append(detect_slit_horiz);
			sb.append('\n');
		}
		if (detect_slit_vert != null)
		{
			sb.append("detect_slit_vert = ");
			sb.append(detect_slit_vert);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (elapsed_time != null)
		{
			sb.append("elapsed_time = ");
			sb.append(elapsed_time);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		if (intensity_net != null)
		{
			sb.append("intensity_net = ");
			sb.append(intensity_net);
			sb.append('\n');
		}
		if (intensity_sigma != null)
		{
			sb.append("intensity_sigma = ");
			sb.append(intensity_sigma);
			sb.append('\n');
		}
		if (intensity_u != null)
		{
			sb.append("intensity_u = ");
			sb.append(intensity_u);
			sb.append('\n');
		}
		if (scale_group_code != null)
		{
			sb.append("scale_group_code = ");
			sb.append(scale_group_code);
			sb.append('\n');
		}
		if (scan_mode != null)
		{
			sb.append("scan_mode = ");
			sb.append(scan_mode);
			sb.append('\n');
		}
		if (scan_mode_backgd != null)
		{
			sb.append("scan_mode_backgd = ");
			sb.append(scan_mode_backgd);
			sb.append('\n');
		}
		if (scan_rate != null)
		{
			sb.append("scan_rate = ");
			sb.append(scan_rate);
			sb.append('\n');
		}
		if (scan_time_backgd != null)
		{
			sb.append("scan_time_backgd = ");
			sb.append(scan_time_backgd);
			sb.append('\n');
		}
		if (scan_width != null)
		{
			sb.append("scan_width = ");
			sb.append(scan_width);
			sb.append('\n');
		}
		if (sint_over_lambda != null)
		{
			sb.append("sint_over_lambda = ");
			sb.append(sint_over_lambda);
			sb.append('\n');
		}
		if (standard_code != null)
		{
			sb.append("standard_code = ");
			sb.append(standard_code);
			sb.append('\n');
		}
		if (wavelength != null)
		{
			sb.append("wavelength = ");
			sb.append(wavelength);
			sb.append('\n');
		}
		if (wavelength_id != null)
		{
			sb.append("wavelength_id = ");
			sb.append(wavelength_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		angle_chi = null;
		angle_kappa = null;
		angle_omega = null;
		angle_phi = null;
		angle_psi = null;
		angle_theta = null;
		attenuator_code = null;
		class_code = null;
		counts_bg_1 = null;
		counts_bg_2 = null;
		counts_net = null;
		counts_peak = null;
		counts_total = null;
		detect_slit_horiz = null;
		detect_slit_vert = null;
		diffrn_id = null;
		elapsed_time = null;
		id_ = null;
		index_h = null;
		index_k = null;
		index_l = null;
		intensity_net = null;
		intensity_sigma = null;
		intensity_u = null;
		scale_group_code = null;
		scan_mode = null;
		scan_mode_backgd = null;
		scan_rate = null;
		scan_time_backgd = null;
		scan_width = null;
		sint_over_lambda = null;
		standard_code = null;
		wavelength = null;
		wavelength_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_refln)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_refln>\n");
			if (angle_chi != null) ow.write(indent + " <PDBx:angle_chi>" + angle_chi + "</PDBx:angle_chi>\n");
			if (angle_kappa != null) ow.write(indent + " <PDBx:angle_kappa>" + angle_kappa + "</PDBx:angle_kappa>\n");
			if (angle_omega != null) ow.write(indent + " <PDBx:angle_omega>" + angle_omega + "</PDBx:angle_omega>\n");
			if (angle_phi != null) ow.write(indent + " <PDBx:angle_phi>" + angle_phi + "</PDBx:angle_phi>\n");
			if (angle_psi != null) ow.write(indent + " <PDBx:angle_psi>" + angle_psi + "</PDBx:angle_psi>\n");
			if (angle_theta != null) ow.write(indent + " <PDBx:angle_theta>" + angle_theta + "</PDBx:angle_theta>\n");
			if (attenuator_code != null) ow.write(indent + " <PDBx:attenuator_code>" + attenuator_code + "</PDBx:attenuator_code>\n");
			if (class_code != null) ow.write(indent + " <PDBx:class_code>" + class_code + "</PDBx:class_code>\n");
			if (counts_bg_1 != null) ow.write(indent + " <PDBx:counts_bg_1>" + counts_bg_1 + "</PDBx:counts_bg_1>\n");
			if (counts_bg_2 != null) ow.write(indent + " <PDBx:counts_bg_2>" + counts_bg_2 + "</PDBx:counts_bg_2>\n");
			if (counts_net != null) ow.write(indent + " <PDBx:counts_net>" + counts_net + "</PDBx:counts_net>\n");
			if (counts_peak != null) ow.write(indent + " <PDBx:counts_peak>" + counts_peak + "</PDBx:counts_peak>\n");
			if (counts_total != null) ow.write(indent + " <PDBx:counts_total>" + counts_total + "</PDBx:counts_total>\n");
			if (detect_slit_horiz != null) ow.write(indent + " <PDBx:detect_slit_horiz>" + detect_slit_horiz + "</PDBx:detect_slit_horiz>\n");
			if (detect_slit_vert != null) ow.write(indent + " <PDBx:detect_slit_vert>" + detect_slit_vert + "</PDBx:detect_slit_vert>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (elapsed_time != null) ow.write(indent + " <PDBx:elapsed_time>" + elapsed_time + "</PDBx:elapsed_time>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			if (intensity_net != null) ow.write(indent + " <PDBx:intensity_net>" + intensity_net + "</PDBx:intensity_net>\n");
			if (intensity_sigma != null) ow.write(indent + " <PDBx:intensity_sigma>" + intensity_sigma + "</PDBx:intensity_sigma>\n");
			if (intensity_u != null) ow.write(indent + " <PDBx:intensity_u>" + intensity_u + "</PDBx:intensity_u>\n");
			if (scale_group_code != null) ow.write(indent + " <PDBx:scale_group_code>" + scale_group_code + "</PDBx:scale_group_code>\n");
			if (scan_mode != null) ow.write(indent + " <PDBx:scan_mode>" + scan_mode + "</PDBx:scan_mode>\n");
			if (scan_mode_backgd != null) ow.write(indent + " <PDBx:scan_mode_backgd>" + scan_mode_backgd + "</PDBx:scan_mode_backgd>\n");
			if (scan_rate != null) ow.write(indent + " <PDBx:scan_rate>" + scan_rate + "</PDBx:scan_rate>\n");
			if (scan_time_backgd != null) ow.write(indent + " <PDBx:scan_time_backgd>" + scan_time_backgd + "</PDBx:scan_time_backgd>\n");
			if (scan_width != null) ow.write(indent + " <PDBx:scan_width>" + scan_width + "</PDBx:scan_width>\n");
			if (sint_over_lambda != null) ow.write(indent + " <PDBx:sint_over_lambda>" + sint_over_lambda + "</PDBx:sint_over_lambda>\n");
			if (standard_code != null) ow.write(indent + " <PDBx:standard_code>" + standard_code + "</PDBx:standard_code>\n");
			if (wavelength != null) ow.write(indent + " <PDBx:wavelength>" + wavelength + "</PDBx:wavelength>\n");
			if (wavelength_id != null) ow.write(indent + " <PDBx:wavelength_id>" + wavelength_id + "</PDBx:wavelength_id>\n");
			ow.write(indent + "</PDBx:diffrn_refln>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
