package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_REFLNS category record details about
 *  the set of intensities measured in the diffraction experiment.
 *  
 *  The DIFFRN_REFLN data items refer to individual intensity
 *  measurements and must be included in looped lists.
 *  
 *  The DIFFRN_REFLNS data items specify the parameters that apply
 *  to all intensity measurements in a diffraction data set.
 */
public class Diffrn_reflns extends org.pdb.beans.Diffrn_reflns implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_reflns";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_reflns()
	{
	}

	/** Full constructor */
	public Diffrn_reflns(
		Datablock datablock,
		java.lang.Float av_R_equivalents,
		java.lang.Float av_sigmaI_over_netI,
		java.lang.Float av_unetI_over_netI,
		java.lang.String diffrn_id,
		java.lang.Integer limit_h_max,
		java.lang.Integer limit_h_min,
		java.lang.Integer limit_k_max,
		java.lang.Integer limit_k_min,
		java.lang.Integer limit_l_max,
		java.lang.Integer limit_l_min,
		java.lang.Integer number,
		java.lang.String reduction_process,
		java.lang.Float theta_max,
		java.lang.Float theta_min,
		java.lang.Float transf_matrix11,
		java.lang.Float transf_matrix12,
		java.lang.Float transf_matrix13,
		java.lang.Float transf_matrix21,
		java.lang.Float transf_matrix22,
		java.lang.Float transf_matrix23,
		java.lang.Float transf_matrix31,
		java.lang.Float transf_matrix32,
		java.lang.Float transf_matrix33)
	{
		this.datablock = datablock;
		this.av_R_equivalents = av_R_equivalents;
		this.av_sigmaI_over_netI = av_sigmaI_over_netI;
		this.av_unetI_over_netI = av_unetI_over_netI;
		this.diffrn_id = diffrn_id;
		this.limit_h_max = limit_h_max;
		this.limit_h_min = limit_h_min;
		this.limit_k_max = limit_k_max;
		this.limit_k_min = limit_k_min;
		this.limit_l_max = limit_l_max;
		this.limit_l_min = limit_l_min;
		this.number = number;
		this.reduction_process = reduction_process;
		this.theta_max = theta_max;
		this.theta_min = theta_min;
		this.transf_matrix11 = transf_matrix11;
		this.transf_matrix12 = transf_matrix12;
		this.transf_matrix13 = transf_matrix13;
		this.transf_matrix21 = transf_matrix21;
		this.transf_matrix22 = transf_matrix22;
		this.transf_matrix23 = transf_matrix23;
		this.transf_matrix31 = transf_matrix31;
		this.transf_matrix32 = transf_matrix32;
		this.transf_matrix33 = transf_matrix33;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_reflns");
		sb.append("\n");
		if (av_R_equivalents != null)
		{
			sb.append("av_R_equivalents = ");
			sb.append(av_R_equivalents);
			sb.append('\n');
		}
		if (av_sigmaI_over_netI != null)
		{
			sb.append("av_sigmaI_over_netI = ");
			sb.append(av_sigmaI_over_netI);
			sb.append('\n');
		}
		if (av_unetI_over_netI != null)
		{
			sb.append("av_unetI_over_netI = ");
			sb.append(av_unetI_over_netI);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (limit_h_max != null)
		{
			sb.append("limit_h_max = ");
			sb.append(limit_h_max);
			sb.append('\n');
		}
		if (limit_h_min != null)
		{
			sb.append("limit_h_min = ");
			sb.append(limit_h_min);
			sb.append('\n');
		}
		if (limit_k_max != null)
		{
			sb.append("limit_k_max = ");
			sb.append(limit_k_max);
			sb.append('\n');
		}
		if (limit_k_min != null)
		{
			sb.append("limit_k_min = ");
			sb.append(limit_k_min);
			sb.append('\n');
		}
		if (limit_l_max != null)
		{
			sb.append("limit_l_max = ");
			sb.append(limit_l_max);
			sb.append('\n');
		}
		if (limit_l_min != null)
		{
			sb.append("limit_l_min = ");
			sb.append(limit_l_min);
			sb.append('\n');
		}
		if (number != null)
		{
			sb.append("number = ");
			sb.append(number);
			sb.append('\n');
		}
		if (reduction_process != null)
		{
			sb.append("reduction_process = ");
			sb.append(reduction_process);
			sb.append('\n');
		}
		if (theta_max != null)
		{
			sb.append("theta_max = ");
			sb.append(theta_max);
			sb.append('\n');
		}
		if (theta_min != null)
		{
			sb.append("theta_min = ");
			sb.append(theta_min);
			sb.append('\n');
		}
		if (transf_matrix11 != null)
		{
			sb.append("transf_matrix11 = ");
			sb.append(transf_matrix11);
			sb.append('\n');
		}
		if (transf_matrix12 != null)
		{
			sb.append("transf_matrix12 = ");
			sb.append(transf_matrix12);
			sb.append('\n');
		}
		if (transf_matrix13 != null)
		{
			sb.append("transf_matrix13 = ");
			sb.append(transf_matrix13);
			sb.append('\n');
		}
		if (transf_matrix21 != null)
		{
			sb.append("transf_matrix21 = ");
			sb.append(transf_matrix21);
			sb.append('\n');
		}
		if (transf_matrix22 != null)
		{
			sb.append("transf_matrix22 = ");
			sb.append(transf_matrix22);
			sb.append('\n');
		}
		if (transf_matrix23 != null)
		{
			sb.append("transf_matrix23 = ");
			sb.append(transf_matrix23);
			sb.append('\n');
		}
		if (transf_matrix31 != null)
		{
			sb.append("transf_matrix31 = ");
			sb.append(transf_matrix31);
			sb.append('\n');
		}
		if (transf_matrix32 != null)
		{
			sb.append("transf_matrix32 = ");
			sb.append(transf_matrix32);
			sb.append('\n');
		}
		if (transf_matrix33 != null)
		{
			sb.append("transf_matrix33 = ");
			sb.append(transf_matrix33);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		av_R_equivalents = null;
		av_sigmaI_over_netI = null;
		av_unetI_over_netI = null;
		diffrn_id = null;
		limit_h_max = null;
		limit_h_min = null;
		limit_k_max = null;
		limit_k_min = null;
		limit_l_max = null;
		limit_l_min = null;
		number = null;
		reduction_process = null;
		theta_max = null;
		theta_min = null;
		transf_matrix11 = null;
		transf_matrix12 = null;
		transf_matrix13 = null;
		transf_matrix21 = null;
		transf_matrix22 = null;
		transf_matrix23 = null;
		transf_matrix31 = null;
		transf_matrix32 = null;
		transf_matrix33 = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_reflns)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_reflns>\n");
			if (av_R_equivalents != null) ow.write(indent + " <PDBx:av_R_equivalents>" + av_R_equivalents + "</PDBx:av_R_equivalents>\n");
			if (av_sigmaI_over_netI != null) ow.write(indent + " <PDBx:av_sigmaI_over_netI>" + av_sigmaI_over_netI + "</PDBx:av_sigmaI_over_netI>\n");
			if (av_unetI_over_netI != null) ow.write(indent + " <PDBx:av_unetI_over_netI>" + av_unetI_over_netI + "</PDBx:av_unetI_over_netI>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (limit_h_max != null) ow.write(indent + " <PDBx:limit_h_max>" + limit_h_max + "</PDBx:limit_h_max>\n");
			if (limit_h_min != null) ow.write(indent + " <PDBx:limit_h_min>" + limit_h_min + "</PDBx:limit_h_min>\n");
			if (limit_k_max != null) ow.write(indent + " <PDBx:limit_k_max>" + limit_k_max + "</PDBx:limit_k_max>\n");
			if (limit_k_min != null) ow.write(indent + " <PDBx:limit_k_min>" + limit_k_min + "</PDBx:limit_k_min>\n");
			if (limit_l_max != null) ow.write(indent + " <PDBx:limit_l_max>" + limit_l_max + "</PDBx:limit_l_max>\n");
			if (limit_l_min != null) ow.write(indent + " <PDBx:limit_l_min>" + limit_l_min + "</PDBx:limit_l_min>\n");
			if (number != null) ow.write(indent + " <PDBx:number>" + number + "</PDBx:number>\n");
			if (reduction_process != null) ow.write(indent + " <PDBx:reduction_process>" + reduction_process + "</PDBx:reduction_process>\n");
			if (theta_max != null) ow.write(indent + " <PDBx:theta_max>" + theta_max + "</PDBx:theta_max>\n");
			if (theta_min != null) ow.write(indent + " <PDBx:theta_min>" + theta_min + "</PDBx:theta_min>\n");
			if (transf_matrix11 != null) ow.write(indent + " <PDBx:transf_matrix11>" + transf_matrix11 + "</PDBx:transf_matrix11>\n");
			if (transf_matrix12 != null) ow.write(indent + " <PDBx:transf_matrix12>" + transf_matrix12 + "</PDBx:transf_matrix12>\n");
			if (transf_matrix13 != null) ow.write(indent + " <PDBx:transf_matrix13>" + transf_matrix13 + "</PDBx:transf_matrix13>\n");
			if (transf_matrix21 != null) ow.write(indent + " <PDBx:transf_matrix21>" + transf_matrix21 + "</PDBx:transf_matrix21>\n");
			if (transf_matrix22 != null) ow.write(indent + " <PDBx:transf_matrix22>" + transf_matrix22 + "</PDBx:transf_matrix22>\n");
			if (transf_matrix23 != null) ow.write(indent + " <PDBx:transf_matrix23>" + transf_matrix23 + "</PDBx:transf_matrix23>\n");
			if (transf_matrix31 != null) ow.write(indent + " <PDBx:transf_matrix31>" + transf_matrix31 + "</PDBx:transf_matrix31>\n");
			if (transf_matrix32 != null) ow.write(indent + " <PDBx:transf_matrix32>" + transf_matrix32 + "</PDBx:transf_matrix32>\n");
			if (transf_matrix33 != null) ow.write(indent + " <PDBx:transf_matrix33>" + transf_matrix33 + "</PDBx:transf_matrix33>\n");
			ow.write(indent + "</PDBx:diffrn_reflns>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
