package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_SCALE_GROUP category record details
 *  of the scaling factors applied to place all intensities in the
 *  reflection lists on a common scale.
 *  Scaling groups might, for example, correspond to each film in a
 *  multi-film data set or each crystal in a multi-crystal data set.
 *  
 * <pre>
 *  Example 1 - based on CAD-4 diffractometer data obtained for
 *  Yb(S-C5H4N)2(THF)4.
 *  <PDBx:diffrn_scale_groupCategory>
 *  <PDBx:diffrn_scale_group code="A24">
 *  <PDBx:I_net>1.021</PDBx:I_net>
 *  </PDBx:diffrn_scale_group>
 *  </PDBx:diffrn_scale_groupCategory>
 * </pre>
 */
public class Diffrn_scale_group extends org.pdb.beans.Diffrn_scale_group implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_scale_group";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_scale_group()
	{
	}

	/** Full constructor */
	public Diffrn_scale_group(
		Datablock datablock,
		java.lang.Float I_net,
		java.lang.String code)
	{
		this.datablock = datablock;
		this.I_net = I_net;
		this.code = code;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_scale_group");
		sb.append("\n");
		if (I_net != null)
		{
			sb.append("I_net = ");
			sb.append(I_net);
			sb.append('\n');
		}
		if (code != null)
		{
			sb.append("code = ");
			sb.append(code);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		I_net = null;
		code = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_scale_group)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_scale_group>\n");
			if (I_net != null) ow.write(indent + " <PDBx:I_net>" + I_net + "</PDBx:I_net>\n");
			if (code != null) ow.write(indent + " <PDBx:code>" + code + "</PDBx:code>\n");
			ow.write(indent + "</PDBx:diffrn_scale_group>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
