package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_STANDARD_REFLN category record details
 *  about the reflections treated as standards during the measurement
 *  of a set of diffraction intensities.
 *  
 *  Note that these are the individual standard reflections, not the
 *  results of the analysis of the standard reflections.
 *  
 * <pre>
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_standard_reflnCategory>
 *  <PDBx:diffrn_standard_refln diffrn_id="s1" code="1">
 *  <PDBx:index_h>3</PDBx:index_h>
 *  <PDBx:index_k>2</PDBx:index_k>
 *  <PDBx:index_l>4</PDBx:index_l>
 *  </PDBx:diffrn_standard_refln>
 *  <PDBx:diffrn_standard_refln diffrn_id="s1" code="1">
 *  <PDBx:index_h>1</PDBx:index_h>
 *  <PDBx:index_k>9</PDBx:index_k>
 *  <PDBx:index_l>1</PDBx:index_l>
 *  </PDBx:diffrn_standard_refln>
 *  <PDBx:diffrn_standard_refln diffrn_id="s1" code="1">
 *  <PDBx:index_h>3</PDBx:index_h>
 *  <PDBx:index_k>0</PDBx:index_k>
 *  <PDBx:index_l>10</PDBx:index_l>
 *  </PDBx:diffrn_standard_refln>
 *  </PDBx:diffrn_standard_reflnCategory>
 * </pre>
 */
public class Diffrn_standard_refln extends org.pdb.beans.Diffrn_standard_refln implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_standard_refln";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_standard_refln()
	{
	}

	/** Full constructor */
	public Diffrn_standard_refln(
		Datablock datablock,
		java.lang.String code,
		java.lang.String diffrn_id,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l)
	{
		this.datablock = datablock;
		this.code = code;
		this.diffrn_id = diffrn_id;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_standard_refln");
		sb.append("\n");
		if (code != null)
		{
			sb.append("code = ");
			sb.append(code);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		code = null;
		diffrn_id = null;
		index_h = null;
		index_k = null;
		index_l = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_standard_refln)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_standard_refln>\n");
			if (code != null) ow.write(indent + " <PDBx:code>" + code + "</PDBx:code>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			ow.write(indent + "</PDBx:diffrn_standard_refln>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
