package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_2D_CRYSTAL_GROW category
 *  record details of growth conditions for 2d crystal samples.
 * <pre>
 *  Example 1 - based on PDB entry 1AT9 and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_2d_crystal_growCategory>
 *  <PDBx:em_2d_crystal_grow id="1">
 *  <PDBx:atmosphere>room air</PDBx:atmosphere>
 *  <PDBx:pH>5.2</PDBx:pH>
 *  <PDBx:temp>18.</PDBx:temp>
 *  <PDBx:buffer_id>2</PDBx:buffer_id>
 *  <PDBx:details>on grid</PDBx:details>
 *  <PDBx:number_2d_crystals>129</PDBx:number_2d_crystals>
 *  <PDBx:citation_id>2</PDBx:citation_id>
 *  </PDBx:em_2d_crystal_grow>
 *  </PDBx:em_2d_crystal_growCategory>
 * </pre>
 */
public class Em_2d_crystal_grow extends org.pdb.beans.Em_2d_crystal_grow implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_2d_crystal_grow";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_2d_crystal_grow()
	{
	}

	/** Full constructor */
	public Em_2d_crystal_grow(
		Datablock datablock,
		java.lang.String apparatus,
		java.lang.String atmosphere,
		java.lang.String buffer_id,
		java.lang.String citation_id,
		java.lang.String details,
		java.lang.String id_,
		java.lang.Float mean_2d_crystal_size,
		java.lang.String method,
		java.lang.Integer number_2d_crystals,
		java.lang.Float pH,
		java.lang.Float temp,
		java.lang.String time)
	{
		this.datablock = datablock;
		this.apparatus = apparatus;
		this.atmosphere = atmosphere;
		this.buffer_id = buffer_id;
		this.citation_id = citation_id;
		this.details = details;
		this.id_ = id_;
		this.mean_2d_crystal_size = mean_2d_crystal_size;
		this.method = method;
		this.number_2d_crystals = number_2d_crystals;
		this.pH = pH;
		this.temp = temp;
		this.time = time;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_2d_crystal_grow");
		sb.append("\n");
		if (apparatus != null)
		{
			sb.append("apparatus = ");
			sb.append(apparatus);
			sb.append('\n');
		}
		if (atmosphere != null)
		{
			sb.append("atmosphere = ");
			sb.append(atmosphere);
			sb.append('\n');
		}
		if (buffer_id != null)
		{
			sb.append("buffer_id = ");
			sb.append(buffer_id);
			sb.append('\n');
		}
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (mean_2d_crystal_size != null)
		{
			sb.append("mean_2d_crystal_size = ");
			sb.append(mean_2d_crystal_size);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (number_2d_crystals != null)
		{
			sb.append("number_2d_crystals = ");
			sb.append(number_2d_crystals);
			sb.append('\n');
		}
		if (pH != null)
		{
			sb.append("pH = ");
			sb.append(pH);
			sb.append('\n');
		}
		if (temp != null)
		{
			sb.append("temp = ");
			sb.append(temp);
			sb.append('\n');
		}
		if (time != null)
		{
			sb.append("time = ");
			sb.append(time);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		apparatus = null;
		atmosphere = null;
		buffer_id = null;
		citation_id = null;
		details = null;
		id_ = null;
		mean_2d_crystal_size = null;
		method = null;
		number_2d_crystals = null;
		pH = null;
		temp = null;
		time = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_2d_crystal_grow)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_2d_crystal_grow>\n");
			if (apparatus != null) ow.write(indent + " <PDBx:apparatus>" + apparatus + "</PDBx:apparatus>\n");
			if (atmosphere != null) ow.write(indent + " <PDBx:atmosphere>" + atmosphere + "</PDBx:atmosphere>\n");
			if (buffer_id != null) ow.write(indent + " <PDBx:buffer_id>" + buffer_id + "</PDBx:buffer_id>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (mean_2d_crystal_size != null) ow.write(indent + " <PDBx:mean_2d_crystal_size>" + mean_2d_crystal_size + "</PDBx:mean_2d_crystal_size>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (number_2d_crystals != null) ow.write(indent + " <PDBx:number_2d_crystals>" + number_2d_crystals + "</PDBx:number_2d_crystals>\n");
			if (pH != null) ow.write(indent + " <PDBx:pH>" + pH + "</PDBx:pH>\n");
			if (temp != null) ow.write(indent + " <PDBx:temp>" + temp + "</PDBx:temp>\n");
			if (time != null) ow.write(indent + " <PDBx:time>" + time + "</PDBx:time>\n");
			ow.write(indent + "</PDBx:em_2d_crystal_grow>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
