package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_2D_PROJECTION_SELECTION category
 *  record details of images from scanned micrographs and the
 *  number of particles selected from a scanned set of micrographs.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_2d_projection_selectionCategory>
 *  <PDBx:em_2d_projection_selection entry_id="1">
 *  <PDBx:software_name>1</PDBx:software_name>
 *  <PDBx:method>INTERACTIVE</PDBx:method>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  </PDBx:em_2d_projection_selection>
 *  </PDBx:em_2d_projection_selectionCategory>
 * </pre>
 */
public class Em_2d_projection_selection extends org.pdb.beans.Em_2d_projection_selection implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_2d_projection_selection";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_2d_projection_selection()
	{
	}

	/** Full constructor */
	public Em_2d_projection_selection(
		Datablock datablock,
		java.lang.String citation_id,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String method,
		java.lang.Integer num_particles,
		java.lang.String software_name)
	{
		this.datablock = datablock;
		this.citation_id = citation_id;
		this.details = details;
		this.entry_id = entry_id;
		this.method = method;
		this.num_particles = num_particles;
		this.software_name = software_name;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_2d_projection_selection");
		sb.append("\n");
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (num_particles != null)
		{
			sb.append("num_particles = ");
			sb.append(num_particles);
			sb.append('\n');
		}
		if (software_name != null)
		{
			sb.append("software_name = ");
			sb.append(software_name);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		citation_id = null;
		details = null;
		entry_id = null;
		method = null;
		num_particles = null;
		software_name = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_2d_projection_selection)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_2d_projection_selection>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (num_particles != null) ow.write(indent + " <PDBx:num_particles>" + num_particles + "</PDBx:num_particles>\n");
			if (software_name != null) ow.write(indent + " <PDBx:software_name>" + software_name + "</PDBx:software_name>\n");
			ow.write(indent + "</PDBx:em_2d_projection_selection>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
