package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the 3D_FITTING category
 *  record details of the method of fitting atomic
 *  coordinates from a PDB file into a 3d-em
 *  volume map file
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_3d_fittingCategory>
 *  <PDBx:em_3d_fitting id="1" entry_id="1DYL">
 *  <PDBx:method>AUTOMATIC</PDBx:method>
 *  <PDBx:target_criteria>R-FACTOR</PDBx:target_criteria>
 *  <PDBx:software_name>1</PDBx:software_name>
 *  <PDBx:ref_space>REAL</PDBx:ref_space>
 *  <PDBx:ref_protocol>RIGID BODY REFINEMENT</PDBx:ref_protocol>
 *  <PDBx:details>   THE CRYSTAL STRUCTURE OF THE CAPSID
 *  PROTEIN FROM CHOI ET AL (1997) PROTEINS 3 27:345-359
 *  (SUBUNIT A OF PDB FILE 1VCQ) WAS PLACED INTO THE CRYO-EM
 *  DENSITY MAP. THE CAPSID PROTEIN WAS FIRST MANUALLY POSITIONED
 *  INTO THE CRYO-EM DENSITY CORRESPONDING TO POSITIONS OF THE
 *  FOUR INDEPENDENT MONOMER DENSITIES BETWEEN THE INNER LEAFLET
 *  OF THE BILAYER AND THE RNA. THESE POSITIONS WERE THEN REFINED
 *  BY RIGID BODY REFINEMENT IN REAL SPACE WITH THE PROGRAM EMFIT
 *  (CHENG ET AL. 1995, CELL 80, 621-630).  THE QUALITY OF THE FIT
 *  CAN BE SEEN FROM THE MAP DENSITY WITHIN THE PROTEIN. ALL 4563
 *  ATOMS ARE IN DENSITY OF AT LEAST 4 SIGMA (96.73) ABOVE THE
 *  AVERAGE (512.04), 1167 ATOMS ARE IN DENSITY BETWEEN 4 AND 5
 *  SIGMA, 3174 ATOMS ARE IN DENSITY BETWEEN 5 AND 6 SIGMA, AND 222
 *  ATOMS ARE IN DENSTY OF 6 SIGMA OR ABOVE. THE VARIATION IN
 *  DENSITY OVER THE FITTED PROTEIN CAN BE VISUALIZED WITH THE
 *  PSEUDO TEMPERATURE FACTOR. THE DENSITY VALUE AT EACH ATOM IS
 *  GIVEN IN THE 8TH COLUM (USUALLY THE OCCUPANCY) AS THE NUMBER
 *  OF STANDARD DEVIATION ABOVE BACKGROUND. COLUMN NINE (USUALLY
 *  THE TEMPERATURE FACTOR) CONTAINS THE VALUE OF THE RELATIVE
 *  DENSITY WITHIN THE FITTED PROTEIN SCALED LINEARLY SO THAT THE
 *  MINIMUM DENSITY IS 100.0 AND THE MAXIMUM DENSITY IS 1.0.  THE
 *  ATOMS THAT LIE IN THE LOWER DENSITY REGIONS WILL HAVE THE
 *  HIGHEST PSEUDO TEMPERATURE FACTORS.                                 </PDBx:details>
 *  </PDBx:em_3d_fitting>
 *  </PDBx:em_3d_fittingCategory>
 * </pre>
 */
public class Em_3d_fitting extends org.pdb.beans.Em_3d_fitting implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_3d_fitting";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_3d_fitting()
	{
	}

	/** Full constructor */
	public Em_3d_fitting(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.String method,
		java.lang.Float overall_b_value,
		java.lang.String ref_protocol,
		java.lang.String ref_space,
		java.lang.String software_name,
		java.lang.String target_criteria)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.method = method;
		this.overall_b_value = overall_b_value;
		this.ref_protocol = ref_protocol;
		this.ref_space = ref_space;
		this.software_name = software_name;
		this.target_criteria = target_criteria;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_3d_fitting");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (overall_b_value != null)
		{
			sb.append("overall_b_value = ");
			sb.append(overall_b_value);
			sb.append('\n');
		}
		if (ref_protocol != null)
		{
			sb.append("ref_protocol = ");
			sb.append(ref_protocol);
			sb.append('\n');
		}
		if (ref_space != null)
		{
			sb.append("ref_space = ");
			sb.append(ref_space);
			sb.append('\n');
		}
		if (software_name != null)
		{
			sb.append("software_name = ");
			sb.append(software_name);
			sb.append('\n');
		}
		if (target_criteria != null)
		{
			sb.append("target_criteria = ");
			sb.append(target_criteria);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		id_ = null;
		method = null;
		overall_b_value = null;
		ref_protocol = null;
		ref_space = null;
		software_name = null;
		target_criteria = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_3d_fitting)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_3d_fitting>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (overall_b_value != null) ow.write(indent + " <PDBx:overall_b_value>" + overall_b_value + "</PDBx:overall_b_value>\n");
			if (ref_protocol != null) ow.write(indent + " <PDBx:ref_protocol>" + ref_protocol + "</PDBx:ref_protocol>\n");
			if (ref_space != null) ow.write(indent + " <PDBx:ref_space>" + ref_space + "</PDBx:ref_space>\n");
			if (software_name != null) ow.write(indent + " <PDBx:software_name>" + software_name + "</PDBx:software_name>\n");
			if (target_criteria != null) ow.write(indent + " <PDBx:target_criteria>" + target_criteria + "</PDBx:target_criteria>\n");
			ow.write(indent + "</PDBx:em_3d_fitting>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
