package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_3D_RECONSTRUCTION category
 *  record details of the 3D reconstruction procedure from 2D projections.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_3d_reconstructionCategory>
 *  <PDBx:em_3d_reconstruction entry_id="1DYL" id="1">
 *  <PDBx:method>CROSS-COMMON LINES</PDBx:method>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  <PDBx:resolution>9.</PDBx:resolution>
 *  <PDBx:nominal_pixel_size>2.64</PDBx:nominal_pixel_size>
 *  <PDBx:actual_pixel_size>2.52</PDBx:actual_pixel_size>
 *  </PDBx:em_3d_reconstruction>
 *  </PDBx:em_3d_reconstructionCategory>
 * </pre>
 */
public class Em_3d_reconstruction extends org.pdb.beans.Em_3d_reconstruction implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_3d_reconstruction";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_3d_reconstruction()
	{
	}

	/** Full constructor */
	public Em_3d_reconstruction(
		Datablock datablock,
		java.lang.Float actual_pixel_size,
		java.lang.String citation_id,
		java.lang.String ctf_correction_method,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.String magnification_calibration,
		java.lang.String method,
		java.lang.Float nominal_pixel_size,
		java.lang.Float resolution,
		java.lang.String resolution_method)
	{
		this.datablock = datablock;
		this.actual_pixel_size = actual_pixel_size;
		this.citation_id = citation_id;
		this.ctf_correction_method = ctf_correction_method;
		this.details = details;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.magnification_calibration = magnification_calibration;
		this.method = method;
		this.nominal_pixel_size = nominal_pixel_size;
		this.resolution = resolution;
		this.resolution_method = resolution_method;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_3d_reconstruction");
		sb.append("\n");
		if (actual_pixel_size != null)
		{
			sb.append("actual_pixel_size = ");
			sb.append(actual_pixel_size);
			sb.append('\n');
		}
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (ctf_correction_method != null)
		{
			sb.append("ctf_correction_method = ");
			sb.append(ctf_correction_method);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (magnification_calibration != null)
		{
			sb.append("magnification_calibration = ");
			sb.append(magnification_calibration);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (nominal_pixel_size != null)
		{
			sb.append("nominal_pixel_size = ");
			sb.append(nominal_pixel_size);
			sb.append('\n');
		}
		if (resolution != null)
		{
			sb.append("resolution = ");
			sb.append(resolution);
			sb.append('\n');
		}
		if (resolution_method != null)
		{
			sb.append("resolution_method = ");
			sb.append(resolution_method);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		actual_pixel_size = null;
		citation_id = null;
		ctf_correction_method = null;
		details = null;
		entry_id = null;
		id_ = null;
		magnification_calibration = null;
		method = null;
		nominal_pixel_size = null;
		resolution = null;
		resolution_method = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_3d_reconstruction)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_3d_reconstruction>\n");
			if (actual_pixel_size != null) ow.write(indent + " <PDBx:actual_pixel_size>" + actual_pixel_size + "</PDBx:actual_pixel_size>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (ctf_correction_method != null) ow.write(indent + " <PDBx:ctf_correction_method>" + ctf_correction_method + "</PDBx:ctf_correction_method>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (magnification_calibration != null) ow.write(indent + " <PDBx:magnification_calibration>" + magnification_calibration + "</PDBx:magnification_calibration>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (nominal_pixel_size != null) ow.write(indent + " <PDBx:nominal_pixel_size>" + nominal_pixel_size + "</PDBx:nominal_pixel_size>\n");
			if (resolution != null) ow.write(indent + " <PDBx:resolution>" + resolution + "</PDBx:resolution>\n");
			if (resolution_method != null) ow.write(indent + " <PDBx:resolution_method>" + resolution_method + "</PDBx:resolution_method>\n");
			ow.write(indent + "</PDBx:em_3d_reconstruction>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
