package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_ASSEMBLY category record details
 *  about the type of complex assembly that describes the
 *  nature of the sample studied.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_assemblyCategory>
 *  <PDBx:em_assembly id="1" entry_id="1DYL">
 *  <PDBx:name>virus</PDBx:name>
 *  <PDBx:aggregation_state>icosahedral</PDBx:aggregation_state>
 *  <PDBx:composition>virus</PDBx:composition>
 *  <PDBx:num_components>1</PDBx:num_components>
 *  </PDBx:em_assembly>
 *  </PDBx:em_assemblyCategory>
 * </pre>
 */
public class Em_assembly extends org.pdb.beans.Em_assembly implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_assembly";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_assembly()
	{
	}

	/** Full constructor */
	public Em_assembly(
		Datablock datablock,
		java.lang.String aggregation_state,
		java.lang.String composition,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.Float mol_wt_exp,
		java.lang.String mol_wt_method,
		java.lang.Float mol_wt_theo,
		java.lang.String name,
		java.lang.Integer num_components)
	{
		this.datablock = datablock;
		this.aggregation_state = aggregation_state;
		this.composition = composition;
		this.details = details;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.mol_wt_exp = mol_wt_exp;
		this.mol_wt_method = mol_wt_method;
		this.mol_wt_theo = mol_wt_theo;
		this.name = name;
		this.num_components = num_components;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_assembly");
		sb.append("\n");
		if (aggregation_state != null)
		{
			sb.append("aggregation_state = ");
			sb.append(aggregation_state);
			sb.append('\n');
		}
		if (composition != null)
		{
			sb.append("composition = ");
			sb.append(composition);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (mol_wt_exp != null)
		{
			sb.append("mol_wt_exp = ");
			sb.append(mol_wt_exp);
			sb.append('\n');
		}
		if (mol_wt_method != null)
		{
			sb.append("mol_wt_method = ");
			sb.append(mol_wt_method);
			sb.append('\n');
		}
		if (mol_wt_theo != null)
		{
			sb.append("mol_wt_theo = ");
			sb.append(mol_wt_theo);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (num_components != null)
		{
			sb.append("num_components = ");
			sb.append(num_components);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		aggregation_state = null;
		composition = null;
		details = null;
		entry_id = null;
		id_ = null;
		mol_wt_exp = null;
		mol_wt_method = null;
		mol_wt_theo = null;
		name = null;
		num_components = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_assembly)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_assembly>\n");
			if (aggregation_state != null) ow.write(indent + " <PDBx:aggregation_state>" + aggregation_state + "</PDBx:aggregation_state>\n");
			if (composition != null) ow.write(indent + " <PDBx:composition>" + composition + "</PDBx:composition>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (mol_wt_exp != null) ow.write(indent + " <PDBx:mol_wt_exp>" + mol_wt_exp + "</PDBx:mol_wt_exp>\n");
			if (mol_wt_method != null) ow.write(indent + " <PDBx:mol_wt_method>" + mol_wt_method + "</PDBx:mol_wt_method>\n");
			if (mol_wt_theo != null) ow.write(indent + " <PDBx:mol_wt_theo>" + mol_wt_theo + "</PDBx:mol_wt_theo>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (num_components != null) ow.write(indent + " <PDBx:num_components>" + num_components + "</PDBx:num_components>\n");
			ow.write(indent + "</PDBx:em_assembly>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
