package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  data items in the em_electron_diffraction_phase category
 *  record details about the phase information
 *  from the electron diffraction experiment.
 * <pre>
 *  example 1 - based on pdb entry 1tub and laboratory records for the
 *  structure corresponding to pdb entry 1tub
 *  <PDBx:em_electron_diffraction_phaseCategory>
 *  <PDBx:em_electron_diffraction_phase entry_id="1TUB" id="1">
 *  <PDBx:d_res_high>4.0</PDBx:d_res_high>
 *  </PDBx:em_electron_diffraction_phase>
 *  </PDBx:em_electron_diffraction_phaseCategory>
 * </pre>
 */
public class Em_electron_diffraction_phase extends org.pdb.beans.Em_electron_diffraction_phase implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_electron_diffraction_phase";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_electron_diffraction_phase()
	{
	}

	/** Full constructor */
	public Em_electron_diffraction_phase(
		Datablock datablock,
		java.lang.Integer d_res_high,
		java.lang.String entry_id,
		java.lang.Integer highest_resolution_shell_error,
		java.lang.String id_,
		java.lang.Integer overall_error,
		java.lang.Integer rejection_criteria_error,
		java.lang.Integer residual)
	{
		this.datablock = datablock;
		this.d_res_high = d_res_high;
		this.entry_id = entry_id;
		this.highest_resolution_shell_error = highest_resolution_shell_error;
		this.id_ = id_;
		this.overall_error = overall_error;
		this.rejection_criteria_error = rejection_criteria_error;
		this.residual = residual;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_electron_diffraction_phase");
		sb.append("\n");
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (highest_resolution_shell_error != null)
		{
			sb.append("highest_resolution_shell_error = ");
			sb.append(highest_resolution_shell_error);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (overall_error != null)
		{
			sb.append("overall_error = ");
			sb.append(overall_error);
			sb.append('\n');
		}
		if (rejection_criteria_error != null)
		{
			sb.append("rejection_criteria_error = ");
			sb.append(rejection_criteria_error);
			sb.append('\n');
		}
		if (residual != null)
		{
			sb.append("residual = ");
			sb.append(residual);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		d_res_high = null;
		entry_id = null;
		highest_resolution_shell_error = null;
		id_ = null;
		overall_error = null;
		rejection_criteria_error = null;
		residual = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_electron_diffraction_phase)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_electron_diffraction_phase>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (highest_resolution_shell_error != null) ow.write(indent + " <PDBx:highest_resolution_shell_error>" + highest_resolution_shell_error + "</PDBx:highest_resolution_shell_error>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (overall_error != null) ow.write(indent + " <PDBx:overall_error>" + overall_error + "</PDBx:overall_error>\n");
			if (rejection_criteria_error != null) ow.write(indent + " <PDBx:rejection_criteria_error>" + rejection_criteria_error + "</PDBx:rejection_criteria_error>\n");
			if (residual != null) ow.write(indent + " <PDBx:residual>" + residual + "</PDBx:residual>\n");
			ow.write(indent + "</PDBx:em_electron_diffraction_phase>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
