package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the  EM_ENTITY_ASSEMBLY_LIST category record details
 *  of the structural elements in each component.
 * <pre>
 *  Example 1 - microtubule
 *  <PDBx:em_entity_assembly_listCategory>
 *  <PDBx:em_entity_assembly_list entity_assembly_id="1" id="1" entity_id="1">
 *  <PDBx:oligomeric_details>DIMER</PDBx:oligomeric_details>
 *  <PDBx:number_of_copies>2</PDBx:number_of_copies>
 *  </PDBx:em_entity_assembly_list>
 *  </PDBx:em_entity_assembly_listCategory>
 * </pre>
 */
public class Em_entity_assembly_list extends org.pdb.beans.Em_entity_assembly_list implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_entity_assembly_list";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_entity_assembly_list()
	{
	}

	/** Full constructor */
	public Em_entity_assembly_list(
		Datablock datablock,
		java.lang.String entity_assembly_id,
		java.lang.String entity_id,
		java.lang.String id_,
		java.lang.Integer number_of_copies,
		java.lang.String oligomeric_details)
	{
		this.datablock = datablock;
		this.entity_assembly_id = entity_assembly_id;
		this.entity_id = entity_id;
		this.id_ = id_;
		this.number_of_copies = number_of_copies;
		this.oligomeric_details = oligomeric_details;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_entity_assembly_list");
		sb.append("\n");
		if (entity_assembly_id != null)
		{
			sb.append("entity_assembly_id = ");
			sb.append(entity_assembly_id);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (number_of_copies != null)
		{
			sb.append("number_of_copies = ");
			sb.append(number_of_copies);
			sb.append('\n');
		}
		if (oligomeric_details != null)
		{
			sb.append("oligomeric_details = ");
			sb.append(oligomeric_details);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_assembly_id = null;
		entity_id = null;
		id_ = null;
		number_of_copies = null;
		oligomeric_details = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_entity_assembly_list)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_entity_assembly_list>\n");
			if (entity_assembly_id != null) ow.write(indent + " <PDBx:entity_assembly_id>" + entity_assembly_id + "</PDBx:entity_assembly_id>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (number_of_copies != null) ow.write(indent + " <PDBx:number_of_copies>" + number_of_copies + "</PDBx:number_of_copies>\n");
			if (oligomeric_details != null) ow.write(indent + " <PDBx:oligomeric_details>" + oligomeric_details + "</PDBx:oligomeric_details>\n");
			ow.write(indent + "</PDBx:em_entity_assembly_list>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
