package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_EULER_ANGLE_DISTRIBUTION category
 *  record details of assignment of Euler angles for projection
 *  sets of particles.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 * </pre>
 */
public class Em_euler_angle_distribution extends org.pdb.beans.Em_euler_angle_distribution implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_euler_angle_distribution";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_euler_angle_distribution()
	{
	}

	/** Full constructor */
	public Em_euler_angle_distribution(
		Datablock datablock,
		java.lang.Float alpha,
		java.lang.Float beta,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.Float gamma,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.alpha = alpha;
		this.beta = beta;
		this.details = details;
		this.entry_id = entry_id;
		this.gamma = gamma;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_euler_angle_distribution");
		sb.append("\n");
		if (alpha != null)
		{
			sb.append("alpha = ");
			sb.append(alpha);
			sb.append('\n');
		}
		if (beta != null)
		{
			sb.append("beta = ");
			sb.append(beta);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (gamma != null)
		{
			sb.append("gamma = ");
			sb.append(gamma);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		alpha = null;
		beta = null;
		details = null;
		entry_id = null;
		gamma = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_euler_angle_distribution)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_euler_angle_distribution>\n");
			if (alpha != null) ow.write(indent + " <PDBx:alpha>" + alpha + "</PDBx:alpha>\n");
			if (beta != null) ow.write(indent + " <PDBx:beta>" + beta + "</PDBx:beta>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (gamma != null) ow.write(indent + " <PDBx:gamma>" + gamma + "</PDBx:gamma>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:em_euler_angle_distribution>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
