package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_ICOS_VIRUS_SHELLS category record details
 *  of the viral shell number, diameter of each shell and triangulation number.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_icos_virus_shellsCategory>
 *  <PDBx:em_icos_virus_shells virus_entity_id="1" id="1">
 *  <PDBx:shell_diameter>400.</PDBx:shell_diameter>
 *  <PDBx:triangulation_num>4</PDBx:triangulation_num>
 *  </PDBx:em_icos_virus_shells>
 *  </PDBx:em_icos_virus_shellsCategory>
 * </pre>
 */
public class Em_icos_virus_shells extends org.pdb.beans.Em_icos_virus_shells implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_icos_virus_shells";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_icos_virus_shells()
	{
	}

	/** Full constructor */
	public Em_icos_virus_shells(
		Datablock datablock,
		java.lang.String id_,
		java.lang.Float shell_diameter,
		java.lang.Integer triangulation_num,
		java.lang.String virus_entity_id)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.shell_diameter = shell_diameter;
		this.triangulation_num = triangulation_num;
		this.virus_entity_id = virus_entity_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_icos_virus_shells");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (shell_diameter != null)
		{
			sb.append("shell_diameter = ");
			sb.append(shell_diameter);
			sb.append('\n');
		}
		if (triangulation_num != null)
		{
			sb.append("triangulation_num = ");
			sb.append(triangulation_num);
			sb.append('\n');
		}
		if (virus_entity_id != null)
		{
			sb.append("virus_entity_id = ");
			sb.append(virus_entity_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		shell_diameter = null;
		triangulation_num = null;
		virus_entity_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_icos_virus_shells)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_icos_virus_shells>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (shell_diameter != null) ow.write(indent + " <PDBx:shell_diameter>" + shell_diameter + "</PDBx:shell_diameter>\n");
			if (triangulation_num != null) ow.write(indent + " <PDBx:triangulation_num>" + triangulation_num + "</PDBx:triangulation_num>\n");
			if (virus_entity_id != null) ow.write(indent + " <PDBx:virus_entity_id>" + virus_entity_id + "</PDBx:virus_entity_id>\n");
			ow.write(indent + "</PDBx:em_icos_virus_shells>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
