package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_SAMPLE_PREPARATION category
 *  record details of sample conditions prior to loading
 *  onto grid support.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_sample_preparationCategory>
 *  <PDBx:em_sample_preparation entry_id="1DYL" id="1">
 *  <PDBx:ph>7.6</PDBx:ph>
 *  <PDBx:buffer_id>1</PDBx:buffer_id>
 *  <PDBx:sample_concentration>5.</PDBx:sample_concentration>
 *  </PDBx:em_sample_preparation>
 *  </PDBx:em_sample_preparationCategory>
 * </pre>
 */
public class Em_sample_preparation extends org.pdb.beans.Em_sample_preparation implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_sample_preparation";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_sample_preparation()
	{
	}

	/** Full constructor */
	public Em_sample_preparation(
		Datablock datablock,
		java.lang.String _2d_crystal_grow_id,
		java.lang.String buffer_id,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.Float ph,
		java.lang.Float sample_concentration,
		java.lang.String support_id)
	{
		this.datablock = datablock;
		this._2d_crystal_grow_id = _2d_crystal_grow_id;
		this.buffer_id = buffer_id;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.ph = ph;
		this.sample_concentration = sample_concentration;
		this.support_id = support_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_sample_preparation");
		sb.append("\n");
		if (_2d_crystal_grow_id != null)
		{
			sb.append("_2d_crystal_grow_id = ");
			sb.append(_2d_crystal_grow_id);
			sb.append('\n');
		}
		if (buffer_id != null)
		{
			sb.append("buffer_id = ");
			sb.append(buffer_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (ph != null)
		{
			sb.append("ph = ");
			sb.append(ph);
			sb.append('\n');
		}
		if (sample_concentration != null)
		{
			sb.append("sample_concentration = ");
			sb.append(sample_concentration);
			sb.append('\n');
		}
		if (support_id != null)
		{
			sb.append("support_id = ");
			sb.append(support_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		_2d_crystal_grow_id = null;
		buffer_id = null;
		entry_id = null;
		id_ = null;
		ph = null;
		sample_concentration = null;
		support_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_sample_preparation)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_sample_preparation>\n");
			if (_2d_crystal_grow_id != null) ow.write(indent + " <PDBx:_2d_crystal_grow_id>" + _2d_crystal_grow_id + "</PDBx:_2d_crystal_grow_id>\n");
			if (buffer_id != null) ow.write(indent + " <PDBx:buffer_id>" + buffer_id + "</PDBx:buffer_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (ph != null) ow.write(indent + " <PDBx:ph>" + ph + "</PDBx:ph>\n");
			if (sample_concentration != null) ow.write(indent + " <PDBx:sample_concentration>" + sample_concentration + "</PDBx:sample_concentration>\n");
			if (support_id != null) ow.write(indent + " <PDBx:support_id>" + support_id + "</PDBx:support_id>\n");
			ow.write(indent + "</PDBx:em_sample_preparation>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
