package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_VIRUS_ENTITY category record details
 *  of the icosahedral virus.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_virus_entityCategory>
 *  <PDBx:em_virus_entity id="1" entity_assembly_id="1">
 *  <PDBx:virus_host_category>VERTERBRATES</PDBx:virus_host_category>
 *  <PDBx:virus_host_species>HOMO SAPIENS</PDBx:virus_host_species>
 *  <PDBx:virus_type>VIRUS</PDBx:virus_type>
 *  <PDBx:virus_isolate>STRAIN</PDBx:virus_isolate>
 *  <PDBx:ictvdb_id>00.073.0.01.023</PDBx:ictvdb_id>
 *  <PDBx:enveloped>YES</PDBx:enveloped>
 *  <PDBx:empty>NO</PDBx:empty>
 *  </PDBx:em_virus_entity>
 *  </PDBx:em_virus_entityCategory>
 * </pre>
 */
public class Em_virus_entity extends org.pdb.beans.Em_virus_entity implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_virus_entity";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_virus_entity()
	{
	}

	/** Full constructor */
	public Em_virus_entity(
		Datablock datablock,
		java.lang.String details,
		java.lang.String empty,
		java.lang.String entity_assembly_id,
		java.lang.String enveloped,
		java.lang.String ictvdb_id,
		java.lang.String id_,
		java.lang.String virus_host_category,
		java.lang.String virus_host_growth_cell,
		java.lang.String virus_host_species,
		java.lang.String virus_isolate,
		java.lang.String virus_type)
	{
		this.datablock = datablock;
		this.details = details;
		this.empty = empty;
		this.entity_assembly_id = entity_assembly_id;
		this.enveloped = enveloped;
		this.ictvdb_id = ictvdb_id;
		this.id_ = id_;
		this.virus_host_category = virus_host_category;
		this.virus_host_growth_cell = virus_host_growth_cell;
		this.virus_host_species = virus_host_species;
		this.virus_isolate = virus_isolate;
		this.virus_type = virus_type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_virus_entity");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (empty != null)
		{
			sb.append("empty = ");
			sb.append(empty);
			sb.append('\n');
		}
		if (entity_assembly_id != null)
		{
			sb.append("entity_assembly_id = ");
			sb.append(entity_assembly_id);
			sb.append('\n');
		}
		if (enveloped != null)
		{
			sb.append("enveloped = ");
			sb.append(enveloped);
			sb.append('\n');
		}
		if (ictvdb_id != null)
		{
			sb.append("ictvdb_id = ");
			sb.append(ictvdb_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (virus_host_category != null)
		{
			sb.append("virus_host_category = ");
			sb.append(virus_host_category);
			sb.append('\n');
		}
		if (virus_host_growth_cell != null)
		{
			sb.append("virus_host_growth_cell = ");
			sb.append(virus_host_growth_cell);
			sb.append('\n');
		}
		if (virus_host_species != null)
		{
			sb.append("virus_host_species = ");
			sb.append(virus_host_species);
			sb.append('\n');
		}
		if (virus_isolate != null)
		{
			sb.append("virus_isolate = ");
			sb.append(virus_isolate);
			sb.append('\n');
		}
		if (virus_type != null)
		{
			sb.append("virus_type = ");
			sb.append(virus_type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		empty = null;
		entity_assembly_id = null;
		enveloped = null;
		ictvdb_id = null;
		id_ = null;
		virus_host_category = null;
		virus_host_growth_cell = null;
		virus_host_species = null;
		virus_isolate = null;
		virus_type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_virus_entity)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_virus_entity>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (empty != null) ow.write(indent + " <PDBx:empty>" + empty + "</PDBx:empty>\n");
			if (entity_assembly_id != null) ow.write(indent + " <PDBx:entity_assembly_id>" + entity_assembly_id + "</PDBx:entity_assembly_id>\n");
			if (enveloped != null) ow.write(indent + " <PDBx:enveloped>" + enveloped + "</PDBx:enveloped>\n");
			if (ictvdb_id != null) ow.write(indent + " <PDBx:ictvdb_id>" + ictvdb_id + "</PDBx:ictvdb_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (virus_host_category != null) ow.write(indent + " <PDBx:virus_host_category>" + virus_host_category + "</PDBx:virus_host_category>\n");
			if (virus_host_growth_cell != null) ow.write(indent + " <PDBx:virus_host_growth_cell>" + virus_host_growth_cell + "</PDBx:virus_host_growth_cell>\n");
			if (virus_host_species != null) ow.write(indent + " <PDBx:virus_host_species>" + virus_host_species + "</PDBx:virus_host_species>\n");
			if (virus_isolate != null) ow.write(indent + " <PDBx:virus_isolate>" + virus_isolate + "</PDBx:virus_isolate>\n");
			if (virus_type != null) ow.write(indent + " <PDBx:virus_type>" + virus_type + "</PDBx:virus_type>\n");
			ow.write(indent + "</PDBx:em_virus_entity>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
