package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_VITRIFICATION category
 *  record details about the method and cryogen used in
 *  rapid freezing of the sample on the grid prior to its
 *  insertion in the electron microscope
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_vitrificationCategory>
 *  <PDBx:em_vitrification entry_id="1DYL" id="1">
 *  <PDBx:sample_preparation_id>1</PDBx:sample_preparation_id>
 *  <PDBx:cryogen_name>ETHANE</PDBx:cryogen_name>
 *  <PDBx:humidity>90</PDBx:humidity>
 *  <PDBx:temp>95.</PDBx:temp>
 *  <PDBx:method>PLUNGE VITRIFICATION</PDBx:method>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  <PDBx:details> SAMPLES WERE PREPARED AS THIN
 *  LAYERS OF VITREOUS ICE AND
 *  MAINTAINED AT NEAR LIQUID NITROGEN
 *  TEMPERATURE IN THE ELECTRON MICROSCOPE
 *  WITH A GATAN 626-0300 CRYOTRANSFER
 *  HOLDER.                            </PDBx:details>
 *  </PDBx:em_vitrification>
 *  </PDBx:em_vitrificationCategory>
 * </pre>
 */
public class Em_vitrification extends org.pdb.beans.Em_vitrification implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_vitrification";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_vitrification()
	{
	}

	/** Full constructor */
	public Em_vitrification(
		Datablock datablock,
		java.lang.String citation_id,
		java.lang.String cryogen_name,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String humidity,
		java.lang.String id_,
		java.lang.String instrument,
		java.lang.String method,
		java.lang.String sample_preparation_id,
		java.lang.Float temp,
		java.lang.String time_resolved_state)
	{
		this.datablock = datablock;
		this.citation_id = citation_id;
		this.cryogen_name = cryogen_name;
		this.details = details;
		this.entry_id = entry_id;
		this.humidity = humidity;
		this.id_ = id_;
		this.instrument = instrument;
		this.method = method;
		this.sample_preparation_id = sample_preparation_id;
		this.temp = temp;
		this.time_resolved_state = time_resolved_state;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_vitrification");
		sb.append("\n");
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (cryogen_name != null)
		{
			sb.append("cryogen_name = ");
			sb.append(cryogen_name);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (humidity != null)
		{
			sb.append("humidity = ");
			sb.append(humidity);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (instrument != null)
		{
			sb.append("instrument = ");
			sb.append(instrument);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (sample_preparation_id != null)
		{
			sb.append("sample_preparation_id = ");
			sb.append(sample_preparation_id);
			sb.append('\n');
		}
		if (temp != null)
		{
			sb.append("temp = ");
			sb.append(temp);
			sb.append('\n');
		}
		if (time_resolved_state != null)
		{
			sb.append("time_resolved_state = ");
			sb.append(time_resolved_state);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		citation_id = null;
		cryogen_name = null;
		details = null;
		entry_id = null;
		humidity = null;
		id_ = null;
		instrument = null;
		method = null;
		sample_preparation_id = null;
		temp = null;
		time_resolved_state = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_vitrification)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_vitrification>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (cryogen_name != null) ow.write(indent + " <PDBx:cryogen_name>" + cryogen_name + "</PDBx:cryogen_name>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (humidity != null) ow.write(indent + " <PDBx:humidity>" + humidity + "</PDBx:humidity>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (instrument != null) ow.write(indent + " <PDBx:instrument>" + instrument + "</PDBx:instrument>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (sample_preparation_id != null) ow.write(indent + " <PDBx:sample_preparation_id>" + sample_preparation_id + "</PDBx:sample_preparation_id>\n");
			if (temp != null) ow.write(indent + " <PDBx:temp>" + temp + "</PDBx:temp>\n");
			if (time_resolved_state != null) ow.write(indent + " <PDBx:time_resolved_state>" + time_resolved_state + "</PDBx:time_resolved_state>\n");
			ow.write(indent + "</PDBx:em_vitrification>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
