package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY category record details (such as
 *  chemical composition, name and source) about the molecular
 *  entities that are present in the crystallographic structure.
 *  
 *  Items in the various ENTITY subcategories provide a full
 *  chemical description of these molecular entities.
 *  
 *  Entities are of three types:  polymer, non-polymer and water.
 *  Note that the water category includes only water;  ordered
 *  solvent such as sulfate ion or acetone would be described as
 *  individual non-polymer entities.
 *  
 *  The ENTITY category is specific to macromolecular CIF
 *  applications and replaces the function of the CHEMICAL category
 *  in the CIF core.
 *  
 *  It is important to remember that the ENTITY data are not the
 *  result of the crystallographic experiment;  those results are
 *  represented by the ATOM_SITE data items. ENTITY data items
 *  describe the chemistry of the molecules under investigation
 *  and can most usefully be thought of as the ideal groups to which
 *  the structure is restrained or constrained during refinement.
 *  
 *  It is also important to remember that entities do not correspond
 *  directly to the enumeration of the contents of the asymmetric
 *  unit. Entities are described only once, even in those structures
 *  that contain multiple observations of an entity. The
 *  STRUCT_ASYM data items, which reference the entity list,
 *  describe and label the contents of the asymmetric unit.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entityCategory>
 *  <PDBx:entity id="1">
 *  <PDBx:type>polymer</PDBx:type>
 *  <PDBx:formula_weight>10916.</PDBx:formula_weight>
 *  <PDBx:details>              The enzymatically competent form of HIV
 *  protease is a dimer. This entity
 *  corresponds to one monomer of an active dimer.</PDBx:details>
 *  </PDBx:entity>
 *  <PDBx:entity id="2">
 *  <PDBx:type>non-polymer</PDBx:type>
 *  <PDBx:formula_weight>762.</PDBx:formula_weight>
 *  </PDBx:entity>
 *  <PDBx:entity id="3">
 *  <PDBx:type>water</PDBx:type>
 *  <PDBx:formula_weight>18.</PDBx:formula_weight>
 *  </PDBx:entity>
 *  </PDBx:entityCategory>
 * </pre>
 */
public class Entity extends org.pdb.beans.Entity implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity()
	{
	}

	/** Full constructor */
	public Entity(
		Datablock datablock,
		java.lang.String details,
		java.lang.Float formula_weight,
		java.lang.String id_,
		java.lang.String pdbx_description,
		java.lang.String pdbx_ec,
		java.lang.Float pdbx_formula_weight_exptl,
		java.lang.String pdbx_formula_weight_exptl_method,
		java.lang.String pdbx_fragment,
		java.lang.String pdbx_modification,
		java.lang.String pdbx_mutation,
		java.lang.Float pdbx_number_of_molecules,
		java.lang.String pdbx_parent_entity_id,
		java.lang.String pdbx_target_id,
		java.lang.String src_method,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.details = details;
		this.formula_weight = formula_weight;
		this.id_ = id_;
		this.pdbx_description = pdbx_description;
		this.pdbx_ec = pdbx_ec;
		this.pdbx_formula_weight_exptl = pdbx_formula_weight_exptl;
		this.pdbx_formula_weight_exptl_method = pdbx_formula_weight_exptl_method;
		this.pdbx_fragment = pdbx_fragment;
		this.pdbx_modification = pdbx_modification;
		this.pdbx_mutation = pdbx_mutation;
		this.pdbx_number_of_molecules = pdbx_number_of_molecules;
		this.pdbx_parent_entity_id = pdbx_parent_entity_id;
		this.pdbx_target_id = pdbx_target_id;
		this.src_method = src_method;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (formula_weight != null)
		{
			sb.append("formula_weight = ");
			sb.append(formula_weight);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_description != null)
		{
			sb.append("pdbx_description = ");
			sb.append(pdbx_description);
			sb.append('\n');
		}
		if (pdbx_ec != null)
		{
			sb.append("pdbx_ec = ");
			sb.append(pdbx_ec);
			sb.append('\n');
		}
		if (pdbx_formula_weight_exptl != null)
		{
			sb.append("pdbx_formula_weight_exptl = ");
			sb.append(pdbx_formula_weight_exptl);
			sb.append('\n');
		}
		if (pdbx_formula_weight_exptl_method != null)
		{
			sb.append("pdbx_formula_weight_exptl_method = ");
			sb.append(pdbx_formula_weight_exptl_method);
			sb.append('\n');
		}
		if (pdbx_fragment != null)
		{
			sb.append("pdbx_fragment = ");
			sb.append(pdbx_fragment);
			sb.append('\n');
		}
		if (pdbx_modification != null)
		{
			sb.append("pdbx_modification = ");
			sb.append(pdbx_modification);
			sb.append('\n');
		}
		if (pdbx_mutation != null)
		{
			sb.append("pdbx_mutation = ");
			sb.append(pdbx_mutation);
			sb.append('\n');
		}
		if (pdbx_number_of_molecules != null)
		{
			sb.append("pdbx_number_of_molecules = ");
			sb.append(pdbx_number_of_molecules);
			sb.append('\n');
		}
		if (pdbx_parent_entity_id != null)
		{
			sb.append("pdbx_parent_entity_id = ");
			sb.append(pdbx_parent_entity_id);
			sb.append('\n');
		}
		if (pdbx_target_id != null)
		{
			sb.append("pdbx_target_id = ");
			sb.append(pdbx_target_id);
			sb.append('\n');
		}
		if (src_method != null)
		{
			sb.append("src_method = ");
			sb.append(src_method);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		formula_weight = null;
		id_ = null;
		pdbx_description = null;
		pdbx_ec = null;
		pdbx_formula_weight_exptl = null;
		pdbx_formula_weight_exptl_method = null;
		pdbx_fragment = null;
		pdbx_modification = null;
		pdbx_mutation = null;
		pdbx_number_of_molecules = null;
		pdbx_parent_entity_id = null;
		pdbx_target_id = null;
		src_method = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (formula_weight != null) ow.write(indent + " <PDBx:formula_weight>" + formula_weight + "</PDBx:formula_weight>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_description != null) ow.write(indent + " <PDBx:pdbx_description>" + pdbx_description + "</PDBx:pdbx_description>\n");
			if (pdbx_ec != null) ow.write(indent + " <PDBx:pdbx_ec>" + pdbx_ec + "</PDBx:pdbx_ec>\n");
			if (pdbx_formula_weight_exptl != null) ow.write(indent + " <PDBx:pdbx_formula_weight_exptl>" + pdbx_formula_weight_exptl + "</PDBx:pdbx_formula_weight_exptl>\n");
			if (pdbx_formula_weight_exptl_method != null) ow.write(indent + " <PDBx:pdbx_formula_weight_exptl_method>" + pdbx_formula_weight_exptl_method + "</PDBx:pdbx_formula_weight_exptl_method>\n");
			if (pdbx_fragment != null) ow.write(indent + " <PDBx:pdbx_fragment>" + pdbx_fragment + "</PDBx:pdbx_fragment>\n");
			if (pdbx_modification != null) ow.write(indent + " <PDBx:pdbx_modification>" + pdbx_modification + "</PDBx:pdbx_modification>\n");
			if (pdbx_mutation != null) ow.write(indent + " <PDBx:pdbx_mutation>" + pdbx_mutation + "</PDBx:pdbx_mutation>\n");
			if (pdbx_number_of_molecules != null) ow.write(indent + " <PDBx:pdbx_number_of_molecules>" + pdbx_number_of_molecules + "</PDBx:pdbx_number_of_molecules>\n");
			if (pdbx_parent_entity_id != null) ow.write(indent + " <PDBx:pdbx_parent_entity_id>" + pdbx_parent_entity_id + "</PDBx:pdbx_parent_entity_id>\n");
			if (pdbx_target_id != null) ow.write(indent + " <PDBx:pdbx_target_id>" + pdbx_target_id + "</PDBx:pdbx_target_id>\n");
			if (src_method != null) ow.write(indent + " <PDBx:src_method>" + src_method + "</PDBx:src_method>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:entity>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
